/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.network.message.receive;

import com.atsuishio.superbwarfare.capability.ModCapabilities;
import com.atsuishio.superbwarfare.capability.player.PlayerVariable;
import com.atsuishio.superbwarfare.tools.Ammo;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public class PlayerVariablesSyncMessage {
    private final int target;
    private final Map<Byte, Integer> data;

    public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
        this.target = buffer.m_130242_();
        this.data = buffer.m_236847_(FriendlyByteBuf::readByte, FriendlyByteBuf::m_130242_);
    }

    public PlayerVariablesSyncMessage(int entityId, Map<Byte, Integer> data) {
        this.data = data;
        this.target = entityId;
    }

    public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
        buffer.m_130130_(message.target);
        buffer.m_236831_(message.data, (buf, key) -> buf.writeByte((int)key.byteValue()), FriendlyByteBuf::m_130130_);
    }

    public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            context.setPacketHandled(true);
            if (context.getDirection().getReceptionSide().isServer() || Minecraft.m_91087_().f_91074_ == null) {
                return;
            }
            Entity entity = Minecraft.m_91087_().f_91074_.m_9236_().m_6815_(message.target);
            if (entity == null) {
                return;
            }
            PlayerVariable variables = (PlayerVariable)entity.getCapability(ModCapabilities.PLAYER_VARIABLE, null).orElse((Object)new PlayerVariable());
            for (Map.Entry<Byte, Integer> entry : message.data.entrySet()) {
                Byte type = entry.getKey();
                if (type == -1) {
                    variables.tacticalSprint = entry.getValue() == 1;
                    continue;
                }
                Ammo[] types = Ammo.values();
                if (type >= types.length) continue;
                types[type].set(variables, (int)entry.getValue());
            }
        });
    }
}

