/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.network.message.send;

import com.atsuishio.superbwarfare.data.gun.AmmoConsumer;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.data.gun.GunProp;
import com.atsuishio.superbwarfare.data.gun.value.AttachmentType;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.item.gun.GunItem;
import com.atsuishio.superbwarfare.tools.SoundTool;
import java.util.Arrays;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class EditMessage {
    private final int type;
    private final boolean add;

    public EditMessage(int type, boolean add) {
        this.type = type;
        this.add = add;
    }

    public static EditMessage decode(FriendlyByteBuf buffer) {
        return new EditMessage(buffer.readInt(), buffer.readBoolean());
    }

    public static void encode(EditMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.type);
        buffer.writeBoolean(message.add);
    }

    public static void handler(EditMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player == null) {
                return;
            }
            ItemStack stack = player.m_21205_();
            Item patt1505$temp = stack.m_41720_();
            if (!(patt1505$temp instanceof GunItem)) {
                return;
            }
            GunItem gunItem = (GunItem)patt1505$temp;
            GunData data = GunData.from(stack);
            switch (message.type) {
                case 0: {
                    int att = data.attachment.get(AttachmentType.BARREL);
                    att = EditMessage.setAttachment(gunItem.getValidBarrels(), att, message.add);
                    data.attachment.set(AttachmentType.BARREL, att);
                    break;
                }
                case 1: {
                    int att = data.attachment.get(AttachmentType.SCOPE);
                    att = EditMessage.setAttachment(gunItem.getValidScopes(), att, message.add);
                    data.attachment.set(AttachmentType.SCOPE, att);
                    break;
                }
                case 2: {
                    int att = data.attachment.get(AttachmentType.GRIP);
                    att = EditMessage.setAttachment(gunItem.getValidGrips(), att, message.add);
                    data.attachment.set(AttachmentType.GRIP, att);
                    break;
                }
                case 3: {
                    int att = data.attachment.get(AttachmentType.STOCK);
                    att = EditMessage.setAttachment(gunItem.getValidStocks(), att, message.add);
                    data.attachment.set(AttachmentType.STOCK, att);
                    break;
                }
                case 4: {
                    int att = data.attachment.get(AttachmentType.MAGAZINE);
                    att = EditMessage.setAttachment(gunItem.getValidMagazines(), att, message.add);
                    data.withdrawAmmo((Entity)player);
                    data.attachment.set(AttachmentType.MAGAZINE, att);
                    break;
                }
                case 5: {
                    int diff = message.add ? 1 : -1;
                    int selectedAmmoType = data.selectedAmmoType.get() + diff;
                    if (!player.m_7500_() && selectedAmmoType >= 0 && selectedAmmoType <= data.ammoConsumers.size() - 1) {
                        AmmoConsumer targetConsumer;
                        AmmoConsumer currentConsumer = data.selectedAmmoConsumer();
                        if (currentConsumer == (targetConsumer = data.ammoConsumers.get(selectedAmmoType))) {
                            return;
                        }
                        String currentSlot = currentConsumer.ammoSlot;
                        String targetSlot = targetConsumer.ammoSlot;
                        if (currentSlot == null) {
                            currentSlot = "Default";
                        }
                        if (targetSlot == null) {
                            targetSlot = "Default";
                        }
                        if (currentSlot.equals(targetSlot)) {
                            data.withdrawAmmo((Entity)player);
                        } else {
                            int ammo = data.ammo.get();
                            int virtualAmmo = data.virtualAmmo.get();
                            data.ammoSlot.set(currentSlot, ammo, virtualAmmo);
                            data.ammo.set(data.ammoSlot.getAmmo(targetSlot));
                            data.virtualAmmo.set(data.ammoSlot.getVirtualAmmo(targetSlot));
                            data.ammoSlot.reset(targetSlot);
                        }
                    }
                    data.changeAmmoConsumer(selectedAmmoType);
                    if (player.m_7500_()) {
                        data.ammo.set(data.get(GunProp.MAGAZINE));
                    }
                    data.isEmpty.set(true);
                    data.holdOpen.set(true);
                    data.closeHammer.set(false);
                }
            }
            SoundTool.playLocalSound(player, (SoundEvent)ModSounds.EDIT.get(), 1.0f, 1.0f);
        });
        context.setPacketHandled(true);
    }

    private static int setAttachment(int[] arr, int value, boolean add) {
        if (arr.length == 0) {
            return 0;
        }
        int[] sorted = Arrays.copyOf(arr, arr.length);
        Arrays.sort(sorted);
        int index = Arrays.binarySearch(sorted, value);
        if (index < 0) {
            index = -index - 1;
        }
        index = add ? (index + 1) % arr.length : (index + arr.length - 1) % arr.length;
        return sorted[index];
    }
}

