/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.network.message.send;

import com.atsuishio.superbwarfare.entity.vehicle.DroneEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.tools.EntityFindUtil;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class MouseMoveMessage {
    private final double speedX;
    private final double speedY;

    public MouseMoveMessage(double speedX, double speedY) {
        this.speedX = speedX;
        this.speedY = speedY;
    }

    public static void encode(MouseMoveMessage message, FriendlyByteBuf byteBuf) {
        byteBuf.writeDouble(message.speedX);
        byteBuf.writeDouble(message.speedY);
    }

    public static MouseMoveMessage decode(FriendlyByteBuf byteBuf) {
        return new MouseMoveMessage(byteBuf.readDouble(), byteBuf.readDouble());
    }

    public static void handler(MouseMoveMessage message, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            DroneEntity drone;
            ItemStack stack;
            ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
            if (player == null) {
                return;
            }
            Entity entity = player.m_20202_();
            if (entity instanceof VehicleEntity) {
                VehicleEntity vehicle = (VehicleEntity)entity;
                vehicle.mouseInput(message.speedX, message.speedY);
            }
            if ((stack = player.m_21205_()).m_150930_((Item)ModItems.MONITOR.get()) && stack.m_41784_().m_128471_("Using") && stack.m_41784_().m_128471_("Linked") && (drone = EntityFindUtil.findDrone(player.m_9236_(), stack.m_41784_().m_128461_("LinkedDrone"))) != null) {
                drone.mouseInput(message.speedX, message.speedY);
            }
        });
        context.get().setPacketHandled(true);
    }
}

