/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.network.message.send;

import com.atsuishio.superbwarfare.entity.vehicle.Hpj11Entity;
import com.atsuishio.superbwarfare.entity.vehicle.LaserTowerEntity;
import com.atsuishio.superbwarfare.menu.FuMO25Menu;
import com.atsuishio.superbwarfare.tools.EntityFindUtil;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.StreamSupport;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.network.NetworkEvent;

public class RadarSetTargetMessage {
    private final UUID targetUUID;

    public RadarSetTargetMessage(UUID targetUUID) {
        this.targetUUID = targetUUID;
    }

    public static void encode(RadarSetTargetMessage message, FriendlyByteBuf buffer) {
        buffer.m_130077_(message.targetUUID);
    }

    public static RadarSetTargetMessage decode(FriendlyByteBuf buffer) {
        return new RadarSetTargetMessage(buffer.m_130259_());
    }

    public static void handler(RadarSetTargetMessage message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            AbstractContainerMenu menu = player.f_36096_;
            if (menu instanceof FuMO25Menu) {
                FuMO25Menu fuMO25Menu = (FuMO25Menu)menu;
                if (!player.f_36096_.m_6875_((Player)player)) {
                    return;
                }
                fuMO25Menu.getSelfPos().ifPresent(pos -> {
                    List<Entity> entities = StreamSupport.stream(EntityFindUtil.getEntities(player.m_9236_()).m_142273_().spliterator(), false).filter(e -> {
                        Hpj11Entity hpj11Entity;
                        LaserTowerEntity towerEntity;
                        return e instanceof LaserTowerEntity && (towerEntity = (LaserTowerEntity)e).m_269323_() == player && towerEntity.m_20270_((Entity)player) <= 16.0f || e instanceof Hpj11Entity && (hpj11Entity = (Hpj11Entity)e).m_269323_() == player && hpj11Entity.m_20270_((Entity)player) <= 16.0f;
                    }).toList();
                    entities.forEach(e -> RadarSetTargetMessage.setTarget(e, message.targetUUID.toString()));
                });
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public static void setTarget(Entity e, String uuid) {
        if (e instanceof LaserTowerEntity) {
            LaserTowerEntity laserTower = (LaserTowerEntity)e;
            laserTower.m_20088_().m_135381_(LaserTowerEntity.TARGET_UUID, (Object)uuid);
        } else if (e instanceof Hpj11Entity) {
            Hpj11Entity hpj11Entity = (Hpj11Entity)e;
            hpj11Entity.m_20088_().m_135381_(Hpj11Entity.TARGET_UUID, (Object)uuid);
        }
    }
}

