/*
 * Decompiled with CFR 0.152.
 */
package net.jacobwasbeast.picaxe.blocks.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.jacobwasbeast.picaxe.blocks.entities.ImageBannerBlockEntity;
import net.jacobwasbeast.picaxe.utils.ImageUtils;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.BannerBlock;
import net.minecraft.world.level.block.WallBannerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class ImageBannerBlockRenderer
implements BlockEntityRenderer<ImageBannerBlockEntity> {
    private final ModelPart flag;
    private final ModelPart pole;
    private final ModelPart bar;

    public ImageBannerBlockRenderer(BlockEntityRendererProvider.Context context) {
        ModelPart modelPart = context.m_173582_(ModelLayers.f_171264_);
        this.flag = modelPart.m_171324_("flag");
        this.pole = modelPart.m_171324_("pole");
        this.bar = modelPart.m_171324_("bar");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.m_171576_();
        partDefinition.m_171599_("flag", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-10.0f, 0.0f, -2.0f, 20.0f, 40.0f, 1.0f), PartPose.f_171404_);
        partDefinition.m_171599_("pole", CubeListBuilder.m_171558_().m_171514_(44, 0).m_171481_(-1.0f, -30.0f, -1.0f, 2.0f, 42.0f, 2.0f), PartPose.f_171404_);
        partDefinition.m_171599_("bar", CubeListBuilder.m_171558_().m_171514_(0, 42).m_171481_(-10.0f, -32.0f, -1.0f, 20.0f, 2.0f, 2.0f), PartPose.f_171404_);
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)64, (int)64);
    }

    public void render(ImageBannerBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        float xRot;
        String imageUrl = blockEntity.getImageLocation();
        poseStack.m_85836_();
        long gameTime = blockEntity.m_58898_() ? blockEntity.m_58904_().m_46467_() : 0L;
        BlockState blockState = blockEntity.m_58900_();
        if (blockState.m_60734_() instanceof BannerBlock) {
            poseStack.m_85837_(0.5, 0.5, 0.5);
            rotation = (float)(-((Integer)blockState.m_61143_((Property)BannerBlock.f_49007_) * 360)) / 16.0f;
            poseStack.m_252781_(Axis.f_252436_.m_252977_(rotation));
            this.pole.f_104207_ = true;
        } else {
            poseStack.m_85837_(0.5, -0.16666667, 0.5);
            rotation = -((Direction)blockState.m_61143_((Property)WallBannerBlock.f_57916_)).m_122435_();
            poseStack.m_252781_(Axis.f_252436_.m_252977_(rotation));
            poseStack.m_85837_(0.0, -0.3125, -0.4375);
            this.pole.f_104207_ = false;
        }
        poseStack.m_85836_();
        poseStack.m_85841_(0.6666667f, -0.6666667f, -0.6666667f);
        VertexConsumer poleAndBarConsumer = ModelBakery.f_119224_.m_119194_(bufferSource, RenderType::m_110446_);
        this.pole.m_104301_(poseStack, poleAndBarConsumer, packedLight, packedOverlay);
        this.bar.m_104301_(poseStack, poleAndBarConsumer, packedLight, packedOverlay);
        BlockPos blockPos = blockEntity.m_58899_();
        float windAnimation = ((float)Math.floorMod((long)(blockPos.m_123341_() * 7 + blockPos.m_123342_() * 9 + blockPos.m_123343_() * 13) + gameTime, 100L) + partialTick) / 100.0f;
        this.flag.f_104203_ = xRot = (-0.0125f + 0.01f * Mth.m_14089_((float)((float)Math.PI * 2 * windAnimation))) * (float)Math.PI;
        this.flag.f_104201_ = -32.0f;
        VertexConsumer flagConsumer = ModelBakery.f_119224_.m_119194_(bufferSource, RenderType::m_110446_);
        float[] colors = blockEntity.getColor().m_41068_();
        this.flag.m_104306_(poseStack, flagConsumer, packedLight, packedOverlay, colors[0], colors[1], colors[2], 1.0f);
        if (imageUrl != null && !imageUrl.equals("picaxe:blocks/banner") && !imageUrl.isBlank()) {
            poseStack.m_85836_();
            this.flag.m_104299_(poseStack);
            poseStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
            poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
            poseStack.m_85837_(-0.5, -0.88, -1.75);
            ImageUtils.renderImageFromURL(poseStack, bufferSource, packedLight, packedOverlay, partialTick, 1.25f, 2.5f, imageUrl);
            poseStack.m_85849_();
        }
        poseStack.m_85849_();
        poseStack.m_85849_();
    }
}

