/*
 * Decompiled with CFR 0.152.
 */
package net.jacobwasbeast.picaxe.gui;

import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.jacobwasbeast.picaxe.api.ImageFrameAlignment;
import net.jacobwasbeast.picaxe.blocks.entities.ImageFrameBlockEntity;
import net.jacobwasbeast.picaxe.network.UpdateImageFramePayload;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class ImageFrameConfigScreen
extends Screen {
    private static final int BACKGROUND_COLOR = -436207616;
    private static final int PANEL_COLOR = -870967786;
    private static final int ACCENT_COLOR = -11688961;
    private static final int TEXT_COLOR = -1;
    private static final int SUBTITLE_COLOR = -6643546;
    private static final int ERROR_COLOR = -42389;
    private static final int SUCCESS_COLOR = -13710223;
    private static final int REMOVE_COLOR = -26035;
    private static final int BASE_PANEL_W = 560;
    private static final int BASE_PANEL_H = 460;
    private static final int BASE_MARGIN = 24;
    private static final int BASE_GAP_Y = 10;
    private static final int BASE_INPUT_H = 22;
    private static final int BASE_CHIP_H = 24;
    private static final int BASE_GRID_CELL_W = 84;
    private static final int BASE_GRID_CELL_H = 24;
    private static final int BASE_GRID_GAP = 6;
    private static final int BASE_OFF_INPUT_W = 64;
    private static final int BASE_OFF_ROW_GAP = 6;
    private static final int BASE_OFF_HDR_GAP = 18;
    private final ImageFrameBlockEntity blockEntity;
    private EditBox urlInput;
    private EditBox widthInput;
    private EditBox heightInput;
    private EditBox offXInput;
    private EditBox offYInput;
    private EditBox offZInput;
    private Chip stretchChip;
    private boolean shouldStretch;
    private ImageFrameAlignment alignment;
    private String errorMessage = "";
    private int errorTimer = 0;
    private float uiScale = 1.0f;
    private int panelX;
    private int panelY;
    private int panelW;
    private int panelH;
    private int margin;
    private int gapY;
    private int inputH;
    private int chipH;
    private int gridCellW;
    private int gridCellH;
    private int gridGap;
    private int offInputW;
    private int offRowGap;
    private int offHeaderGap;
    private int inputWidth;
    private int urlHelperH;
    private Rect urlRect;
    private Rect widthRect;
    private Rect heightRect;
    private final List<Chip> chips = new ArrayList<Chip>();
    private final List<Chip> alignmentChips = new ArrayList<Chip>();
    private final List<LaterLabel> drawLaterLabels = new ArrayList<LaterLabel>();
    private final List<EditBox> offsetBoxes = new ArrayList<EditBox>();

    private int S(int v) {
        return Math.max(1, Math.round((float)v * this.uiScale));
    }

    public ImageFrameConfigScreen(ImageFrameBlockEntity be) {
        super((Component)Component.m_237115_((String)"picaxe.screen.image_frame.title"));
        this.blockEntity = be;
        this.shouldStretch = be.shouldStretchToFit();
        this.alignment = be.getAlignment();
    }

    private Component getStretchLabel() {
        return (this.shouldStretch ? Component.m_237115_((String)"picaxe.screen.image_frame.stretch_icon_on") : Component.m_237115_((String)"picaxe.screen.image_frame.stretch_icon_off")).m_6881_().m_130946_("  ").m_7220_((Component)Component.m_237110_((String)"picaxe.screen.image_frame.stretch_mode", (Object[])new Object[]{this.shouldStretch ? Component.m_237115_((String)"picaxe.screen.image_frame.stretch_on") : Component.m_237115_((String)"picaxe.screen.image_frame.stretch_off")}));
    }

    protected void m_7856_() {
        super.m_7856_();
        this.chips.clear();
        this.alignmentChips.clear();
        this.drawLaterLabels.clear();
        this.offsetBoxes.clear();
        float fitW = ((float)this.f_96543_ - 32.0f) / 560.0f;
        float fitH = ((float)this.f_96544_ - 32.0f) / 460.0f;
        this.uiScale = Math.min(1.0f, Math.max(0.5f, Math.min(fitW, fitH)));
        this.panelW = this.S(560);
        this.panelH = this.S(460);
        this.margin = this.S(24);
        this.gapY = this.S(10);
        this.inputH = this.S(22);
        this.chipH = this.S(24);
        this.gridCellW = this.S(84);
        this.gridCellH = this.S(24);
        this.gridGap = this.S(6);
        this.offInputW = this.S(64);
        this.offRowGap = this.S(6);
        this.offHeaderGap = this.S(18);
        Objects.requireNonNull(this.f_96547_);
        this.urlHelperH = 9 + this.S(8);
        this.panelX = (this.f_96543_ - this.panelW) / 2;
        this.panelY = (this.f_96544_ - this.panelH) / 2;
        int y = this.panelY + this.margin;
        int smallBtnW = this.S(22);
        int smallBtnGap = this.S(6);
        int urlX = this.panelX + this.margin;
        int urlY = y + this.S(18);
        int urlW = this.panelW - this.margin * 2 - smallBtnW * 2 - smallBtnGap * 2;
        this.urlInput = new EditBox(this.f_96547_, urlX, urlY, urlW, this.inputH, (Component)Component.m_237115_((String)"picaxe.screen.image_frame.url"));
        this.urlInput.m_94199_(256);
        this.urlInput.m_94144_(this.blockEntity.getImageUrl());
        this.urlInput.m_257771_((Component)Component.m_237115_((String)"picaxe.screen.image_frame.url_hint"));
        this.urlInput.m_94182_(false);
        this.urlInput.m_94202_(-1);
        this.urlInput.m_94205_(-4473925);
        this.urlInput.m_94151_(s -> this.inputsValid());
        this.m_7787_((GuiEventListener)this.urlInput);
        this.m_264313_((GuiEventListener)this.urlInput);
        this.urlRect = new Rect(urlX, urlY, urlW, this.inputH);
        int pasteX = urlX + urlW + smallBtnGap;
        int pasteY = urlY;
        this.addChip(pasteX, pasteY, smallBtnW, this.inputH, (Component)Component.m_237113_((String)"\u2398"), true, () -> {
            String clip = Minecraft.m_91087_().f_91068_.m_90876_();
            if (clip != null) {
                this.urlInput.m_94144_(clip.trim());
                this.inputsValid();
            }
        });
        int clearX = pasteX + smallBtnW + smallBtnGap;
        this.addChip(clearX, pasteY, smallBtnW, this.inputH, (Component)Component.m_237113_((String)"\u2715"), false, () -> {
            this.urlInput.m_94144_("");
            this.inputsValid();
        });
        y = urlY + this.inputH + this.urlHelperH + this.gapY;
        int colsGap = this.S(30);
        this.inputWidth = (this.panelW - this.margin * 2 - colsGap) / 2;
        int wX = this.panelX + this.margin;
        int wW = this.inputWidth - this.S(60);
        this.widthInput = new EditBox(this.f_96547_, wX, y, wW, this.inputH, (Component)Component.m_237113_((String)"W"));
        this.widthInput.m_94144_(String.valueOf(this.blockEntity.getFrameWidth()));
        this.widthInput.m_257771_((Component)Component.m_237113_((String)"1\u20136"));
        this.widthInput.m_94182_(false);
        this.widthInput.m_94202_(-1);
        this.widthInput.m_94205_(-4473925);
        this.widthInput.m_94153_(s -> s.isEmpty() || s.matches("[1-6]?"));
        this.widthInput.m_94151_(s -> this.inputsValid());
        this.m_7787_((GuiEventListener)this.widthInput);
        this.widthRect = new Rect(wX, y, wW, this.inputH);
        int hX = this.panelX + this.margin + this.inputWidth + colsGap;
        int hW = this.inputWidth - this.S(60);
        this.heightInput = new EditBox(this.f_96547_, hX, y, hW, this.inputH, (Component)Component.m_237113_((String)"H"));
        this.heightInput.m_94144_(String.valueOf(this.blockEntity.getFrameHeight()));
        this.heightInput.m_257771_((Component)Component.m_237113_((String)"1\u20136"));
        this.heightInput.m_94182_(false);
        this.heightInput.m_94202_(-1);
        this.heightInput.m_94205_(-4473925);
        this.heightInput.m_94153_(s -> s.isEmpty() || s.matches("[1-6]?"));
        this.heightInput.m_94151_(s -> this.inputsValid());
        this.m_7787_((GuiEventListener)this.heightInput);
        this.heightRect = new Rect(hX, y, hW, this.inputH);
        int stepY = y;
        this.addChip(wX + wW + this.S(6), stepY, this.S(22), this.inputH, (Component)Component.m_237113_((String)"\u2013"), false, () -> this.adjustInt(this.widthInput, -1));
        this.addChip(wX + wW + this.S(6) + this.S(24), stepY, this.S(22), this.inputH, (Component)Component.m_237113_((String)"+"), true, () -> this.adjustInt(this.widthInput, 1));
        this.addChip(hX + hW + this.S(6), stepY, this.S(22), this.inputH, (Component)Component.m_237113_((String)"\u2013"), false, () -> this.adjustInt(this.heightInput, -1));
        this.addChip(hX + hW + this.S(6) + this.S(24), stepY, this.S(22), this.inputH, (Component)Component.m_237113_((String)"+"), true, () -> this.adjustInt(this.heightInput, 1));
        y = y + this.inputH + this.gapY + this.S(6);
        int gridLeft = this.panelX + this.margin;
        this.drawLaterLabels.add(new LaterLabel((Component)Component.m_237115_((String)"picaxe.screen.image_frame.alignment"), gridLeft, y, -6643546));
        int gridTop = y + this.S(14) + this.S(6);
        this.addAlignmentRow(gridLeft, gridTop, this.gridCellW, this.gridCellH, ImageFrameAlignment.TOP_LEFT, "\u2196", ImageFrameAlignment.TOP_CENTER, "\u2191", ImageFrameAlignment.TOP_RIGHT, "\u2197");
        this.addAlignmentRow(gridLeft, gridTop + this.gridCellH + this.gridGap, this.gridCellW, this.gridCellH, ImageFrameAlignment.CENTER_LEFT, "\u2190", ImageFrameAlignment.CENTER, "\u2022", ImageFrameAlignment.CENTER_RIGHT, "\u2192");
        this.addAlignmentRow(gridLeft, gridTop + 2 * (this.gridCellH + this.gridGap), this.gridCellW, this.gridCellH, ImageFrameAlignment.BOTTOM_LEFT, "\u2199", ImageFrameAlignment.BOTTOM_CENTER, "\u2193", ImageFrameAlignment.BOTTOM_RIGHT, "\u2198");
        int gridWidthTotal = 3 * this.gridCellW + 2 * this.gridGap;
        int gridBottom = gridTop + 3 * this.gridCellH + 2 * this.gridGap;
        int offsetsColX = gridLeft + gridWidthTotal + this.S(24);
        int offsetsColRight = this.panelX + this.panelW - this.margin;
        offsetsColX = Math.min(offsetsColX, Math.max(gridLeft, offsetsColRight - this.offInputW));
        int offsetsHeaderY = y;
        this.drawLaterLabels.add(new LaterLabel((Component)Component.m_237115_((String)"picaxe.screen.image_frame.offsets_blocks"), offsetsColX, offsetsHeaderY, -6643546));
        int fieldCenterOffset = (this.gridCellH - this.inputH) / 2;
        int smallBtnWOffset = this.S(18);
        int smallBtnGapOffset = this.S(2);
        int afterBoxX = offsetsColX + this.offInputW + smallBtnGapOffset;
        int offX_Y = gridTop + fieldCenterOffset;
        this.offXInput = this.makeOffsetBox(offsetsColX, offX_Y, "X", this.blockEntity.getOffsetX());
        this.addOffsetSteppers(this.offXInput, afterBoxX, offX_Y, smallBtnWOffset);
        int offY_Y = gridTop + (this.gridCellH + this.gridGap) + fieldCenterOffset;
        this.offYInput = this.makeOffsetBox(offsetsColX, offY_Y, "Y", this.blockEntity.getOffsetY());
        this.addOffsetSteppers(this.offYInput, afterBoxX, offY_Y, smallBtnWOffset);
        int offZ_Y = gridTop + 2 * (this.gridCellH + this.gridGap) + fieldCenterOffset;
        this.offZInput = this.makeOffsetBox(offsetsColX, offZ_Y, "Z", this.blockEntity.getOffsetZ());
        this.addOffsetSteppers(this.offZInput, afterBoxX, offZ_Y, smallBtnWOffset);
        int offsetsBottom = offZ_Y + this.inputH;
        int sectionBottom = Math.max(gridBottom, offsetsBottom);
        int nextY = sectionBottom + this.S(20);
        this.stretchChip = new Chip(this.panelX + this.margin, nextY, this.panelW - this.margin * 2, this.chipH, this.getStretchLabel(), -14736599, -14275790, -1, false, () -> {
            this.shouldStretch = !this.shouldStretch;
            this.stretchChip.label = this.getStretchLabel();
        });
        this.chips.add(this.stretchChip);
        int bw = (this.panelW - this.margin * 2 - this.S(30)) / 2;
        int bottomButtonsY = nextY + this.chipH + this.S(12);
        this.addChip(this.panelX + this.margin, bottomButtonsY, bw, this.chipH, (Component)Component.m_237115_((String)"picaxe.screen.image_frame.confirm_button"), true, this::submitIfValid);
        this.addChip(this.panelX + this.margin + bw + this.S(30), bottomButtonsY, bw, this.chipH, (Component)Component.m_237115_((String)"picaxe.screen.image_frame.cancel_button"), false, () -> this.f_96541_.m_91152_(null));
    }

    private EditBox makeOffsetBox(int x, int y, String label, double initial) {
        this.drawLaterLabels.add(new LaterLabel((Component)Component.m_237113_((String)(label + " (blk)")), x, y - this.S(12), -6643546));
        EditBox box = new EditBox(this.f_96547_, x, y, this.offInputW, this.inputH, (Component)Component.m_237113_((String)label));
        box.m_94182_(false);
        box.m_94199_(32);
        box.m_94202_(-1);
        box.m_94205_(-4473925);
        box.m_94144_(this.trimDoubleToString(initial));
        this.m_7787_((GuiEventListener)box);
        this.offsetBoxes.add(box);
        return box;
    }

    private void addOffsetSteppers(EditBox box, int baseX, int y, int btnW) {
        this.addChip(baseX, y, btnW, this.inputH, (Component)Component.m_237113_((String)"\u2013"), false, () -> this.adjustDouble(box, -0.05));
        this.addChip(baseX + btnW + this.S(2), y, btnW, this.inputH, (Component)Component.m_237113_((String)"+"), true, () -> this.adjustDouble(box, 0.05));
    }

    private void adjustDouble(EditBox box, double delta) {
        double cur = this.safeDouble(box.m_94155_(), 0.0);
        double newVal = (double)Math.round((cur + delta) * 100.0) / 100.0;
        box.m_94144_(this.trimDoubleToString(newVal));
        this.inputsValid();
    }

    private String trimDoubleToString(double v) {
        String s = Double.toString(v);
        if (s.endsWith(".0")) {
            s = s.substring(0, s.length() - 2);
        }
        return s;
    }

    private void addAlignmentRow(int x, int y, int w, int h, ImageFrameAlignment a1, String l1, ImageFrameAlignment a2, String l2, ImageFrameAlignment a3, String l3) {
        this.addAlignChip(x, y, w, h, a1, l1);
        this.addAlignChip(x + w + this.gridGap, y, w, h, a2, l2);
        this.addAlignChip(x + 2 * (w + this.gridGap), y, w, h, a3, l3);
    }

    private void addAlignChip(int x, int y, int w, int h, ImageFrameAlignment align, String symbol) {
        Chip c = new Chip(x, y, w, h, (Component)Component.m_237113_((String)(symbol + "  ")).m_7220_((Component)Component.m_237115_((String)("picaxe.screen.image_frame.align." + align.name().toLowerCase()))), -14736599, -14275790, -1, false, () -> {
            this.alignment = align;
        });
        c.alignValue = align;
        this.alignmentChips.add(c);
        this.chips.add(c);
    }

    private void addChip(int x, int y, int w, int h, Component label, boolean primary, Runnable action) {
        int bg = primary ? -13934337 : -14736599;
        int bgHover = primary ? -12882689 : -14275790;
        int fg = -1;
        this.chips.add(new Chip(x, y, w, h, label, bg, bgHover, fg, primary, action));
    }

    private void adjustInt(EditBox box, int delta) {
        this.adjustInt(box, delta, 1, 6);
    }

    private void adjustInt(EditBox box, int delta, int min, int max) {
        int cur = this.safeInt(box.m_94155_(), min);
        cur = Mth.m_14045_((int)(cur + delta), (int)min, (int)max);
        box.m_94144_(String.valueOf(cur));
        this.inputsValid();
    }

    private int safeInt(String s, int def) {
        try {
            return Integer.parseInt(s);
        }
        catch (Exception e) {
            return def;
        }
    }

    private double safeDouble(String s, double def) {
        try {
            return Double.parseDouble(s);
        }
        catch (Exception e) {
            return def;
        }
    }

    private boolean inputsValid() {
        try {
            int w = Integer.parseInt(this.widthInput.m_94155_());
            int h = Integer.parseInt(this.heightInput.m_94155_());
            if (w < 1 || h < 1) {
                this.setEphemeralError("picaxe.screen.image_frame.error.negative_dimensions");
                return false;
            }
            if (w > 6 || h > 6) {
                this.setEphemeralError("picaxe.screen.image_frame.error.dimensions_too_large");
                return false;
            }
        }
        catch (NumberFormatException e) {
            this.setEphemeralError("picaxe.screen.image_frame.error.invalid_dimensions");
            return false;
        }
        for (EditBox b : this.offsetBoxes) {
            if (b.m_94155_().isEmpty()) continue;
            try {
                Double.parseDouble(b.m_94155_());
            }
            catch (NumberFormatException ex) {
                this.setEphemeralError("picaxe.screen.image_frame.error.invalid_offset");
                return false;
            }
        }
        this.errorMessage = "";
        return true;
    }

    private void setEphemeralError(String key) {
        this.errorMessage = Component.m_237115_((String)key).getString();
        this.errorTimer = 50;
    }

    private void submitIfValid() {
        if (!this.inputsValid()) {
            return;
        }
        int width = this.safeInt(this.widthInput.m_94155_(), this.blockEntity.getFrameWidth());
        int height = this.safeInt(this.heightInput.m_94155_(), this.blockEntity.getFrameHeight());
        double offX = this.safeDouble(this.offXInput.m_94155_(), 0.0);
        double offY = this.safeDouble(this.offYInput.m_94155_(), 0.0);
        double offZ = this.safeDouble(this.offZInput.m_94155_(), 0.0);
        String url = this.urlInput.m_94155_().trim();
        BlockPos pos = this.blockEntity.m_58899_();
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        UpdateImageFramePayload payload = new UpdateImageFramePayload(pos, url, width, height, this.shouldStretch, this.alignment, offX, offY, offZ);
        payload.write(buf);
        NetworkManager.sendToServer((ResourceLocation)UpdateImageFramePayload.TYPE, (FriendlyByteBuf)buf);
        this.f_96541_.m_91152_(null);
    }

    private void drawInput(GuiGraphics g, Rect r, boolean focused) {
        int x = r.x;
        int y = r.y;
        int w = r.w;
        int h = r.h;
        int bg = focused ? -14539736 : -15066338;
        int bd = focused ? -11688961 : -14013392;
        g.m_280509_(x, y, x + w, y + h, bg);
        g.m_280509_(x - 1, y - 1, x + w + 1, y, bd);
        g.m_280509_(x - 1, y + h, x + w + 1, y + h + 1, bd);
        g.m_280509_(x - 1, y, x, y + h, bd);
        g.m_280509_(x + w, y, x + w + 1, y + h, bd);
    }

    private void drawChip(GuiGraphics g, Chip c, boolean hover, boolean selectedAlign) {
        int bg;
        int n = bg = hover ? c.bgHover : c.bg;
        if (selectedAlign) {
            g.m_280509_(c.x - 1, c.y - 1, c.x + c.w + 1, c.y, -11688961);
            g.m_280509_(c.x - 1, c.y + c.h, c.x + c.w + 1, c.y + c.h + 1, -11688961);
            g.m_280509_(c.x - 1, c.y, c.x, c.y + c.h, -11688961);
            g.m_280509_(c.x + c.w, c.y, c.x + c.w + 1, c.y + c.h, -11688961);
        }
        g.m_280509_(c.x, c.y, c.x + c.w, c.y + c.h, bg);
        g.m_280653_(this.f_96547_, c.label, c.x + c.w / 2, c.y + (c.h - 8) / 2, c.fg);
    }

    public void m_86600_() {
        super.m_86600_();
        if (this.errorTimer > 0) {
            --this.errorTimer;
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        for (Chip c : this.chips) {
            if (!c.hit(mouseX, mouseY)) continue;
            c.action.run();
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        String clip;
        if (keyCode == 257 || keyCode == 335) {
            this.submitIfValid();
            return true;
        }
        if (keyCode == 256) {
            this.f_96541_.m_91152_(null);
            return true;
        }
        if ((modifiers & 2) != 0 && keyCode == 86 && (clip = Minecraft.m_91087_().f_91068_.m_90876_()) != null) {
            this.urlInput.m_94144_(clip.trim());
            this.inputsValid();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public void m_88315_(GuiGraphics gui, int mouseX, int mouseY, float partialTick) {
        gui.m_280509_(0, 0, this.f_96543_, this.f_96544_, -436207616);
        gui.m_280509_(this.panelX + 3, this.panelY + 3, this.panelX + this.panelW + 3, this.panelY + this.panelH + 3, 0x30000000);
        gui.m_280509_(this.panelX, this.panelY, this.panelX + this.panelW, this.panelY + this.panelH, -870967786);
        gui.m_280509_(this.panelX, this.panelY, this.panelX + this.panelW, this.panelY + this.S(3), -11688961);
        gui.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, this.panelY + this.S(12), -1);
        gui.m_280653_(this.f_96547_, (Component)Component.m_237115_((String)"picaxe.screen.image_frame.subtitle"), this.f_96543_ / 2, this.panelY + this.S(28), -6643546);
        gui.m_280509_(this.panelX + this.margin, this.panelY + this.S(50), this.panelX + this.panelW - this.margin, this.panelY + this.S(51), 0x36FFFFFF);
        gui.m_280430_(this.f_96547_, (Component)Component.m_237115_((String)"picaxe.screen.image_frame.url_label"), this.urlRect.x, this.urlRect.y - this.S(14), -6643546);
        gui.m_280430_(this.f_96547_, (Component)Component.m_237113_((String)"W \u00d7 H (1\u20136)"), this.widthRect.x, this.widthRect.y - this.S(14), -6643546);
        this.drawInput(gui, this.urlRect, this.urlInput.m_93696_());
        this.drawInput(gui, this.widthRect, this.widthInput.m_93696_());
        this.drawInput(gui, this.heightRect, this.heightInput.m_93696_());
        if (this.urlInput.m_94155_().trim().isEmpty()) {
            gui.m_280509_(this.urlRect.x - this.S(10), this.urlRect.y, this.urlRect.x - this.S(8), this.urlRect.y + this.urlRect.h, -26035);
            int helperTop = this.urlRect.y + this.urlRect.h + this.S(4);
            int helperBottom = helperTop + this.urlHelperH - this.S(4);
            gui.m_280509_(this.urlRect.x, helperTop - this.S(2), this.urlRect.x + this.urlRect.w, helperBottom, 1713316649);
            gui.m_280430_(this.f_96547_, (Component)Component.m_237115_((String)"picaxe.screen.image_frame.remove_mode"), this.urlRect.x + this.S(4), helperTop, -26035);
        } else {
            gui.m_280509_(this.urlRect.x - this.S(10), this.urlRect.y, this.urlRect.x - this.S(8), this.urlRect.y + this.urlRect.h, -13710223);
        }
        for (Chip c : this.chips) {
            boolean hover = c.hit(mouseX, mouseY);
            this.drawChip(gui, c, hover, c.alignValue != null && c.alignValue == this.alignment);
        }
        for (LaterLabel lbl : this.drawLaterLabels) {
            gui.m_280430_(this.f_96547_, lbl.text, lbl.x, lbl.y, lbl.color);
        }
        if (this.errorTimer > 0 && !this.errorMessage.isEmpty()) {
            int errorAlpha = Math.min(255, this.errorTimer * 255 / 50);
            int errorColor = errorAlpha << 24 | 0xFF5A6B;
            gui.m_280137_(this.f_96547_, this.errorMessage, this.f_96543_ / 2, this.panelY + this.panelH - this.S(56), errorColor);
        }
        super.m_88315_(gui, mouseX, mouseY, partialTick);
        this.urlInput.m_88315_(gui, mouseX, mouseY, partialTick);
        this.widthInput.m_88315_(gui, mouseX, mouseY, partialTick);
        this.heightInput.m_88315_(gui, mouseX, mouseY, partialTick);
        for (EditBox b : this.offsetBoxes) {
            b.m_88315_(gui, mouseX, mouseY, partialTick);
        }
    }

    public boolean m_7043_() {
        return false;
    }

    private static class Rect {
        int x;
        int y;
        int w;
        int h;

        Rect(int x, int y, int w, int h) {
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
        }
    }

    private static class LaterLabel {
        Component text;
        int x;
        int y;
        int color;

        LaterLabel(Component t, int x, int y, int c) {
            this.text = t;
            this.x = x;
            this.y = y;
            this.color = c;
        }
    }

    private static class Chip {
        int x;
        int y;
        int w;
        int h;
        Runnable action;
        Component label;
        int bg;
        int bgHover;
        int fg;
        boolean primary;
        ImageFrameAlignment alignValue;

        Chip(int x, int y, int w, int h, Component label, int bg, int bgHover, int fg, boolean primary, Runnable action) {
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
            this.label = label;
            this.bg = bg;
            this.bgHover = bgHover;
            this.fg = fg;
            this.primary = primary;
            this.action = action;
        }

        boolean hit(double mx, double my) {
            return mx >= (double)this.x && my >= (double)this.y && mx <= (double)(this.x + this.w) && my <= (double)(this.y + this.h);
        }
    }
}

