/*
 * Decompiled with CFR 0.152.
 */
package net.jacobwasbeast.picaxe.network;

import dev.architectury.networking.NetworkManager;
import java.util.function.Supplier;
import net.jacobwasbeast.picaxe.api.ImageFrameAlignment;
import net.jacobwasbeast.picaxe.blocks.entities.ImageFrameBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class UpdateImageFramePayload {
    public static ResourceLocation TYPE = ResourceLocation.m_214293_((String)"picaxe", (String)"update_image_frame");
    public final BlockPos pos;
    public final String url;
    public final int width;
    public final int height;
    public final boolean stretch;
    public final ImageFrameAlignment alignment;
    public final double offsetX;
    public final double offsetY;
    public final double offsetZ;

    public UpdateImageFramePayload(BlockPos pos, String url, int width, int height, boolean stretch, ImageFrameAlignment alignment, double offsetX, double offsetY, double offsetZ) {
        this.pos = pos;
        this.url = url;
        this.width = width;
        this.height = height;
        this.stretch = stretch;
        this.alignment = alignment;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.offsetZ = offsetZ;
    }

    public UpdateImageFramePayload(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.url = buf.m_130277_();
        this.width = buf.readInt();
        this.height = buf.readInt();
        this.stretch = buf.readBoolean();
        this.alignment = ImageFrameAlignment.valueOf(buf.m_130277_());
        this.offsetX = buf.readDouble();
        this.offsetY = buf.readDouble();
        this.offsetZ = buf.readDouble();
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.m_130070_(this.url);
        buf.writeInt(this.width);
        buf.writeInt(this.height);
        buf.writeBoolean(this.stretch);
        buf.m_130070_(this.alignment.name());
        buf.writeDouble(this.offsetX);
        buf.writeDouble(this.offsetY);
        buf.writeDouble(this.offsetZ);
    }

    public void handle(Supplier<NetworkManager.PacketContext> contextSupplier) {
        NetworkManager.PacketContext context = contextSupplier.get();
        Player player = context.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            context.queue(() -> {
                BlockEntity be;
                Level level = player2.m_9236_();
                if (level.m_46749_(this.pos) && (be = level.m_7702_(this.pos)) instanceof ImageFrameBlockEntity) {
                    ImageFrameBlockEntity frameEntity = (ImageFrameBlockEntity)be;
                    frameEntity.setConfiguration(this.url, this.width, this.height, this.stretch, this.alignment, this.offsetX, this.offsetY, this.offsetZ);
                }
            });
        }
    }
}

