/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.appflux.mixins;

import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNodeService;
import appeng.api.networking.IManagedGridNode;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageService;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.UpgradeInventories;
import appeng.helpers.InterfaceLogic;
import appeng.helpers.InterfaceLogicHost;
import com.glodblock.github.appflux.common.AFItemAndBlock;
import com.glodblock.github.appflux.common.me.energy.EnergyHandler;
import com.glodblock.github.appflux.common.me.service.EnergyDistributeService;
import com.glodblock.github.appflux.common.me.service.IEnergyDistributor;
import com.glodblock.github.appflux.util.AFUtil;
import com.glodblock.github.appflux.util.helpers.INeighborListener;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={InterfaceLogic.class}, remap=false)
public abstract class MixinInterfaceLogic
implements IEnergyDistributor,
INeighborListener {
    @Unique
    private List<Direction> af_$sides = List.of();
    @Unique
    private EnergyDistributeService af_$service = null;
    @Unique
    private final EnergyHandler.SendAction[] af_$actions = new EnergyHandler.SendAction[6];
    @Final
    @Mutable
    @Shadow
    private IUpgradeInventory upgrades;
    @Final
    @Shadow
    protected InterfaceLogicHost host;
    @Final
    @Shadow
    protected IActionSource actionSource;
    @Final
    @Shadow
    protected IManagedGridNode mainNode;

    @Shadow
    protected abstract void onUpgradesChanged();

    @Inject(method={"<init>(Lappeng/api/networking/IManagedGridNode;Lappeng/helpers/InterfaceLogicHost;Lnet/minecraft/world/item/Item;I)V"}, at={@At(value="TAIL")})
    private void expendUpgrades(IManagedGridNode gridNode, InterfaceLogicHost host, Item is, int slots, CallbackInfo ci) {
        this.upgrades = UpgradeInventories.forMachine((ItemLike)is, (int)2, this::onUpgradesChanged);
        this.mainNode.addService(IEnergyDistributor.class, (IGridNodeService)this);
    }

    @Override
    public void distribute() {
        IStorageService storage = this.af_getStorage();
        IGrid gird = this.mainNode.getGrid();
        BlockEntity self = this.host.getBlockEntity();
        if (storage != null && self.m_58904_() != null) {
            for (Direction d : this.af_$sides) {
                if (this.af_$actions[d.m_122411_()] == null) {
                    BlockEntity te = self.m_58904_().m_7702_(self.m_58899_().m_121955_(d.m_122436_()));
                    IGrid thatGrid = AFUtil.getGrid(te, d.m_122424_());
                    this.af_$actions[d.m_122411_()] = te != null && thatGrid != gird && !AFUtil.isBlackListTE(te, d.m_122424_()) ? EnergyHandler.getHandler(te, d.m_122424_()) : EnergyHandler.SendAction.NOOP;
                }
                this.af_$actions[d.m_122411_()].send(storage, this.actionSource);
            }
        }
    }

    @Unique
    private IStorageService af_getStorage() {
        if (this.mainNode.getGrid() != null) {
            return this.mainNode.getGrid().getStorageService();
        }
        return null;
    }

    @Override
    public boolean isActive() {
        return this.mainNode.isActive();
    }

    @Override
    public void setServiceHost(@Nullable EnergyDistributeService service) {
        this.af_$service = service;
        this.af_$updateSleep();
        if (service != null) {
            this.af_$sides = AFUtil.getSides(this.host);
        }
    }

    @Override
    public void onChange(Direction side) {
        this.af_$actions[side.m_122411_()] = null;
    }

    @Unique
    public void af_$updateSleep() {
        if (this.af_$service != null) {
            if (this.upgrades.isInstalled((ItemLike)AFItemAndBlock.INDUCTION_CARD)) {
                this.af_$service.wake(this);
            } else {
                this.af_$service.sleep(this);
            }
        }
    }

    @Inject(method={"onUpgradesChanged"}, at={@At(value="TAIL")}, remap=false)
    private void notifyUpgrade(CallbackInfo ci) {
        this.af_$updateSleep();
    }
}

