/*
 * Decompiled with CFR 0.152.
 */
package com.github.almostreliable.energymeter.client.gui;

import com.github.almostreliable.energymeter.client.gui.MeterScreen;
import com.github.almostreliable.energymeter.meter.MeterContainer;
import com.github.almostreliable.energymeter.network.PacketHandler;
import com.github.almostreliable.energymeter.network.packets.AccuracyUpdatePacket;
import com.github.almostreliable.energymeter.util.GuiUtils;
import com.github.almostreliable.energymeter.util.TextUtils;
import com.github.almostreliable.energymeter.util.TypeEnums;
import com.mojang.blaze3d.platform.InputConstants;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.apache.commons.lang3.StringUtils;

abstract class GenericTextBox
extends EditBox {
    protected final MeterScreen screen;
    private final Font font;
    private final TypeEnums.TEXT_BOX identifier;

    GenericTextBox(MeterScreen screen, Font font, int pX, int pY, int width, int height, TypeEnums.TEXT_BOX identifier) {
        super(font, pX, pY, width, height, (Component)Component.m_237119_());
        this.screen = screen;
        this.font = font;
        this.identifier = identifier;
        this.m_94182_(false);
        this.m_94202_(0xF0F0F0);
        this.m_94153_(text -> StringUtils.isNumeric((CharSequence)text) || text.isEmpty());
        this.m_94199_(7);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == InputConstants.m_84851_((String)"key.keyboard.enter").m_84873_()) {
            this.m_93692_(false);
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        boolean clicked = super.m_6375_(pMouseX, pMouseY, pButton);
        if (clicked && Screen.m_96638_()) {
            this.reset();
            if (this.identifier == TypeEnums.TEXT_BOX.INTERVAL) {
                this.screen.getThresholdBox().reset();
            }
        }
        return clicked;
    }

    public void m_87963_(GuiGraphics guiGraphics, int mX, int mY, float partial) {
        if (((MeterContainer)this.screen.m_6262_()).getEntity().getAccuracy() == TypeEnums.ACCURACY.EXACT) {
            return;
        }
        int x = this.m_252754_();
        int y = this.m_252907_();
        String label = TextUtils.translateAsString(TypeEnums.TRANSLATE_TYPE.LABEL, this.identifier.toString().toLowerCase()) + ":";
        int labelWidth = this.font.m_92895_(label);
        this.f_93622_ = mX >= x - 4 - labelWidth && mY >= y - 3 && mX < x + this.f_93618_ + 3 && mY < y + this.f_93619_ + 3;
        GuiUtils.renderText(guiGraphics, x - 4 - labelWidth, y, 1.0f, label, 0xF0F0F0);
        guiGraphics.m_280509_(x - 3, y - 3, x + this.f_93618_ + 3, y + this.f_93619_ + 3, -65434);
        guiGraphics.m_280509_(x - 2, y - 2, x + this.f_93618_ + 2, y + this.f_93619_ + 2, -15263977);
        this.m_257544_(Tooltip.m_257550_((Component)this.getTooltipBuilder().resolve()));
        super.m_87963_(guiGraphics, mX, mY, partial);
    }

    protected void changeTextBoxValue(int value, boolean sync) {
        this.m_94144_(String.valueOf(Math.max(value, 5)));
        if (sync) {
            PacketHandler.CHANNEL.sendToServer((Object)new AccuracyUpdatePacket(this.identifier, Math.max(value, 5)));
        }
    }

    void reset() {
        this.changeTextBoxValue(5, true);
    }

    void validateTextBox() {
        int value;
        int oldValue = this.getOldValue();
        try {
            value = Integer.parseInt(this.m_94155_());
        }
        catch (NumberFormatException e) {
            this.changeTextBoxValue(oldValue, false);
            return;
        }
        if (value != oldValue) {
            this.changeTextBoxValue(value, true);
        }
    }

    public boolean m_198029_() {
        return this.f_93622_;
    }

    public void m_93692_(boolean focused) {
        if (this.m_93696_() && !focused) {
            this.screen.getIntervalBox().validateTextBox();
            this.screen.getThresholdBox().validateTextBox();
        }
        super.m_93692_(focused);
    }

    protected abstract GuiUtils.TooltipBuilder getTooltipBuilder();

    protected abstract int getOldValue();
}

