/*
 * Decompiled with CFR 0.152.
 */
package com.github.almostreliable.energymeter.compat.cct;

import com.github.almostreliable.energymeter.compat.IMeterEntityObserver;
import com.github.almostreliable.energymeter.meter.MeterEntity;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;

public class MeterPeripheral
implements IPeripheral,
IMeterEntityObserver {
    private final MeterEntity entity;
    private IComputerAccess computer;

    MeterPeripheral(MeterEntity entity) {
        this.entity = entity;
    }

    @LuaFunction(mainThread=true)
    public final MethodResult getSideConfig(Direction direction) {
        return MethodResult.of((Object)this.entity.getSideConfig().get(direction).name());
    }

    @LuaFunction(mainThread=true)
    public final MethodResult hasInput() {
        return MethodResult.of((Object)this.entity.getSideConfig().hasInput());
    }

    @LuaFunction(mainThread=true)
    public final MethodResult hasOutput() {
        return MethodResult.of((Object)this.entity.getSideConfig().hasOutput());
    }

    @LuaFunction(mainThread=true)
    public final MethodResult hasMaxOutputs() {
        return MethodResult.of((Object)this.entity.getSideConfig().hasMaxOutputs());
    }

    @Override
    public void onMeterTileChanged(MeterEntity entity, int flags) {
        if (!((Object)((Object)this.entity)).equals((Object)entity)) {
            return;
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        if ((flags & 1) != 0) {
            data.put("side_config", entity.getSideConfig().asStringMap());
        }
        if ((flags & 2) != 0) {
            data.put("transfer_rate", entity.getTransferRate());
        }
        if ((flags & 4) != 0) {
            data.put("number_mode", entity.getNumberMode().name());
        }
        if ((flags & 8) != 0) {
            data.put("status", entity.getStatus().name());
        }
        if ((flags & 0x10) != 0) {
            data.put("mode", entity.getMode().name());
        }
        if ((flags & 0x20) != 0) {
            data.put("accuracy", entity.getAccuracy().name());
        }
        if ((flags & 0x40) != 0) {
            data.put("interval", entity.getInterval());
        }
        if ((flags & 0x80) != 0) {
            data.put("threshold", entity.getThreshold());
        }
        this.computer.queueEvent("em_data_changed", new Object[]{data});
    }

    @Override
    public void onMeterTileRemoved(MeterEntity entity) {
        this.computer.queueEvent("em_removed", new Object[0]);
    }

    @Nonnull
    public String getType() {
        return "energymeter";
    }

    public void attach(@Nonnull IComputerAccess computer) {
        this.computer = computer;
        this.entity.subscribe(this);
    }

    public void detach(@Nonnull IComputerAccess computer) {
        this.entity.unsubscribe(this);
    }

    public boolean equals(@Nullable IPeripheral other) {
        return other instanceof MeterPeripheral && ((Object)((Object)this.entity)).equals((Object)((MeterPeripheral)other).entity);
    }

    @LuaFunction(mainThread=true)
    public final MethodResult getInterval() {
        return MethodResult.of((Object)this.entity.getInterval());
    }

    @LuaFunction(mainThread=true)
    public final MethodResult getTransferRate() {
        return MethodResult.of((Object)this.entity.getTransferRate());
    }

    @LuaFunction(mainThread=true)
    public final MethodResult getThreshold() {
        return MethodResult.of((Object)this.entity.getThreshold());
    }

    @LuaFunction(mainThread=true)
    public final MethodResult getNumberMode() {
        return MethodResult.of((Object)this.entity.getNumberMode().name());
    }

    @LuaFunction(mainThread=true)
    public final MethodResult getMode() {
        return MethodResult.of((Object)this.entity.getMode().name());
    }

    @LuaFunction(mainThread=true)
    public final MethodResult getAccuracy() {
        return MethodResult.of((Object)this.entity.getAccuracy().name());
    }

    @LuaFunction(mainThread=true)
    public final MethodResult getStatus() {
        return MethodResult.of((Object)this.entity.getStatus().name());
    }

    @LuaFunction(mainThread=true)
    public final MethodResult getFullSideConfig() {
        return MethodResult.of(this.entity.getSideConfig().asStringMap());
    }
}

