/*
 * Decompiled with CFR 0.152.
 */
package com.github.almostreliable.energymeter.meter;

import com.github.almostreliable.energymeter.compat.CapabilityAdapterFactory;
import com.github.almostreliable.energymeter.compat.ICapabilityAdapter;
import com.github.almostreliable.energymeter.compat.IMeterEntityObserver;
import com.github.almostreliable.energymeter.compat.cct.MeterPeripheral;
import com.github.almostreliable.energymeter.component.SideConfiguration;
import com.github.almostreliable.energymeter.component.SidedEnergyStorage;
import com.github.almostreliable.energymeter.core.Setup;
import com.github.almostreliable.energymeter.meter.MeterBlock;
import com.github.almostreliable.energymeter.meter.MeterContainer;
import com.github.almostreliable.energymeter.network.PacketHandler;
import com.github.almostreliable.energymeter.network.packets.ClientSyncPacket;
import com.github.almostreliable.energymeter.util.TextUtils;
import com.github.almostreliable.energymeter.util.TypeEnums;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.network.PacketDistributor;

public class MeterEntity
extends BlockEntity
implements MenuProvider {
    public static final int REFRESH_RATE = 5;
    private final EnumMap<Direction, LazyOptional<IEnergyStorage>> outputCache = new EnumMap(Direction.class);
    private final List<LazyOptional<SidedEnergyStorage>> energyStorage;
    private final SideConfiguration sideConfig;
    private final List<Double> energyRates = Collections.synchronizedList(new ArrayList());
    private final Set<IMeterEntityObserver> observers = Collections.synchronizedSet(new HashSet());
    @Nullable
    private final ICapabilityAdapter<MeterPeripheral> meterPeripheral;
    private boolean hasValidInput;
    private boolean setupDone;
    private LazyOptional<IEnergyStorage> inputCache;
    private double transferRate;
    private double averageRate;
    private TypeEnums.NUMBER_MODE numberMode = TypeEnums.NUMBER_MODE.SHORT;
    private TypeEnums.STATUS status = TypeEnums.STATUS.DISCONNECTED;
    private TypeEnums.MODE mode = TypeEnums.MODE.TRANSFER;
    private TypeEnums.ACCURACY accuracy = TypeEnums.ACCURACY.EXACT;
    private int interval = 5;
    private int threshold = 5;
    private double zeroThreshold;

    public MeterEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)Setup.Entities.METER.get(), pos, state);
        this.energyStorage = SidedEnergyStorage.create(this);
        this.sideConfig = new SideConfiguration(state);
        this.meterPeripheral = CapabilityAdapterFactory.createMeterPeripheral(this);
    }

    private static int transferEnergy(int energy, Map<? extends IEnergyStorage, Integer> outputs) {
        int acceptedEnergy = 0;
        int energyToTransfer = energy;
        while (!outputs.isEmpty() && energyToTransfer >= outputs.size()) {
            int equalSplit = energyToTransfer / outputs.size();
            ArrayList<IEnergyStorage> outputsToRemove = new ArrayList<IEnergyStorage>();
            for (Map.Entry<? extends IEnergyStorage, Integer> output : outputs.entrySet()) {
                int actualSplit = equalSplit;
                if (output.getValue() < equalSplit) {
                    actualSplit = output.getValue();
                    outputsToRemove.add(output.getKey());
                }
                output.getKey().receiveEnergy(actualSplit, false);
                energyToTransfer -= actualSplit;
                acceptedEnergy += actualSplit;
            }
            outputsToRemove.forEach(outputs::remove);
        }
        return acceptedEnergy;
    }

    public void updateSetting(TypeEnums.SETTING setting) {
        switch (setting) {
            case NUMBER: {
                this.numberMode = this.numberMode == TypeEnums.NUMBER_MODE.SHORT ? TypeEnums.NUMBER_MODE.LONG : TypeEnums.NUMBER_MODE.SHORT;
                this.syncData(4);
                break;
            }
            case MODE: {
                this.mode = this.mode == TypeEnums.MODE.TRANSFER ? TypeEnums.MODE.CONSUMER : TypeEnums.MODE.TRANSFER;
                this.syncData(16);
                break;
            }
            case ACCURACY: {
                int flags = 32;
                if (this.accuracy == TypeEnums.ACCURACY.EXACT) {
                    this.accuracy = TypeEnums.ACCURACY.INTERVAL;
                } else {
                    this.accuracy = TypeEnums.ACCURACY.EXACT;
                    this.interval = 5;
                    flags |= 0x40;
                }
                this.syncData(flags);
            }
        }
    }

    public void syncData(int flags) {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        ClientSyncPacket packet = new ClientSyncPacket(this.f_58858_, flags, this.sideConfig, this.transferRate, this.numberMode, this.status, this.mode, this.accuracy, this.interval, this.threshold);
        PacketHandler.CHANNEL.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)packet);
        for (IMeterEntityObserver observer : this.observers) {
            observer.onMeterTileChanged(this, flags);
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("side_config")) {
            this.sideConfig.deserializeNBT(tag.m_128469_("side_config"));
        }
        if (tag.m_128441_("number_mode")) {
            this.numberMode = TypeEnums.NUMBER_MODE.values()[tag.m_128451_("number_mode")];
        }
        if (tag.m_128441_("mode")) {
            this.mode = TypeEnums.MODE.values()[tag.m_128451_("mode")];
        }
        if (tag.m_128441_("accuracy")) {
            this.accuracy = TypeEnums.ACCURACY.values()[tag.m_128451_("accuracy")];
        }
        if (tag.m_128441_("interval")) {
            this.interval = tag.m_128451_("interval");
        }
        if (tag.m_128441_("threshold")) {
            this.threshold = tag.m_128451_("threshold");
        }
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("side_config", (Tag)this.sideConfig.serializeNBT());
        tag.m_128405_("number_mode", this.numberMode.ordinal());
        tag.m_128405_("mode", this.mode.ordinal());
        tag.m_128405_("accuracy", this.accuracy.ordinal());
        tag.m_128405_("interval", this.interval);
        tag.m_128405_("threshold", this.threshold);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        tag.m_128365_("side_config", (Tag)this.sideConfig.serializeNBT());
        tag.m_128347_("transfer_rate", this.transferRate);
        tag.m_128405_("status", this.status.ordinal());
        tag.m_128405_("number_mode", this.numberMode.ordinal());
        tag.m_128405_("mode", this.mode.ordinal());
        tag.m_128405_("accuracy", this.accuracy.ordinal());
        tag.m_128405_("interval", this.interval);
        tag.m_128405_("threshold", this.threshold);
        return tag;
    }

    public void m_7651_() {
        for (IMeterEntityObserver observer : this.observers) {
            observer.onMeterTileRemoved(this);
        }
        super.m_7651_();
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.sideConfig.deserializeNBT(tag.m_128469_("side_config"));
        this.transferRate = tag.m_128459_("transfer_rate");
        this.status = TypeEnums.STATUS.values()[tag.m_128451_("status")];
        this.numberMode = TypeEnums.NUMBER_MODE.values()[tag.m_128451_("number_mode")];
        this.mode = TypeEnums.MODE.values()[tag.m_128451_("mode")];
        this.accuracy = TypeEnums.ACCURACY.values()[tag.m_128451_("accuracy")];
        this.interval = tag.m_128451_("interval");
        this.threshold = tag.m_128451_("threshold");
    }

    public int receiveEnergy(int energy, boolean simulate) {
        int acceptedEnergy;
        if (this.f_58857_ == null || !this.setupDone) {
            return 0;
        }
        if (this.mode == TypeEnums.MODE.CONSUMER) {
            if (!simulate) {
                this.averageRate += (double)energy;
            }
            return energy;
        }
        Map<IEnergyStorage, Integer> outputs = this.getPossibleOutputs(energy);
        if (outputs.isEmpty()) {
            return 0;
        }
        int maximumAccepted = outputs.values().stream().mapToInt(maxEnergy -> maxEnergy).sum();
        if (simulate) {
            return Math.min(maximumAccepted, energy);
        }
        if (maximumAccepted <= energy) {
            outputs.forEach((cap, integer) -> cap.receiveEnergy(integer.intValue(), false));
            acceptedEnergy = maximumAccepted;
        } else {
            acceptedEnergy = MeterEntity.transferEnergy(energy, outputs);
        }
        this.averageRate += (double)acceptedEnergy;
        return acceptedEnergy;
    }

    public void updateNeighbors() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        this.f_58857_.m_7731_(this.f_58858_, this.flipBlockState(), 9);
    }

    public void invalidateCaps() {
        for (LazyOptional<SidedEnergyStorage> cap : this.energyStorage) {
            cap.invalidate();
        }
        if (this.meterPeripheral != null) {
            this.meterPeripheral.getLazyAdapter().invalidate();
        }
        super.invalidateCaps();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction direction) {
        if (!this.f_58859_) {
            if (cap.equals((Object)ForgeCapabilities.ENERGY) && direction != null && this.sideConfig.get(direction) != TypeEnums.IO_SETTING.OFF) {
                return this.energyStorage.get(direction.ordinal()).cast();
            }
            if (this.meterPeripheral != null && this.meterPeripheral.isCapability(cap)) {
                return this.meterPeripheral.getLazyAdapter().cast();
            }
        }
        return super.getCapability(cap, direction);
    }

    public void subscribe(IMeterEntityObserver observer) {
        this.observers.add(observer);
    }

    public void unsubscribe(IMeterEntityObserver observer) {
        this.observers.remove(observer);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerID, Inventory inventory, Player player) {
        return new MeterContainer(this, containerID);
    }

    public void updateCache(Direction direction) {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        TypeEnums.IO_SETTING setting = this.sideConfig.get(direction);
        if (setting == TypeEnums.IO_SETTING.IN) {
            this.hasValidInput = this.getInputFromCache(direction);
        } else if (setting == TypeEnums.IO_SETTING.OUT) {
            this.getOutputFromCache(direction);
        }
        if (!this.sideConfig.hasInput()) {
            this.hasValidInput = false;
            this.inputCache = null;
        }
    }

    void tick() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        if ((this.thresholdReached() || this.intervalReached()) && !this.energyRates.isEmpty()) {
            this.calculateTransferRate();
        }
        if (this.f_58857_.m_46467_() % 5L != 0L) {
            return;
        }
        if (!this.setupDone) {
            for (Direction direction : Direction.values()) {
                if (this.sideConfig.get(direction) == TypeEnums.IO_SETTING.OFF) continue;
                this.updateCache(direction);
            }
            this.setupDone = true;
        }
        if (this.mode == TypeEnums.MODE.CONSUMER && !this.hasValidInput || this.mode == TypeEnums.MODE.TRANSFER && (!this.hasValidInput || !this.sideConfig.hasOutput() || !this.hasValidOutput())) {
            this.updateStatus(TypeEnums.STATUS.DISCONNECTED);
            return;
        }
        this.energyRates.add(this.averageRate);
        this.averageRate = 0.0;
        this.calculateThreshold();
        if (this.transferRate > 0.0) {
            this.updateStatus(TypeEnums.STATUS.TRANSFERRING);
        } else {
            this.updateStatus(TypeEnums.STATUS.CONNECTED);
        }
    }

    private Map<IEnergyStorage, Integer> getPossibleOutputs(int energy) {
        HashMap<IEnergyStorage, Integer> outputs = new HashMap<IEnergyStorage, Integer>();
        for (Direction direction : Direction.values()) {
            LazyOptional<IEnergyStorage> target;
            if (this.sideConfig.get(direction) != TypeEnums.IO_SETTING.OUT || (target = this.getOutputFromCache(direction)) == null) continue;
            target.ifPresent(cap -> {
                int accepted = cap.receiveEnergy(energy, true);
                if (accepted > 0) {
                    outputs.put((IEnergyStorage)cap, accepted);
                }
            });
        }
        return outputs;
    }

    @Nullable
    private LazyOptional<IEnergyStorage> getOutputFromCache(Direction direction) {
        assert (this.f_58857_ != null && !this.f_58857_.f_46443_);
        LazyOptional target = this.outputCache.get(direction);
        if (target == null) {
            BlockEntity provider = this.f_58857_.m_7702_(this.f_58858_.m_121945_(direction));
            if (provider == null || provider instanceof MeterEntity) {
                return null;
            }
            target = provider.getCapability(ForgeCapabilities.ENERGY, direction.m_122424_());
            this.outputCache.put(direction, (LazyOptional<IEnergyStorage>)target);
            target.addListener(self -> this.outputCache.put(direction, null));
        }
        return target;
    }

    private BlockState flipBlockState() {
        BlockState state;
        return (BlockState)state.m_61124_((Property)MeterBlock.IO, (Comparable)Boolean.valueOf((Boolean)(state = this.m_58900_()).m_61143_((Property)MeterBlock.IO) == false));
    }

    private boolean thresholdReached() {
        return this.energyRates.size() * 5 >= this.threshold && this.zeroThreshold == 0.0;
    }

    private boolean intervalReached() {
        assert (this.f_58857_ != null);
        return this.f_58857_.m_46467_() % (long)this.interval == 0L;
    }

    private void calculateTransferRate() {
        assert (this.f_58857_ != null && !this.f_58857_.f_46443_);
        double oldTransferRate = this.transferRate;
        double average = this.energyRates.stream().mapToDouble(Double::valueOf).average().orElse(0.0);
        this.transferRate = average / 5.0;
        if (oldTransferRate != this.transferRate) {
            this.syncData(2);
        }
        this.energyRates.clear();
        if (this.accuracy == TypeEnums.ACCURACY.INTERVAL) {
            this.energyRates.add(average);
        }
    }

    private boolean hasValidOutput() {
        return this.outputCache.values().stream().anyMatch(Objects::nonNull);
    }

    private void updateStatus(TypeEnums.STATUS newStatus) {
        TypeEnums.STATUS oldStatus = this.status;
        this.status = newStatus;
        this.averageRate = 0.0;
        if (oldStatus != newStatus) {
            int flags = 8;
            if (newStatus != TypeEnums.STATUS.TRANSFERRING) {
                this.energyRates.clear();
                this.transferRate = 0.0;
                flags |= 2;
            }
            this.syncData(flags);
        }
    }

    private void calculateThreshold() {
        int skips = Math.max(0, this.energyRates.size() * 5 - this.threshold);
        this.zeroThreshold = this.energyRates.stream().skip(skips).reduce(0.0, Double::sum);
    }

    private boolean getInputFromCache(Direction direction) {
        assert (this.f_58857_ != null && !this.f_58857_.f_46443_);
        LazyOptional target = this.inputCache;
        if (target == null) {
            BlockEntity provider = this.f_58857_.m_7702_(this.f_58858_.m_121945_(direction));
            if (provider instanceof MeterEntity) {
                return false;
            }
            if (provider == null) {
                BlockState state = this.f_58857_.m_8055_(this.f_58858_.m_121945_(direction));
                return !state.m_60795_() && BuiltInRegistries.f_256975_.m_7981_((Object)state.m_60734_()).m_135827_().equals("pipez");
            }
            this.inputCache = target = provider.getCapability(ForgeCapabilities.ENERGY, direction.m_122424_());
            target.addListener(self -> {
                this.inputCache = null;
            });
        }
        return true;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    public int getInterval() {
        return this.interval;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    public double getTransferRate() {
        return (double)Math.round(this.transferRate * 1000.0) / 1000.0;
    }

    public void setTransferRate(double transferRate) {
        this.transferRate = transferRate;
    }

    public TypeEnums.STATUS getStatus() {
        if (this.status == TypeEnums.STATUS.TRANSFERRING) {
            return this.mode == TypeEnums.MODE.CONSUMER ? TypeEnums.STATUS.CONSUMING : TypeEnums.STATUS.TRANSFERRING;
        }
        return this.status;
    }

    public void setStatus(TypeEnums.STATUS status) {
        this.status = status;
    }

    public TypeEnums.NUMBER_MODE getNumberMode() {
        return this.numberMode;
    }

    public void setNumberMode(TypeEnums.NUMBER_MODE numberMode) {
        this.numberMode = numberMode;
    }

    public TypeEnums.ACCURACY getAccuracy() {
        return this.accuracy;
    }

    public void setAccuracy(TypeEnums.ACCURACY accuracy) {
        this.accuracy = accuracy;
    }

    public SideConfiguration getSideConfig() {
        return this.sideConfig;
    }

    public TypeEnums.MODE getMode() {
        return this.mode;
    }

    public void setMode(TypeEnums.MODE mode) {
        this.mode = mode;
    }

    public Component m_5446_() {
        return TextUtils.translate(TypeEnums.TRANSLATE_TYPE.CONTAINER, "meter", new ChatFormatting[0]);
    }
}

