/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.block.decorative;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import com.ldtteam.domumornamentum.block.AbstractPanelBlockTrapdoor;
import com.ldtteam.domumornamentum.block.ICachedItemGroupBlock;
import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlock;
import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlockComponent;
import com.ldtteam.domumornamentum.block.components.SimpleRetexturableComponent;
import com.ldtteam.domumornamentum.block.types.TrapdoorType;
import com.ldtteam.domumornamentum.client.model.data.MaterialTextureData;
import com.ldtteam.domumornamentum.entity.block.MateriallyTexturedBlockEntity;
import com.ldtteam.domumornamentum.recipe.FinishedDORecipe;
import com.ldtteam.domumornamentum.tag.ModTags;
import com.ldtteam.domumornamentum.util.BlockUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PanelBlock
extends AbstractPanelBlockTrapdoor<PanelBlock>
implements IMateriallyTexturedBlock,
ICachedItemGroupBlock,
EntityBlock {
    public static final EnumProperty<TrapdoorType> TYPE = EnumProperty.m_61587_((String)"type", TrapdoorType.class);
    public static final List<IMateriallyTexturedBlockComponent> COMPONENTS = ImmutableList.builder().add((Object)new SimpleRetexturableComponent(new ResourceLocation("minecraft:block/oak_planks"), ModTags.TRAPDOORS_MATERIALS, Blocks.f_50705_)).build();
    private final List<ItemStack> fillItemGroupCache = Lists.newArrayList();

    public PanelBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_60978_(3.0f).m_60955_().m_60922_((state, blockGetter, pos, type) -> false));
        this.m_49959_((BlockState)this.m_49966_().m_61124_(TYPE, (Comparable)((Object)TrapdoorType.FULL)));
    }

    @Override
    protected void m_7926_(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{TYPE});
    }

    @NotNull
    public List<IMateriallyTexturedBlockComponent> getComponents() {
        return COMPONENTS;
    }

    @Override
    public void fillItemCategory(@NotNull NonNullList<ItemStack> items) {
        if (!this.fillItemGroupCache.isEmpty()) {
            items.addAll(this.fillItemGroupCache);
            return;
        }
        try {
            for (TrapdoorType trapdoorType : TrapdoorType.values()) {
                ItemStack result = new ItemStack((ItemLike)this);
                result.m_41784_().m_128359_("type", trapdoorType.name().toUpperCase());
                this.fillItemGroupCache.add(result);
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        items.addAll(this.fillItemGroupCache);
    }

    public void m_6402_(@NotNull Level worldIn, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity placer, @NotNull ItemStack stack) {
        super.m_6402_(worldIn, pos, state, placer, stack);
        CompoundTag textureData = stack.m_41698_("textureData");
        BlockEntity tileEntity = worldIn.m_7702_(pos);
        if (tileEntity instanceof MateriallyTexturedBlockEntity) {
            ((MateriallyTexturedBlockEntity)tileEntity).updateTextureDataWith(MaterialTextureData.deserializeFromNBT(textureData));
        }
    }

    @Override
    public BlockState m_5573_(@NotNull BlockPlaceContext context) {
        BlockState state = (BlockState)super.m_5573_(context).m_61124_(TYPE, (Comparable)((Object)TrapdoorType.valueOf(context.m_43722_().m_41784_().m_128461_("type"))));
        Vec3 offsetPos = context.m_43720_().m_82546_(Vec3.m_82528_((Vec3i)context.m_8083_()));
        if (context.m_43719_().m_122434_().m_122479_()) {
            if (offsetPos.f_82480_ > 0.8) {
                return (BlockState)state.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false));
            }
            if (offsetPos.f_82480_ < 0.2) {
                return (BlockState)((BlockState)state.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)HALF, (Comparable)Half.BOTTOM);
            }
            if (context.m_43719_().m_122434_() == Direction.Axis.X) {
                if (offsetPos.f_82481_ > 0.8) {
                    return (BlockState)state.m_61124_((Property)f_54117_, (Comparable)Direction.NORTH);
                }
                if (offsetPos.f_82481_ < 0.2) {
                    return (BlockState)state.m_61124_((Property)f_54117_, (Comparable)Direction.SOUTH);
                }
            } else {
                if (offsetPos.f_82479_ > 0.8) {
                    return (BlockState)state.m_61124_((Property)f_54117_, (Comparable)Direction.WEST);
                }
                if (offsetPos.f_82479_ < 0.2) {
                    return (BlockState)state.m_61124_((Property)f_54117_, (Comparable)Direction.EAST);
                }
            }
        } else {
            if (offsetPos.f_82481_ > 0.8) {
                return (BlockState)((BlockState)state.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(true))).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH);
            }
            if (offsetPos.f_82481_ < 0.2) {
                return (BlockState)((BlockState)state.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(true))).m_61124_((Property)f_54117_, (Comparable)Direction.SOUTH);
            }
            if (offsetPos.f_82479_ > 0.8) {
                return (BlockState)((BlockState)state.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(true))).m_61124_((Property)f_54117_, (Comparable)Direction.WEST);
            }
            if (offsetPos.f_82479_ < 0.2) {
                return (BlockState)((BlockState)state.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(true))).m_61124_((Property)f_54117_, (Comparable)Direction.EAST);
            }
        }
        return state;
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        return new MateriallyTexturedBlockEntity(blockPos, blockState);
    }

    @NotNull
    public List<ItemStack> m_49635_(@NotNull BlockState state, @NotNull LootParams.Builder builder) {
        return BlockUtils.getMaterializedItemStack(builder, (s, e) -> {
            s.m_41784_().m_128359_("type", ((TrapdoorType)((Object)((Object)e.m_58900_().m_61143_(TYPE)))).toString().toUpperCase());
            return s;
        });
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        return BlockUtils.getMaterializedItemStack((Entity)player, world, pos, (s, e) -> {
            s.m_41784_().m_128359_("type", ((TrapdoorType)((Object)((Object)e.m_58900_().m_61143_(TYPE)))).toString().toUpperCase());
            return s;
        });
    }

    @Override
    public void resetCache() {
        this.fillItemGroupCache.clear();
    }

    @Override
    @NotNull
    public Block getBlock() {
        return this;
    }

    @Override
    @NotNull
    public Collection<FinishedRecipe> getValidCutterRecipes() {
        ArrayList<FinishedRecipe> recipes = new ArrayList<FinishedRecipe>();
        for (final TrapdoorType value : TrapdoorType.values()) {
            recipes.add(new FinishedDORecipe(){

                public void m_7917_(@NotNull JsonObject jsonObject) {
                    CompoundTag tag = new CompoundTag();
                    tag.m_128359_("type", value.toString().toUpperCase());
                    jsonObject.addProperty("block", Objects.requireNonNull(PanelBlock.this.getRegistryName(PanelBlock.this.getBlock())).toString());
                    jsonObject.addProperty("nbt", tag.toString());
                    jsonObject.addProperty("count", (Number)(COMPONENTS.size() * 4));
                }

                @NotNull
                public ResourceLocation m_6445_() {
                    return new ResourceLocation(Objects.requireNonNull(PanelBlock.this.getRegistryName(PanelBlock.this.getBlock())).toString() + "_" + value.m_7912_());
                }
            });
        }
        return recipes;
    }

    public float getExplosionResistance(BlockState state, BlockGetter level, BlockPos pos, Explosion explosion) {
        return this.getDOExplosionResistance((x$0, x$1, x$2, x$3) -> Float.valueOf(super.getExplosionResistance(x$0, x$1, x$2, x$3)), state, level, pos, explosion);
    }

    public float m_5880_(@NotNull BlockState state, @NotNull Player player, @NotNull BlockGetter level, @NotNull BlockPos pos) {
        return this.getDODestroyProgress((x$0, x$1, x$2, x$3) -> Float.valueOf(super.m_5880_(x$0, x$1, x$2, x$3)), state, player, level, pos);
    }

    public SoundType getSoundType(BlockState state, LevelReader level, BlockPos pos, @Nullable Entity entity) {
        return this.getDOSoundType((x$0, x$1, x$2, x$3) -> super.getSoundType(x$0, x$1, x$2, x$3), state, level, pos, entity);
    }

    @Override
    public IMateriallyTexturedBlockComponent getMainComponent() {
        return COMPONENTS.get(0);
    }
}

