/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.fengine.assemble;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.stream.Collectors;
import mrtjp.fengine.TileCoord;
import mrtjp.fengine.api.PropagationFunction;
import mrtjp.fengine.assemble.PathFinderManifest;
import mrtjp.fengine.assemble.PathFinderNode;
import mrtjp.fengine.assemble.PathFinderResult;
import mrtjp.fengine.tiles.FETile;
import mrtjp.fengine.tiles.FETileMap;

public class TileMapPathFinder {
    private final Queue<PathFinderNode> open = new LinkedList<PathFinderNode>();
    private final HashSet<PathFinderNode> openSet = new HashSet();
    private final HashSet<PathFinderNode> closedSet = new HashSet();
    private final HashMap<Integer, HashSet<Integer>> portToOutputRegisters = new HashMap();
    private final HashMap<Integer, HashSet<Integer>> portToInputRegisters = new HashMap();
    private final PathFinderManifest manifest;
    private final FETileMap map;

    public TileMapPathFinder(PathFinderManifest manifest, FETileMap map, TileCoord start, PropagationFunction startPropFunc) {
        this.manifest = manifest;
        this.map = map;
        this.openInitial(start, startPropFunc);
    }

    private void openInitial(TileCoord coord, PropagationFunction propFunc) {
        this.traverse(propFunc, (s, p) -> {
            int inputDir;
            TileCoord nextPos = coord.offset(s);
            PathFinderNode opened = new PathFinderNode(nextPos, inputDir = TileCoord.oppositeDir(s), p);
            if (!this.openSet.contains(opened) && !this.closedSet.contains(opened)) {
                this.open.add(opened);
                this.openSet.add(opened);
            }
        });
    }

    private void openNext(PathFinderNode prev) {
        FETile tile = this.map.getTile(prev.pos).orElse(null);
        if (tile == null) {
            return;
        }
        this.collect(prev, tile);
        PropagationFunction propFunc = tile.propagationFunc(prev.inputDir, prev.inputPort);
        this.traverse(propFunc, (s, p) -> {
            int inputDir;
            TileCoord nextPos = prev.pos.offset(s);
            PathFinderNode opened = prev.moveTo(nextPos, inputDir = TileCoord.oppositeDir(s), p);
            if (!this.openSet.contains(opened) && !this.closedSet.contains(opened)) {
                this.open.add(opened);
                this.openSet.add(opened);
            }
        });
    }

    private void collect(PathFinderNode prev, FETile tile) {
        int initialPort = prev.getRootNode().inputPort;
        int dir = prev.inputDir;
        int port = prev.inputPort;
        tile.getOutputRegister(dir, port).ifPresent(outputRegID -> {
            this.portToOutputRegisters.computeIfAbsent(initialPort, i -> new HashSet()).add(outputRegID);
            this.manifest.addOutputPropagationTrail((int)outputRegID, prev);
        });
        tile.getInputRegister(dir, port).ifPresent(inputRegID -> {
            this.portToInputRegisters.computeIfAbsent(initialPort, i -> new HashSet()).add(inputRegID);
            this.manifest.addInputPropagationTrail((int)inputRegID, prev);
        });
    }

    private void traverse(PropagationFunction propFunc, TraverseFunc traverseFunc) {
        for (int s = 0; s < 6; ++s) {
            for (int p = 0; p < 16; ++p) {
                if (!propFunc.canPropagate(s, p)) continue;
                traverseFunc.traverse(s, p);
            }
        }
    }

    public void step() {
        if (this.open.isEmpty()) {
            return;
        }
        PathFinderNode next = this.open.poll();
        this.openSet.remove(next);
        this.openNext(next);
        this.closedSet.add(next);
    }

    public boolean isFinished() {
        return this.open.isEmpty();
    }

    public PathFinderResult result() {
        List<Integer> outputs = this.portToOutputRegisters.values().stream().flatMap(Collection::stream).distinct().sorted().collect(Collectors.toList());
        List<Integer> inputs = this.portToInputRegisters.values().stream().flatMap(Collection::stream).distinct().sorted().collect(Collectors.toList());
        return new PathFinderResult(outputs, inputs);
    }

    private static interface TraverseFunc {
        public void traverse(int var1, int var2);
    }
}

