/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.fengine.tiles;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;
import mrtjp.fengine.api.ICAssemblyTile;
import mrtjp.fengine.api.IPathFinder;
import mrtjp.fengine.assemble.PathFinderResult;
import mrtjp.fengine.simulate.ICGate;
import mrtjp.fengine.simulate.ICRegister;
import mrtjp.fengine.tiles.FETile;

public abstract class FEPortlessGateTile
implements FETile {
    private final int[] inputRegisters = new int[6];
    private final int[] outputRegisters = new int[6];
    private int gateId = -1;

    public FEPortlessGateTile() {
        Arrays.fill(this.inputRegisters, -1);
        Arrays.fill(this.outputRegisters, -1);
    }

    protected abstract int getOutDirMask();

    protected abstract int getInDirMask();

    protected abstract ICRegister createRegister(int var1);

    protected abstract ICGate createGate(ArrayList<Integer> var1, ArrayList<Integer> var2);

    @Override
    public Optional<Integer> getInputRegister(int inDir, int inPort) {
        return (this.getInDirMask() & 1 << inDir) != 0 && this.inputRegisters[inDir] > -1 ? Optional.of(this.inputRegisters[inDir]) : Optional.empty();
    }

    @Override
    public Optional<Integer> getOutputRegister(int outDir, int outPort) {
        return (this.getOutDirMask() & 1 << outDir) != 0 && this.outputRegisters[outDir] > -1 ? Optional.of(this.outputRegisters[outDir]) : Optional.empty();
    }

    @Override
    public void allocate(ICAssemblyTile.Allocator allocator) {
        Arrays.fill(this.inputRegisters, -1);
        Arrays.fill(this.outputRegisters, -1);
        this.gateId = -1;
        for (int dir = 0; dir < 6; ++dir) {
            if ((this.getOutDirMask() & 1 << dir) == 0) continue;
            this.outputRegisters[dir] = allocator.allocRegisterID();
        }
        this.gateId = allocator.allocGateID();
    }

    @Override
    public void locate(IPathFinder pathFinder) {
        for (int dir = 0; dir < 6; ++dir) {
            if ((this.getInDirMask() & 1 << dir) == 0) continue;
            int finalDir = dir;
            PathFinderResult pfr = pathFinder.doPathFinding((d, p) -> d == finalDir);
            if (pfr.outputRegisters.size() > 1) {
                System.out.println("ERR: Unexpected multiple drivers: " + pfr.outputRegisters);
            }
            if (pfr.outputRegisters.isEmpty()) continue;
            this.inputRegisters[dir] = pfr.outputRegisters.get(0);
        }
    }

    @Override
    public void consumeRemaps(ICAssemblyTile.RemapProvider remapProvider) {
        for (int dir = 0; dir < 6; ++dir) {
            this.outputRegisters[dir] = remapProvider.getRemappedRegisterID(this.outputRegisters[dir]);
            this.inputRegisters[dir] = remapProvider.getRemappedRegisterID(this.inputRegisters[dir]);
        }
    }

    @Override
    public void collect(ICAssemblyTile.Collector collector) {
        ArrayList inputs = Arrays.stream(this.inputRegisters).filter(c -> c != -1).boxed().collect(Collectors.toCollection(ArrayList::new));
        ArrayList outputs = Arrays.stream(this.outputRegisters).filter(c -> c != -1).boxed().collect(Collectors.toCollection(ArrayList::new));
        for (int dir = 0; dir < 6; ++dir) {
            if (this.outputRegisters[dir] == -1) continue;
            collector.addRegister(this.outputRegisters[dir], this.createRegister(dir));
        }
        ICGate op = this.createGate(inputs, outputs);
        collector.addGate(this.gateId, op, inputs, outputs);
    }
}

