/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.engine.gates;

import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Scale;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.TransformationList;
import codechicken.lib.vec.Vector3;
import java.util.ArrayList;
import java.util.List;
import mrtjp.fengine.api.ICAssemblyTile;
import mrtjp.fengine.simulate.ICGate;
import mrtjp.fengine.simulate.ICSimulation;
import mrtjp.projectred.fabrication.ProjectRedFabrication;
import mrtjp.projectred.fabrication.editor.ICWorkbenchEditor;
import mrtjp.projectred.fabrication.editor.tools.InteractionZone;
import mrtjp.projectred.fabrication.editor.tools.SimpleInteractionZone;
import mrtjp.projectred.fabrication.engine.PRFabricationEngine;
import mrtjp.projectred.fabrication.engine.gates.ICGateTileType;
import mrtjp.projectred.fabrication.engine.gates.TimedStateGateTile;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;

public class RepeaterGateTile
extends TimedStateGateTile {
    public static final Cuboid6[] DELAY_ZONE_BOUNDS = new Cuboid6[4];
    private static final int[] DELAYS = new int[]{2, 4, 6, 8, 16, 32, 64, 128, 256};

    public RepeaterGateTile() {
        super(ICGateTileType.REPEATER);
    }

    @Override
    public void buildInteractionZoneList(List<InteractionZone> zones) {
        super.buildInteractionZoneList(zones);
        zones.add(new SimpleInteractionZone.Builder().bounds(() -> DELAY_ZONE_BOUNDS[this.getRotation()]).leftClickAction(() -> this.shiftDelay(true)).rightClickAction(() -> this.shiftDelay(false)).tooltip(toolTip -> toolTip.add(Component.m_237115_((String)"projectred_fabrication.interact.delay").m_7220_((Component)Component.m_237113_((String)": ")).m_7220_((Component)Component.m_237110_((String)"projectred_fabrication.f.unit.ticks", (Object[])new Object[]{DELAYS[this.getShape()]}).m_130940_(ChatFormatting.GRAY)).m_130948_(ICWorkbenchEditor.UNIFORM_GRAY))).build());
    }

    protected void shiftDelay(boolean up) {
        this.configureShapeAndSend((this.getShape() + (up ? 1 : DELAYS.length - 1)) % DELAYS.length);
    }

    @Override
    protected int redstoneInputMask() {
        return 4;
    }

    @Override
    protected int redstoneOutputMask() {
        return 1;
    }

    @Override
    protected void collectGate(ICAssemblyTile.Collector collector, int gateId, int[] inputRegisters, int[] outputRegisters) {
        int i;
        ArrayList<Integer> inputRegs = new ArrayList<Integer>();
        ArrayList<Integer> outputRegs = new ArrayList<Integer>();
        inputRegs.add(this.stateReg);
        inputRegs.add(inputRegisters[2]);
        for (i = 0; i < 8; ++i) {
            inputRegs.add(this.timeRegs[i]);
        }
        for (i = 0; i < 8; ++i) {
            inputRegs.add(PRFabricationEngine.REG_TIME[i]);
        }
        outputRegs.add(this.stateReg);
        outputRegs.add(outputRegisters[0]);
        for (i = 0; i < 8; ++i) {
            outputRegs.add(this.timeRegs[i]);
        }
        collector.addGate(gateId, new RepeaterGate(DELAYS[this.getShape()]), inputRegs, outputRegs);
    }

    static {
        for (int r = 0; r < 4; ++r) {
            TransformationList t = new Scale(0.0625).with(Rotation.quarterRotations[r].at(Vector3.CENTER));
            RepeaterGateTile.DELAY_ZONE_BOUNDS[r] = new Cuboid6(11.5, 2.0, 3.0, 13.5, 3.0, 13.0).apply((Transformation)t);
        }
    }

    public static class RepeaterGate
    implements ICGate {
        private final int delay;

        public RepeaterGate(int delay) {
            this.delay = delay;
        }

        private static byte readState(ICSimulation ic, int[] inputs) {
            return ic.getRegByteVal(inputs[0]);
        }

        private static byte readInput(ICSimulation ic, int[] inputs) {
            return ic.getRegByteVal(inputs[1]);
        }

        private static long readSchedTime(ICSimulation ic, int[] inputs) {
            return ic.getRegLongVal(inputs, 2);
        }

        private static long readSysTime(ICSimulation ic, int[] inputs) {
            return ic.getRegLongVal(inputs, 10);
        }

        private static void writeState(ICSimulation ic, int[] outputs, byte state) {
            ic.queueRegByteVal(outputs[0], state);
        }

        private static void writeOutput(ICSimulation ic, int[] outputs, byte output) {
            ic.queueRegByteVal(outputs[1], output);
        }

        private static void writeSchedTime(ICSimulation ic, int[] outputs, long time) {
            ic.queueRegLongVal(outputs, 2, time);
        }

        @Override
        public void compute(ICSimulation ic, int[] inputs, int[] outputs) {
            byte stateVal = RepeaterGate.readState(ic, inputs);
            switch (stateVal) {
                case 0: {
                    if (RepeaterGate.readInput(ic, inputs) == 0) break;
                    RepeaterGate.writeState(ic, outputs, (byte)1);
                    RepeaterGate.writeSchedTime(ic, outputs, RepeaterGate.readSysTime(ic, inputs) + (long)this.delay);
                    break;
                }
                case 1: {
                    if (RepeaterGate.readSysTime(ic, inputs) < RepeaterGate.readSchedTime(ic, inputs)) break;
                    RepeaterGate.writeState(ic, outputs, (byte)2);
                    RepeaterGate.writeOutput(ic, outputs, (byte)1);
                    RepeaterGate.writeSchedTime(ic, outputs, -1L);
                    break;
                }
                case 2: {
                    if (RepeaterGate.readInput(ic, inputs) != 0) break;
                    RepeaterGate.writeState(ic, outputs, (byte)3);
                    RepeaterGate.writeSchedTime(ic, outputs, RepeaterGate.readSysTime(ic, inputs) + (long)this.delay);
                    break;
                }
                case 3: {
                    if (RepeaterGate.readSysTime(ic, inputs) < RepeaterGate.readSchedTime(ic, inputs)) break;
                    RepeaterGate.writeState(ic, outputs, (byte)0);
                    RepeaterGate.writeOutput(ic, outputs, (byte)0);
                    RepeaterGate.writeSchedTime(ic, outputs, -1L);
                    break;
                }
                default: {
                    ProjectRedFabrication.LOGGER.error("Invalid state: " + stateVal);
                    RepeaterGate.writeState(ic, outputs, (byte)0);
                }
            }
        }
    }
}

