/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces;

import com.yungnickyoung.minecraft.bettermineshafts.BetterMineshaftsCommon;
import com.yungnickyoung.minecraft.bettermineshafts.module.StructurePieceTypeModule;
import com.yungnickyoung.minecraft.bettermineshafts.world.config.BetterMineshaftConfiguration;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.BetterMineshaftGenerator;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.BetterMineshaftPiece;
import com.yungnickyoung.minecraft.yungsapi.world.util.SurfaceHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;

public class VerticalEntrance
extends BetterMineshaftPiece {
    private final BlockPos centerPos;
    private int yAxisLen = 0;
    private int localYEnd = 0;
    private int tunnelLength = 0;
    private int tunnelFloorAltitude = 0;
    private Direction tunnelDirection = Direction.NORTH;
    private boolean hasTunnel = false;
    private static final int SHAFT_LOCAL_XZ_START = 22;
    private static final int SHAFT_LOCAL_XZ_END = 26;

    public VerticalEntrance(CompoundTag compoundTag) {
        super(StructurePieceTypeModule.VERTICAL_ENTRANCE, compoundTag);
        int centerPosX = compoundTag.m_128465_("centerPos")[0];
        int centerPosY = compoundTag.m_128465_("centerPos")[1];
        int centerPosZ = compoundTag.m_128465_("centerPos")[2];
        this.centerPos = new BlockPos(centerPosX, centerPosY, centerPosZ);
        this.yAxisLen = compoundTag.m_128451_("yAxisLen");
        this.localYEnd = this.yAxisLen - 1;
        this.tunnelLength = compoundTag.m_128451_("tunnelLen");
        this.tunnelFloorAltitude = compoundTag.m_128451_("floorAltitude");
        int tunnelDirInt = compoundTag.m_128451_("tunnelDir");
        this.tunnelDirection = tunnelDirInt == -1 ? null : Direction.m_122407_((int)tunnelDirInt);
        this.hasTunnel = compoundTag.m_128471_("hasTunnel");
    }

    public VerticalEntrance(int pieceChainLen, BlockPos.MutableBlockPos centerPos, Direction direction, BetterMineshaftConfiguration config, int maxBuildHeight) {
        super(StructurePieceTypeModule.VERTICAL_ENTRANCE, pieceChainLen, config, VerticalEntrance.getInitialBoundingBox((BlockPos)centerPos, maxBuildHeight));
        this.m_73519_(direction);
        this.centerPos = centerPos;
    }

    @Override
    protected void m_183620_(StructurePieceSerializationContext structurePieceSerializationContext, CompoundTag compoundTag) {
        super.m_183620_(structurePieceSerializationContext, compoundTag);
        compoundTag.m_128385_("centerPos", new int[]{this.centerPos.m_123341_(), this.centerPos.m_123342_(), this.centerPos.m_123343_()});
        compoundTag.m_128405_("yAxisLen", this.yAxisLen);
        compoundTag.m_128405_("tunnelLen", this.tunnelLength);
        compoundTag.m_128405_("floorAltitude", this.tunnelFloorAltitude);
        compoundTag.m_128405_("tunnelDir", this.tunnelDirection.m_122416_());
        compoundTag.m_128379_("hasTunnel", this.hasTunnel);
    }

    private static BoundingBox getInitialBoundingBox(BlockPos centerPos, int maxBuildHeight) {
        return new BoundingBox(centerPos.m_123341_() - 24, centerPos.m_123342_(), centerPos.m_123343_() - 24, centerPos.m_123341_() + 24, maxBuildHeight, centerPos.m_123343_() + 24);
    }

    @Override
    public void m_214092_(StructurePiece structurePiece, StructurePieceAccessor structurePieceAccessor, RandomSource randomSource) {
        Direction direction = this.m_73549_();
        if (direction == null) {
            return;
        }
        switch (direction) {
            default: {
                BetterMineshaftGenerator.generateAndAddBigTunnelPiece(structurePiece, structurePieceAccessor, randomSource, this.centerPos.m_123341_() - 4, this.centerPos.m_123342_(), this.centerPos.m_123343_() - 3, direction, this.f_73384_);
                break;
            }
            case SOUTH: {
                BetterMineshaftGenerator.generateAndAddBigTunnelPiece(structurePiece, structurePieceAccessor, randomSource, this.centerPos.m_123341_() + 4, this.centerPos.m_123342_(), this.centerPos.m_123343_() + 3, direction, this.f_73384_);
                break;
            }
            case WEST: {
                BetterMineshaftGenerator.generateAndAddBigTunnelPiece(structurePiece, structurePieceAccessor, randomSource, this.centerPos.m_123341_() - 3, this.centerPos.m_123342_(), this.centerPos.m_123343_() + 4, direction, this.f_73384_);
                break;
            }
            case EAST: {
                BetterMineshaftGenerator.generateAndAddBigTunnelPiece(structurePiece, structurePieceAccessor, randomSource, this.centerPos.m_123341_() + 3, this.centerPos.m_123342_(), this.centerPos.m_123343_() - 4, direction, this.f_73384_);
            }
        }
    }

    public void m_213694_(WorldGenLevel world, StructureManager structureManager, ChunkGenerator chunkGenerator, RandomSource randomSource, BoundingBox boundingBox, ChunkPos chunkPos, BlockPos blockPos) {
        if (!this.hasTunnel) {
            this.determineDirection(world);
        }
        if (this.hasTunnel) {
            this.generateVerticalShaft(world, randomSource, boundingBox);
            this.generateSurfaceTunnel(world, randomSource, boundingBox);
        }
    }

    private void generateVerticalShaft(WorldGenLevel world, RandomSource randomSource, BoundingBox box) {
        this.chanceReplaceNonAir(world, box, randomSource, this.config.replacementRate, 22, 0, 22, 26, this.localYEnd, 26, this.config.blockStateRandomizers.mainRandomizer);
        this.replaceAirOrChains(world, box, 22, 0, 22, 26, this.localYEnd, 26, this.config.blockStates.mainBlockState);
        this.fill(world, box, 23, 1, 23, 25, this.localYEnd - 1, 25, AIR);
        this.replaceAirOrChains(world, box, 23, 0, 23, 25, 0, 25, this.config.blockStates.mainBlockState);
        this.replaceAirOrChains(world, box, 24, 1, 22, 24, this.localYEnd - 4, 22, this.config.blockStates.mainBlockState);
        this.fill(world, box, 24, 1, 23, 24, this.localYEnd - 4, 23, Blocks.f_50155_.m_49966_());
        this.fill(world, box, 23, 1, 26, 25, 2, 26, this.config.blockStates.stoneWallBlockState);
        this.fill(world, box, 24, 3, 26, 24, 3, 26, this.config.blockStates.stoneSlabBlockState);
        this.fill(world, box, 24, 1, 26, 24, 2, 26, AIR);
        this.addBiomeDecorations(world, box, randomSource, 23, 0, 23, 25, 1, 25);
        this.addVines(world, box, randomSource, this.config.decorationChances.vineChance, 23, 0, 23, 25, this.localYEnd - 4, 25);
        this.generateLeg(world, randomSource, box, 22, 22, this.config.blockStateRandomizers.legRandomizer);
        this.generateLeg(world, randomSource, box, 22, 26, this.config.blockStateRandomizers.legRandomizer);
        this.generateLeg(world, randomSource, box, 26, 22, this.config.blockStateRandomizers.legRandomizer);
        this.generateLeg(world, randomSource, box, 26, 26, this.config.blockStateRandomizers.legRandomizer);
    }

    private void generateSurfaceTunnel(WorldGenLevel world, RandomSource randomSource, BoundingBox box) {
        int x;
        int z;
        boolean[] validPositions;
        int tunnelStartX = 0;
        int tunnelStartZ = 0;
        int tunnelEndX = 0;
        int tunnelEndZ = 0;
        Direction facing = this.m_73549_();
        float rotationDifference = facing.m_122435_() - this.tunnelDirection.m_122435_();
        Direction relativeTunnelDir = Direction.m_122364_((double)(Direction.NORTH.m_122435_() - rotationDifference));
        if (relativeTunnelDir == Direction.NORTH) {
            tunnelStartX = 22;
            tunnelStartZ = 26;
            tunnelEndX = 26;
            tunnelEndZ = 26 + this.tunnelLength;
        } else if (relativeTunnelDir == Direction.WEST && facing != Direction.SOUTH && facing != Direction.WEST || relativeTunnelDir == Direction.EAST && (facing == Direction.SOUTH || facing == Direction.WEST)) {
            tunnelStartX = 22 - this.tunnelLength;
            tunnelStartZ = 22;
            tunnelEndX = 22;
            tunnelEndZ = 26;
        } else if (relativeTunnelDir == Direction.SOUTH) {
            tunnelStartX = 22;
            tunnelStartZ = 22 - this.tunnelLength;
            tunnelEndX = 26;
            tunnelEndZ = 22;
        } else if (relativeTunnelDir == Direction.EAST || relativeTunnelDir == Direction.WEST) {
            tunnelStartX = 26;
            tunnelStartZ = 22;
            tunnelEndX = 26 + this.tunnelLength;
            tunnelEndZ = 26;
        }
        this.chanceReplaceNonAir(world, box, randomSource, 0.6f, tunnelStartX, this.tunnelFloorAltitude, tunnelStartZ, tunnelEndX, this.tunnelFloorAltitude + 4, tunnelEndZ, this.config.blockStateRandomizers.mainRandomizer);
        if (facing.m_122434_() == this.tunnelDirection.m_122434_()) {
            this.replaceAirOrChains(world, box, tunnelStartX + 1, this.tunnelFloorAltitude, tunnelStartZ, tunnelEndX - 1, this.tunnelFloorAltitude, tunnelEndZ, this.config.blockStates.mainBlockState);
            this.fill(world, box, tunnelStartX + 1, this.tunnelFloorAltitude + 1, tunnelStartZ, tunnelEndX - 1, this.tunnelFloorAltitude + 3, tunnelEndZ, AIR);
        } else {
            this.replaceAirOrChains(world, box, tunnelStartX, this.tunnelFloorAltitude, tunnelStartZ + 1, tunnelEndX, this.tunnelFloorAltitude, tunnelEndZ - 1, this.config.blockStates.mainBlockState);
            this.fill(world, box, tunnelStartX, this.tunnelFloorAltitude + 1, tunnelStartZ + 1, tunnelEndX, this.tunnelFloorAltitude + 3, tunnelEndZ - 1, AIR);
        }
        this.addVines(world, box, randomSource, this.config.decorationChances.vineChance, tunnelStartX + 1, this.tunnelFloorAltitude, tunnelStartZ + 1, tunnelEndX - 1, this.tunnelFloorAltitude + 4, tunnelEndZ - 1);
        if (facing.m_122434_() == this.tunnelDirection.m_122434_()) {
            validPositions = new boolean[tunnelEndZ - tunnelStartZ + 1];
            for (z = 0; z < validPositions.length; ++z) {
                floorBlock = this.m_73398_((BlockGetter)world, tunnelStartX + 2, this.tunnelFloorAltitude, tunnelStartZ + z, box);
                if (!floorBlock.m_280296_()) continue;
                validPositions[z] = true;
            }
        } else {
            validPositions = new boolean[tunnelEndX - tunnelStartX + 1];
            for (x = 0; x < validPositions.length; ++x) {
                floorBlock = this.m_73398_((BlockGetter)world, tunnelStartX + x, this.tunnelFloorAltitude, tunnelStartZ + 2, box);
                if (!floorBlock.m_280296_()) continue;
                validPositions[x] = true;
            }
        }
        if (facing.m_122434_() == this.tunnelDirection.m_122434_()) {
            for (z = tunnelStartZ; z <= tunnelEndZ; ++z) {
                int r = randomSource.m_188503_(4);
                if (r != 0 || !validPositions[z - tunnelStartZ]) continue;
                this.fill(world, box, tunnelStartX + 1, this.tunnelFloorAltitude + 1, z, tunnelStartX + 1, this.tunnelFloorAltitude + 2, z, this.config.blockStates.supportBlockState);
                this.fill(world, box, tunnelStartX + 3, this.tunnelFloorAltitude + 1, z, tunnelStartX + 3, this.tunnelFloorAltitude + 2, z, this.config.blockStates.supportBlockState);
                this.fill(world, box, tunnelStartX + 1, this.tunnelFloorAltitude + 3, z, tunnelStartX + 3, this.tunnelFloorAltitude + 3, z, this.config.blockStates.mainBlockState);
                this.chanceReplaceNonAir(world, box, randomSource, 0.25f, tunnelStartX + 1, this.tunnelFloorAltitude + 3, z, tunnelStartX + 3, this.tunnelFloorAltitude + 3, z, this.config.blockStates.supportBlockState);
                this.chanceReplaceAir(world, box, randomSource, 0.15f, tunnelStartX + 1, this.tunnelFloorAltitude + 3, z - 1, tunnelStartX + 1, this.tunnelFloorAltitude + 3, z + 1, Blocks.f_50033_.m_49966_());
                this.chanceReplaceAir(world, box, randomSource, 0.15f, tunnelStartX + 3, this.tunnelFloorAltitude + 3, z - 1, tunnelStartX + 3, this.tunnelFloorAltitude + 3, z + 1, Blocks.f_50033_.m_49966_());
                z += 3;
            }
        } else {
            for (x = tunnelStartX; x <= tunnelEndX; ++x) {
                int r = randomSource.m_188503_(4);
                if (r != 0 || !validPositions[x - tunnelStartX]) continue;
                this.fill(world, box, x, this.tunnelFloorAltitude + 1, tunnelStartZ + 1, x, this.tunnelFloorAltitude + 2, tunnelStartZ + 1, this.config.blockStates.supportBlockState);
                this.fill(world, box, x, this.tunnelFloorAltitude + 1, tunnelStartZ + 3, x, this.tunnelFloorAltitude + 2, tunnelStartZ + 3, this.config.blockStates.supportBlockState);
                this.fill(world, box, x, this.tunnelFloorAltitude + 3, tunnelStartZ + 1, x, this.tunnelFloorAltitude + 3, tunnelStartZ + 3, this.config.blockStates.mainBlockState);
                this.chanceReplaceNonAir(world, box, randomSource, 0.25f, x, this.tunnelFloorAltitude + 3, tunnelStartZ + 1, x, this.tunnelFloorAltitude + 3, tunnelStartZ + 3, this.config.blockStates.supportBlockState);
                this.chanceReplaceAir(world, box, randomSource, 0.15f, x - 1, this.tunnelFloorAltitude + 3, tunnelStartZ + 1, x + 1, this.tunnelFloorAltitude + 3, tunnelStartZ + 1, Blocks.f_50033_.m_49966_());
                this.chanceReplaceAir(world, box, randomSource, 0.15f, x - 1, this.tunnelFloorAltitude + 3, tunnelStartZ + 3, x + 1, this.tunnelFloorAltitude + 3, tunnelStartZ + 3, Blocks.f_50033_.m_49966_());
                x += 3;
            }
        }
    }

    private void determineDirection(WorldGenLevel world) {
        int minSurfaceHeight = world.m_151558_() - 1;
        for (int xOffset = -2; xOffset <= 2; ++xOffset) {
            for (int zOffset = -2; zOffset <= 2; ++zOffset) {
                try {
                    int realX = this.centerPos.m_123341_() + xOffset;
                    int realZ = this.centerPos.m_123343_() + zOffset;
                    int chunkX = realX >> 4;
                    int chunkZ = realZ >> 4;
                    int surfaceHeight = SurfaceHelper.getSurfaceHeight((ChunkAccess)world.m_6325_(chunkX, chunkZ), (ColumnPos)new ColumnPos(realX, realZ));
                    if (surfaceHeight <= 1) continue;
                    minSurfaceHeight = Math.min(minSurfaceHeight, surfaceHeight);
                    continue;
                }
                catch (NullPointerException e) {
                    BetterMineshaftsCommon.LOGGER.error("Unexpected YUNG's Better Mineshafts error. Please report this!");
                    BetterMineshaftsCommon.LOGGER.error(e.toString());
                    BetterMineshaftsCommon.LOGGER.error(e.getMessage());
                }
            }
        }
        if (minSurfaceHeight < 60 || minSurfaceHeight == world.m_151558_() - 1) {
            return;
        }
        int ceilingHeight = minSurfaceHeight - 2;
        int floorHeight = ceilingHeight - 4;
        this.yAxisLen = ceilingHeight - this.centerPos.m_123342_() + 1;
        this.localYEnd = this.yAxisLen - 1;
        BlockPos.MutableBlockPos mutable = this.centerPos.m_122032_();
        int radius = 8;
        int maxRadialDist = 3;
        for (int radialDist = 0; radialDist < maxRadialDist; ++radialDist) {
            for (Direction direction : Direction.values()) {
                if (direction == Direction.UP || direction == Direction.DOWN) continue;
                mutable.m_122190_((Vec3i)this.centerPos.m_5484_(direction, radius * radialDist + 2));
                for (int i = radialDist * radius; i < radialDist * radius + radius; ++i) {
                    int surfaceHeight = SurfaceHelper.getSurfaceHeight((ChunkAccess)world.m_46865_((BlockPos)mutable), (ColumnPos)new ColumnPos(mutable.m_123341_(), mutable.m_123343_()));
                    if (surfaceHeight <= floorHeight && surfaceHeight > 1) {
                        this.hasTunnel = true;
                        this.tunnelDirection = direction;
                        this.tunnelFloorAltitude = ceilingHeight - 4 - this.f_73383_.m_162396_();
                        this.tunnelLength = i;
                        return;
                    }
                    mutable.m_122173_(direction);
                }
            }
        }
    }
}

