/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.gui.modular.lib;

import codechicken.lib.gui.modular.lib.geometry.Axis;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.gui.screens.Screen;
import org.jetbrains.annotations.Nullable;

public interface SliderState {
    public double getPos();

    public void setPos(double var1);

    default public double sliderRatio() {
        return 0.1;
    }

    default public double scrollSpeed() {
        double ratio = this.sliderRatio();
        return ratio < 0.1 ? ratio * 0.1 : ratio * ratio;
    }

    default public boolean canScroll(Axis scrollAxis) {
        return true;
    }

    public static SliderState create(double speed) {
        return SliderState.create(speed, null);
    }

    public static SliderState create(final double speed, final @Nullable Consumer<Double> changeListener) {
        return new SliderState(){
            double pos = 0.0;

            @Override
            public double getPos() {
                return this.pos;
            }

            @Override
            public void setPos(double pos) {
                this.pos = pos;
                if (changeListener != null) {
                    changeListener.accept(pos);
                }
            }

            @Override
            public double scrollSpeed() {
                return speed;
            }
        };
    }

    public static SliderState forScrollBar(final Supplier<Double> getPos, final Consumer<Double> setPos, final Supplier<Double> getRatio) {
        return new SliderState(){

            @Override
            public double getPos() {
                return (Double)getPos.get();
            }

            @Override
            public void setPos(double pos) {
                setPos.accept(pos);
            }

            @Override
            public double sliderRatio() {
                return (Double)getRatio.get();
            }

            @Override
            public boolean canScroll(Axis scrollAxis) {
                return scrollAxis == Axis.Y != Screen.m_96638_();
            }
        };
    }

    public static SliderState forSlider(final Supplier<Double> getPos, final Consumer<Double> setPos, final Supplier<Double> getSpeed) {
        return new SliderState(){

            @Override
            public double getPos() {
                return (Double)getPos.get();
            }

            @Override
            public void setPos(double pos) {
                setPos.accept(pos);
            }

            @Override
            public double scrollSpeed() {
                return (Double)getSpeed.get();
            }
        };
    }
}

