/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.network;

import com.jaquadro.minecraft.storagedrawers.network.CountUpdateMessageHandler;
import com.texelsaurus.minecraft.chameleon.network.ChameleonPacket;
import com.texelsaurus.minecraft.chameleon.network.ChameleonPacketHandler;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public record CountUpdateMessage(int x, int y, int z, int slot, int count) implements ChameleonPacket<CountUpdateMessage>
{
    public static final ResourceLocation ID = new ResourceLocation("storagedrawers", "count_update");
    public static final Handler HANDLER = new Handler();

    public CountUpdateMessage(BlockPos pos, int slot, int count) {
        this(pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), slot, count);
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public ChameleonPacketHandler<CountUpdateMessage> getHandler() {
        return HANDLER;
    }

    private static class Handler
    implements ChameleonPacketHandler<CountUpdateMessage> {
        private Handler() {
        }

        @Override
        public Class<CountUpdateMessage> type() {
            return CountUpdateMessage.class;
        }

        @Override
        public void encode(CountUpdateMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.x);
            buffer.writeShort(message.y);
            buffer.writeInt(message.z);
            buffer.writeByte(message.slot);
            buffer.writeInt(message.count);
        }

        @Override
        public CountUpdateMessage decode(FriendlyByteBuf buffer) {
            int x = buffer.readInt();
            short y = buffer.readShort();
            int z = buffer.readInt();
            byte slot = buffer.readByte();
            int count = buffer.readInt();
            return new CountUpdateMessage(new BlockPos(x, (int)y, z), slot, count);
        }

        @Override
        public void handle(CountUpdateMessage message, Player player, Consumer<Runnable> workQueue) {
            if (!(player instanceof ServerPlayer)) {
                workQueue.accept(() -> new CountUpdateMessageHandler().handle(message));
            }
        }
    }
}

