/*
 * Decompiled with CFR 0.152.
 */
package com.tom.createores.item;

import com.tom.createores.block.MultiblockPart;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class MultiBlockItem
extends BlockItem {
    public MultiBlockItem(Block pBlock, Item.Properties pProperties) {
        super(pBlock, pProperties);
    }

    protected boolean m_40610_(BlockPlaceContext pContext, BlockState pState) {
        MultiblockPart.MultiblockMainPart part = (MultiblockPart.MultiblockMainPart)this.m_40614_();
        Direction facing = (Direction)pState.m_61143_((Property)BlockStateProperties.f_61374_);
        BlockPos place = pContext.m_8083_().m_121955_(part.getStart(facing));
        Vec3i s = part.getSize(facing);
        for (int x = 0; x < s.m_123341_(); ++x) {
            for (int y = 0; y < s.m_123342_(); ++y) {
                for (int z = 0; z < s.m_123343_(); ++z) {
                    BlockPos pos = place.m_7918_(x, y, z);
                    MultiblockPart.MultiblockMainPart.MultiblockPartType type = part.getPartTypeAt(facing, x, y, z);
                    if (type == null) continue;
                    if (pContext.m_43725_().m_151570_(pos)) {
                        return false;
                    }
                    BlockPlaceContext p = BlockPlaceContext.m_43644_((BlockPlaceContext)pContext, (BlockPos)pos.m_7495_(), (Direction)Direction.UP);
                    if (p.m_7058_() && !(p = BlockPlaceContext.m_43644_((BlockPlaceContext)pContext, (BlockPos)pos, (Direction)Direction.UP)).m_7058_()) {
                        return false;
                    }
                    if (!p.m_7059_()) {
                        return false;
                    }
                    if (super.m_40610_(p, pState)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    protected boolean m_7429_(BlockPlaceContext pContext, BlockState pState) {
        MultiblockPart.MultiblockMainPart part = (MultiblockPart.MultiblockMainPart)this.m_40614_();
        Level lvl = pContext.m_43725_();
        Direction facing = (Direction)pState.m_61143_((Property)BlockStateProperties.f_61374_);
        BlockPos place = pContext.m_8083_().m_121955_(part.getStart(facing));
        Vec3i s = part.getSize(facing);
        HashMap<BlockPos, PlaceAction> placeActions = new HashMap<BlockPos, PlaceAction>();
        for (int x = 0; x < s.m_123341_(); ++x) {
            for (int y = 0; y < s.m_123342_(); ++y) {
                for (int z = 0; z < s.m_123343_(); ++z) {
                    BlockPos pos = place.m_7918_(x, y, z);
                    MultiblockPart.MultiblockMainPart.MultiblockPartType type = part.getPartTypeAt(facing, x, y, z);
                    if (type == MultiblockPart.MultiblockMainPart.MultiblockPartType.MAIN) {
                        lvl.m_7731_(pos, pState, 11);
                        continue;
                    }
                    Direction f = part.getGhostDirection(facing, x, y, z);
                    BlockState pl = (BlockState)type.getBlockState(part.getBlockRotation(facing, type)).m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)f);
                    placeActions.put(pos, new PlaceAction(placeActions, pos, pl, f));
                }
            }
        }
        ArrayList pa = new ArrayList(placeActions.values());
        pa.forEach(PlaceAction::computeOrder);
        pa.sort(Comparator.naturalOrder());
        pa.forEach(p -> p.place(lvl));
        return true;
    }

    private static class PlaceAction
    implements Comparable<PlaceAction> {
        private final Map<BlockPos, PlaceAction> placeActions;
        private final BlockPos pos;
        private final BlockState state;
        private final Direction parentDir;
        private int placeOrder = -1;

        public PlaceAction(Map<BlockPos, PlaceAction> placeActions, BlockPos pos, BlockState state, Direction parentDir) {
            this.placeActions = placeActions;
            this.pos = pos;
            this.state = state;
            this.parentDir = parentDir;
        }

        public void computeOrder() {
            if (this.placeOrder == -1) {
                this.placeOrder = 0;
                BlockPos p = this.pos.m_121945_(this.parentDir);
                PlaceAction a = this.placeActions.get(p);
                if (a != null) {
                    a.computeOrder();
                    this.placeOrder = a.placeOrder + 1;
                }
            }
        }

        @Override
        public int compareTo(PlaceAction o) {
            return Integer.compare(this.placeOrder, o.placeOrder);
        }

        public void place(Level lvl) {
            lvl.m_7731_(this.pos, this.state, 11);
        }
    }
}

