/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.item;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import slimeknights.tconstruct.smeltery.item.CopperCanItem;

public class CopperCanFluidHandler
implements IFluidHandlerItem,
ICapabilityProvider {
    private final LazyOptional<IFluidHandlerItem> holder = LazyOptional.of(() -> this);
    private final ItemStack container;

    @Nonnull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        return ForgeCapabilities.FLUID_HANDLER_ITEM.orEmpty(cap, this.holder);
    }

    public int getTanks() {
        return 1;
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        return true;
    }

    private int getCapacity() {
        return 90 * this.container.m_41613_();
    }

    public int getTankCapacity(int tank) {
        return this.getCapacity();
    }

    private Fluid getFluid() {
        return CopperCanItem.getFluid(this.container);
    }

    @Nullable
    private CompoundTag getFluidTag() {
        return CopperCanItem.getFluidTag(this.container);
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        Fluid fluid = this.getFluid();
        if (fluid == Fluids.f_76191_) {
            return FluidStack.EMPTY;
        }
        return new FluidStack(this.getFluid(), this.getCapacity(), this.getFluidTag());
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        int capacity = this.getCapacity();
        if (this.getFluid() != Fluids.f_76191_ || resource.getAmount() < capacity) {
            return 0;
        }
        if (action.execute()) {
            CopperCanItem.setFluid(this.container, resource);
        }
        return capacity;
    }

    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        int capacity = this.getCapacity();
        if (resource.isEmpty() || resource.getAmount() < capacity) {
            return FluidStack.EMPTY;
        }
        Fluid fluid = this.getFluid();
        if (fluid == Fluids.f_76191_ || fluid != resource.getFluid()) {
            return FluidStack.EMPTY;
        }
        FluidStack output = new FluidStack(fluid, capacity, this.getFluidTag());
        if (!FluidStack.areFluidStackTagsEqual((FluidStack)resource, (FluidStack)output)) {
            return FluidStack.EMPTY;
        }
        if (action.execute()) {
            CopperCanItem.setFluid(this.container, FluidStack.EMPTY);
        }
        return output;
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        int capacity = this.getCapacity();
        if (maxDrain < capacity) {
            return FluidStack.EMPTY;
        }
        Fluid fluid = this.getFluid();
        if (fluid == Fluids.f_76191_) {
            return FluidStack.EMPTY;
        }
        FluidStack output = new FluidStack(fluid, capacity, this.getFluidTag());
        if (action.execute()) {
            CopperCanItem.setFluid(this.container, FluidStack.EMPTY);
        }
        return output;
    }

    public CopperCanFluidHandler(ItemStack container) {
        this.container = container;
    }

    public ItemStack getContainer() {
        return this.container;
    }
}

