/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.transmission.client;

import codechicken.lib.render.CCModel;
import codechicken.lib.render.lighting.LightModel;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Vector3;
import codechicken.lib.vec.Vertex5;
import codechicken.lib.vec.uv.UVScale;
import codechicken.lib.vec.uv.UVTransformation;
import codechicken.lib.vec.uv.UVTranslation;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import mrtjp.projectred.core.BundledSignalsLib;
import mrtjp.projectred.core.UVT;
import mrtjp.projectred.transmission.client.FramedWireModelBuilder;

public class WireModelBuilder {
    private static final UVTransformation ROTATE_WIRE_UV_180 = new UVT(Rotation.quarterRotations[2].at(new Vector3(8.0, 0.0, 16.0)));
    private int side = 0;
    private int tw = 0;
    private int th = 0;
    private double w = 0.0;
    private double h = 0.0;
    private int mask = 0;
    private int connMask = 0;
    private int connCount = 0;
    @Nullable
    private CCModel model = null;
    private int i = 0;
    private int modelKey = 0;
    private boolean inv = false;
    private boolean modelBuilt = false;

    public WireModelBuilder setInventory(boolean isInventory) {
        this.inv = isInventory;
        return this;
    }

    public WireModelBuilder setModelKey(int modelKey) {
        this.modelKey = modelKey;
        return this;
    }

    public CCModel build() {
        if (!this.modelBuilt) {
            this.buildModel();
            this.modelBuilt = true;
            assert (this.model != null);
            return this.model;
        }
        assert (this.model != null);
        return this.model.copy();
    }

    private void buildModel() {
        this.side = (this.modelKey >> 8) % 6;
        this.tw = (this.modelKey >> 8) / 6 + 1;
        this.w = (double)this.tw / 16.0;
        this.th = this.tw + 1;
        this.h = (double)this.th / 16.0;
        this.mask = this.modelKey & 0xFF;
        this.connMask = (this.mask & 0xF0) >> 4 | this.mask & 0xF;
        this.connCount = FramedWireModelBuilder.countConnections(this.connMask);
        this.model = CCModel.quadModel((int)(this.countNumberOfFaces() * 4));
        this.i = 0;
        this.generateCenter();
        for (int r = 0; r < 4; ++r) {
            this.generateSide(r);
        }
        this.model.apply(Rotation.sideOrientation((int)this.side, (int)0).at(Vector3.CENTER));
        WireModelBuilder.finishModel(this.model);
    }

    private int countNumberOfFaces() {
        if (this.inv) {
            return 22;
        }
        int conns = Math.max(this.connCount, 2);
        int faces = conns * 3 + 5;
        for (int i = 0; i < 4; ++i) {
            if ((this.mask >> i & 0x11) != 1) continue;
            ++faces;
        }
        return faces;
    }

    private void generateCenter() {
        UVTranslation uvt;
        int tex = switch (this.connCount) {
            case 0 -> 1;
            case 1 -> {
                if ((this.connMask & 5) != 0) {
                    yield 0;
                }
                yield 1;
            }
            default -> this.connMask == 5 ? 0 : (this.connMask == 10 ? 1 : 2);
        };
        Vertex5[] verts = new Vertex5[]{new Vertex5(0.5 - this.w, this.h, 0.5 + this.w, (double)(8 - this.tw), (double)(16 + this.tw)), new Vertex5(0.5 + this.w, this.h, 0.5 + this.w, (double)(8 + this.tw), (double)(16 + this.tw)), new Vertex5(0.5 + this.w, this.h, 0.5 - this.w, (double)(8 + this.tw), (double)(16 - this.tw)), new Vertex5(0.5 - this.w, this.h, 0.5 - this.w, (double)(8 - this.tw), (double)(16 - this.tw))};
        int r = BundledSignalsLib.bundledCableBaseRotationMap[this.side];
        if (tex == 0 || tex == 1) {
            tex = (tex + r) % 2;
        }
        if (tex == 1) {
            r += 3;
        }
        if (r != 0) {
            uvt = new UVT(Rotation.quarterRotations[r % 4].at(new Vector3(8.0, 0.0, 16.0)));
            WireModelBuilder.apply((UVTransformation)uvt, verts);
        }
        if (tex == 2) {
            uvt = new UVTranslation(16.0, 0.0);
            WireModelBuilder.apply((UVTransformation)uvt, verts);
        }
        if (this.inv) {
            verts = this.withBottom(verts, 0, 4);
        }
        this.i = WireModelBuilder.addVerts(Objects.requireNonNull(this.model), verts, this.i);
    }

    private void generateSide(int r) {
        Vertex5[] verts;
        int stype = this.mask >> r & 0x11;
        if (this.inv) {
            verts = this.genrateSideInv(r);
        } else {
            switch (this.connCount) {
                case 0: {
                    verts = r % 2 == 1 ? this.generateStub(r) : this.generateFlat(r);
                    break;
                }
                case 1: {
                    if (this.connMask == 1 << (r + 2) % 4) {
                        verts = this.generateStub(r);
                        break;
                    }
                }
                default: {
                    verts = this.generateSideFromType(stype, r);
                }
            }
        }
        Transformation t = Rotation.quarterRotations[r].at(Vector3.CENTER);
        WireModelBuilder.apply(t, verts);
        this.i = WireModelBuilder.addVerts(Objects.requireNonNull(this.model), verts, this.i);
    }

    private Vertex5[] genrateSideInv(int r) {
        return this.withBottom(this.generateStraight(r), 4, 4);
    }

    private Vertex5[] generateStraight(int r) {
        Vertex5[] verts = this.generateExtension(8);
        this.reflectSide(verts, r);
        return verts;
    }

    private Vertex5[] generateExtension(int tl) {
        double l = (double)tl / 16.0;
        return new Vertex5[]{new Vertex5(0.5 - this.w, 0.0, 0.5 + l, (double)(8 - this.tw), (double)(24 + 2 * this.th)), new Vertex5(0.5 + this.w, 0.0, 0.5 + l, (double)(8 + this.tw), (double)(24 + 2 * this.th)), new Vertex5(0.5 + this.w, this.h, 0.5 + l, (double)(8 + this.tw), (double)(24 + this.th)), new Vertex5(0.5 - this.w, this.h, 0.5 + l, (double)(8 - this.tw), (double)(24 + this.th)), new Vertex5(0.5 - this.w, this.h, 0.5 + l, (double)(8 - this.tw), (double)(16 + tl)), new Vertex5(0.5 + this.w, this.h, 0.5 + l, (double)(8 + this.tw), (double)(16 + tl)), new Vertex5(0.5 + this.w, this.h, 0.5 + this.w, (double)(8 + this.tw), (double)(16 + this.tw)), new Vertex5(0.5 - this.w, this.h, 0.5 + this.w, (double)(8 - this.tw), (double)(16 + this.tw)), new Vertex5(0.5 - this.w, 0.0, 0.5 + this.w, 0.0, (double)(16 + this.tw)), new Vertex5(0.5 - this.w, 0.0, 0.5 + l, 0.0, (double)(16 + tl)), new Vertex5(0.5 - this.w, this.h, 0.5 + l, (double)this.th, (double)(16 + tl)), new Vertex5(0.5 - this.w, this.h, 0.5 + this.w, (double)this.th, (double)(16 + this.tw)), new Vertex5(0.5 + this.w, 0.0, 0.5 + l, 16.0, (double)(16 + tl)), new Vertex5(0.5 + this.w, 0.0, 0.5 + this.w, 16.0, (double)(16 + this.tw)), new Vertex5(0.5 + this.w, this.h, 0.5 + this.w, (double)(16 - this.th), (double)(16 + this.tw)), new Vertex5(0.5 + this.w, this.h, 0.5 + l, (double)(16 - this.th), (double)(16 + tl))};
    }

    private Vertex5[] generateStub(int r) {
        Vertex5[] verts = this.generateExtension(4);
        for (int i = 0; i < 4; ++i) {
            verts[i].vec.z -= 0.002;
        }
        this.reflectSide(verts, r);
        return verts;
    }

    private Vertex5[] generateFlat(int r) {
        Vertex5[] verts = new Vertex5[]{new Vertex5(0.5 - this.w, 0.0, 0.5 + this.w, 16.0, (double)(16 + this.tw)), new Vertex5(0.5 + this.w, 0.0, 0.5 + this.w, 16.0, (double)(16 - this.tw)), new Vertex5(0.5 + this.w, this.h, 0.5 + this.w, (double)(16 - this.th), (double)(16 - this.tw)), new Vertex5(0.5 - this.w, this.h, 0.5 + this.w, (double)(16 - this.th), (double)(16 + this.tw))};
        if (Rotation.rotateSide((int)this.side, (int)r) % 2 == 0) {
            WireModelBuilder.apply(ROTATE_WIRE_UV_180, verts);
        }
        return verts;
    }

    private Vertex5[] generateCorner(int r) {
        Vertex5[] verts = this.generateExtension(8 + this.th);
        WireModelBuilder.apply((UVTransformation)new UVTranslation(0.0, (double)(-this.th)), verts, 0, 4);
        verts = Arrays.copyOf(verts, 20);
        verts[16] = new Vertex5(0.5 - this.w, 0.0, 1.0, (double)(8 - this.tw), (double)(24 + 2 * this.th));
        verts[17] = new Vertex5(0.5 + this.w, 0.0, 1.0, (double)(8 + this.tw), (double)(24 + 2 * this.th));
        verts[18] = new Vertex5(0.5 + this.w, 0.0, 1.0 + this.h, (double)(8 + this.tw), (double)(24 + this.th));
        verts[19] = new Vertex5(0.5 - this.w, 0.0, 1.0 + this.h, (double)(8 - this.tw), (double)(24 + this.th));
        this.reflectSide(verts, r);
        return verts;
    }

    private Vertex5[] generateInternal(int r) {
        Vertex5[] verts = this.generateExtension(8);
        verts[0].uv.set((double)(8 + this.tw), 24.0);
        verts[1].uv.set((double)(8 - this.tw), 24.0);
        verts[2].uv.set((double)(8 - this.tw), (double)(24 + this.tw));
        verts[3].uv.set((double)(8 + this.tw), (double)(24 + this.tw));
        this.reflectSide(verts, r);
        WireModelBuilder.apply((UVTransformation)new UVTranslation(16.0, 0.0), verts, 4, 16);
        return verts;
    }

    private Vertex5[] generateSideFromType(int stype, int r) {
        return switch (stype) {
            case 0 -> this.generateFlat(r);
            case 1 -> this.generateCorner(r);
            case 16 -> this.generateStraight(r);
            default -> this.generateInternal(r);
        };
    }

    private Vertex5[] withBottom(Vertex5[] verts, int start, int count) {
        Vertex5[] newVerts = new Vertex5[verts.length + count];
        Transformation r = new Rotation(Math.PI, 0.0, 0.0, 1.0).at(new Vector3(0.5, this.h / 2.0, 0.0));
        for (int i = 0; i < count; ++i) {
            newVerts[i] = verts[i + start].copy().apply(r);
        }
        System.arraycopy(verts, 0, newVerts, count, verts.length);
        return newVerts;
    }

    private void reflectSide(Vertex5[] verts, int r) {
        if ((r + BundledSignalsLib.bundledCableBaseRotationMap[this.side]) % 4 >= 2) {
            WireModelBuilder.apply(ROTATE_WIRE_UV_180, verts);
        }
    }

    public static int countConnections(int mask) {
        int n = 0;
        for (int r = 0; r < 4; ++r) {
            if ((mask & 1 << r) == 0) continue;
            ++n;
        }
        return n;
    }

    public static int addVerts(CCModel model, Vertex5[] verts, int k) {
        System.arraycopy(verts, 0, model.verts, k, verts.length);
        return k + verts.length;
    }

    public static void apply(Transformation t, Vertex5[] verts) {
        WireModelBuilder.apply(t, verts, 0, verts.length);
    }

    public static void apply(UVTransformation t, Vertex5[] verts) {
        WireModelBuilder.apply(t, verts, 0, verts.length);
    }

    public static void apply(Transformation t, Vertex5[] verts, int start, int end) {
        for (int i = start; i < end; ++i) {
            verts[i].apply(t);
        }
    }

    public static void apply(UVTransformation t, Vertex5[] verts, int start, int end) {
        for (int i = start; i < end; ++i) {
            verts[i].apply(t);
        }
    }

    public static void apply(Transformation t, CCModel model, int start, int end) {
        WireModelBuilder.apply(t, model.verts, start, end);
    }

    public static void finishModel(CCModel model) {
        model.apply((UVTransformation)new UVScale(0.03125));
        model.shrinkUVs(5.0E-4);
        model.computeNormals();
        model.computeLighting(LightModel.standardLightModel);
    }
}

