/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.serialization.gson;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.UUID;
import li.cil.oc2.common.bus.RPCDeviceBusAdapter;

public final class MessageJsonDeserializer
implements JsonDeserializer<RPCDeviceBusAdapter.Message> {
    public RPCDeviceBusAdapter.Message deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        String messageType;
        JsonObject jsonObject = json.getAsJsonObject();
        UUID messageData = switch (messageType = jsonObject.get("type").getAsString()) {
            case "list" -> null;
            case "subscribe" -> UUID.fromString(jsonObject.getAsJsonPrimitive("data").getAsString());
            case "unsubscribe" -> UUID.fromString(jsonObject.getAsJsonPrimitive("data").getAsString());
            case "methods" -> UUID.fromString(jsonObject.getAsJsonPrimitive("data").getAsString());
            case "invoke" -> context.deserialize((JsonElement)jsonObject.getAsJsonObject("data"), RPCDeviceBusAdapter.MethodInvocation.class);
            default -> throw new JsonParseException("unknown message type: " + messageType);
        };
        return new RPCDeviceBusAdapter.Message(messageType, messageData);
    }
}

