/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.util;

import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import li.cil.oc2.common.config.AsyncConfig;
import li.cil.oc2.common.event.ForgeEventHandlers;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class AsyncUtils {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ExecutorService ASYNC_EXECUTOR = new ForkJoinPool(Math.max(1, Runtime.getRuntime().availableProcessors() / 2), ForkJoinPool.defaultForkJoinWorkerThreadFactory, (t, e) -> LOGGER.error("Uncaught exception in async executor thread", e), true){

        @Override
        public List<Runnable> shutdownNow() {
            List<Runnable> tasks = super.shutdownNow();
            for (Thread worker : this.getActiveWorkers()) {
                worker.interrupt();
            }
            return tasks;
        }

        private Set<Thread> getActiveWorkers() {
            ConcurrentHashMap.KeySetView workers = ConcurrentHashMap.newKeySet();
            for (Thread thread : Thread.getAllStackTraces().keySet()) {
                if (!thread.getName().startsWith("ForkJoinPool") || !thread.isAlive()) continue;
                workers.add(thread);
            }
            return workers;
        }
    };

    public static ExecutorService getAsyncExecutor() {
        return ASYNC_EXECUTOR;
    }

    private AsyncUtils() {
    }

    public static <T> CompletableFuture<T> runAsync(Supplier<T> task, String description) {
        if (ASYNC_EXECUTOR.isShutdown()) {
            LOGGER.warn("Attempted to submit async task '{}' after executor was shut down", (Object)description);
            CompletableFuture failedFuture = new CompletableFuture();
            failedFuture.completeExceptionally(new RejectedExecutionException("Executor has been shut down"));
            return failedFuture;
        }
        try {
            if (AsyncConfig.SERVER != null && ((Boolean)AsyncConfig.SERVER.enableSuperDebug.get()).booleanValue()) {
                LOGGER.info("Starting async task: {}", (Object)description);
                AsyncUtils.logStackTrace("Async task stack trace");
            }
        }
        catch (IllegalStateException e) {
            LOGGER.trace("Config not loaded yet, skipping debug logging for: {}", (Object)description);
        }
        try {
            return CompletableFuture.supplyAsync(() -> {
                try {
                    Object t = task.get();
                    return t;
                }
                catch (Throwable t) {
                    LOGGER.error("Error in async task: " + description, t);
                    throw t;
                }
                finally {
                    try {
                        if (AsyncConfig.SERVER != null && ((Boolean)AsyncConfig.SERVER.enableSuperDebug.get()).booleanValue()) {
                            LOGGER.info("Completed async task: {}", (Object)description);
                        }
                    }
                    catch (IllegalStateException e) {
                        LOGGER.trace("Config not loaded yet, skipping debug logging for: {}", (Object)description);
                    }
                }
            }, ASYNC_EXECUTOR);
        }
        catch (RejectedExecutionException e) {
            LOGGER.warn("Failed to submit async task '{}' - executor is shutting down", (Object)description, (Object)e);
            CompletableFuture failedFuture = new CompletableFuture();
            failedFuture.completeExceptionally(e);
            return failedFuture;
        }
    }

    public static CompletableFuture<Void> runAsync(Runnable task, String description) {
        return AsyncUtils.runAsync(() -> {
            task.run();
            return null;
        }, description);
    }

    public static boolean isShutdown() {
        return ASYNC_EXECUTOR.isShutdown();
    }

    public static void logStackTrace(String message) {
        try {
            if (AsyncConfig.SERVER != null && ((Boolean)AsyncConfig.SERVER.enableSuperDebug.get()).booleanValue()) {
                StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
                StringBuilder sb = new StringBuilder(message).append("\n");
                for (int i = 2; i < stackTrace.length; ++i) {
                    sb.append("\tat ").append(stackTrace[i]).append("\n");
                }
                LOGGER.info(sb.toString());
            }
        }
        catch (IllegalStateException e) {
            LOGGER.trace("Config not loaded yet, skipping stack trace logging");
        }
    }

    public static <T> CompletableFuture<T> onServerThread(Supplier<T> task) {
        MinecraftServer server = ForgeEventHandlers.getCurrentServer();
        if (server == null) {
            return CompletableFuture.failedFuture(new IllegalStateException("No server available"));
        }
        CompletableFuture future = new CompletableFuture();
        server.execute(() -> {
            if (((Boolean)AsyncConfig.SERVER.enableSuperDebug.get()).booleanValue()) {
                LOGGER.debug("Executing task on server thread");
            }
            try {
                future.complete(task.get());
            }
            catch (Throwable t) {
                LOGGER.error("Error in server thread task", t);
                future.completeExceptionally(t);
            }
        });
        return future;
    }

    public static CompletableFuture<Void> onServerThread(Runnable task) {
        return AsyncUtils.onServerThread(() -> {
            task.run();
            return null;
        });
    }

    @Nullable
    public static Executor getServerExecutor() {
        MinecraftServer server = ForgeEventHandlers.getCurrentServer();
        return server != null ? server : null;
    }

    public static void shutdown() {
        if (ASYNC_EXECUTOR.isShutdown()) {
            return;
        }
        boolean debug = false;
        try {
            debug = AsyncConfig.SERVER != null && (Boolean)AsyncConfig.SERVER.enableSuperDebug.get() != false;
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (debug) {
            LOGGER.info("Initiating async executor shutdown...");
        }
        ASYNC_EXECUTOR.shutdown();
        try {
            if (!ASYNC_EXECUTOR.awaitTermination(1L, TimeUnit.SECONDS)) {
                if (debug) {
                    LOGGER.warn("Async executor did not shut down within timeout, forcing immediate shutdown");
                } else {
                    LOGGER.warn("Async executor did not shut down within timeout, forcing immediate shutdown");
                }
                List<Runnable> runningTasks = ASYNC_EXECUTOR.shutdownNow();
                if (debug && !runningTasks.isEmpty()) {
                    LOGGER.warn("Cancelled {} running tasks", (Object)runningTasks.size());
                }
                if (!ASYNC_EXECUTOR.awaitTermination(100L, TimeUnit.MILLISECONDS)) {
                    LOGGER.warn("Some tasks did not respond to cancellation");
                }
            }
        }
        catch (InterruptedException e) {
            LOGGER.warn("Interrupted while waiting for async executor to shut down, forcing immediate shutdown", (Throwable)e);
            ASYNC_EXECUTOR.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }
}

