/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.util;

import java.lang.ref.WeakReference;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;

public record BlockLocation(WeakReference<LevelAccessor> level, BlockPos blockPos) {
    public static BlockLocation of(Entity entity) {
        return new BlockLocation(new WeakReference<Level>(entity.m_9236_()), entity.m_20183_());
    }

    public static BlockLocation of(BlockEntity blockEntity) {
        return new BlockLocation(new WeakReference<Level>(blockEntity.m_58904_()), blockEntity.m_58899_());
    }

    public static Optional<BlockLocation> ofOptional(Entity entity) {
        if (entity.m_6084_()) {
            return Optional.of(BlockLocation.of(entity));
        }
        return Optional.empty();
    }

    public static Optional<BlockLocation> ofOptional(BlockEntity blockEntity) {
        if (!blockEntity.m_58901_()) {
            return Optional.of(BlockLocation.of(blockEntity));
        }
        return Optional.empty();
    }

    public Optional<LevelAccessor> tryGetLevel() {
        return Optional.ofNullable((LevelAccessor)this.level.get());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof BlockLocation) {
            LevelAccessor thatLevel;
            BlockLocation that = (BlockLocation)obj;
            LevelAccessor thisLevel = (LevelAccessor)this.level.get();
            return Objects.equals(thisLevel, thatLevel = (LevelAccessor)that.level.get()) && Objects.equals(this.blockPos, that.blockPos);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.level.get(), this.blockPos);
    }
}

