/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import li.cil.oc2.api.bus.device.DeviceType;
import li.cil.oc2.api.bus.device.provider.BlockDeviceProvider;
import li.cil.oc2.api.bus.device.provider.ItemDeviceProvider;
import li.cil.oc2.common.bus.device.provider.ProviderRegistry;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.IForgeRegistry;

public abstract class RegistryUtils {
    private static final List<DeferredRegister<?>> ENTRIES = new ArrayList();
    private static Phase phase = Phase.PRE_INIT;

    public static <T extends IForgeRegistry<T>> DeferredRegister<T> getInitializerFor(ResourceKey<Registry<T>> key) {
        if (phase != Phase.INIT) {
            throw new IllegalStateException();
        }
        DeferredRegister entry = DeferredRegister.create(key, (String)"oc2r");
        ENTRIES.add(entry);
        return entry;
    }

    public static <T extends IForgeRegistry<T>> DeferredRegister<T> getInitializerFor(IForgeRegistry<T> registry) {
        if (phase != Phase.INIT) {
            throw new IllegalStateException();
        }
        DeferredRegister entry = DeferredRegister.create(registry, (String)"oc2r");
        ENTRIES.add(entry);
        return entry;
    }

    public static void begin() {
        if (phase != Phase.PRE_INIT) {
            throw new IllegalStateException();
        }
        phase = Phase.INIT;
    }

    public static void finish(FMLJavaModLoadingContext context) {
        if (phase != Phase.INIT) {
            throw new IllegalStateException();
        }
        phase = Phase.POST_INIT;
        for (DeferredRegister<?> register : ENTRIES) {
            register.register(context.getModEventBus());
        }
        ENTRIES.clear();
    }

    public static <T> String key(DeviceType registryEntry) {
        return Objects.requireNonNull(registryEntry.getName()).toString();
    }

    public static <T> Optional<String> optionalKey(@Nullable T registryEntry) {
        if (registryEntry == null) {
            return Optional.empty();
        }
        String providerName = null;
        if (BlockDeviceProvider.class.isAssignableFrom(registryEntry.getClass())) {
            providerName = ProviderRegistry.BLOCK_DEVICE_PROVIDER_REGISTRY.get().getRegistryName().toString();
        } else if (ItemDeviceProvider.class.isAssignableFrom(registryEntry.getClass())) {
            providerName = ProviderRegistry.ITEM_DEVICE_PROVIDER_REGISTRY.get().getRegistryName().toString();
        }
        if (providerName == null) {
            return Optional.empty();
        }
        return Optional.of(providerName);
    }

    private RegistryUtils() {
    }

    private static enum Phase {
        PRE_INIT,
        INIT,
        POST_INIT;

    }
}

