/*
 * Decompiled with CFR 0.152.
 */
package lib.multiblock;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import lib.multiblock.impl.IMultiBlockPattern;
import lib.multiblock.impl.IMultiBlockPatternBuilder;
import lib.multiblock.impl.IPatternBuilder;
import lib.multiblock.misc.MultiBlockOffsetPos;
import lib.multiblock.misc.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class SimpleMultiBlockAislePatternBuilder
implements IMultiBlockPatternBuilder {
    private final List<String[]> pattern = Lists.newArrayList();
    private final Map<Character, Predicate<BlockInWorld>> lookup = Maps.newHashMap();
    private final Map<Character, Supplier<BlockState>> blockProvider = Maps.newHashMap();
    private int height;
    private int width;

    public static SimpleMultiBlockAislePatternBuilder start() {
        return new SimpleMultiBlockAislePatternBuilder();
    }

    private SimpleMultiBlockAislePatternBuilder() {
    }

    public SimpleMultiBlockAislePatternBuilder aisle(String ... pAisle) {
        if (!ArrayUtils.isEmpty((Object[])pAisle) && !StringUtils.isEmpty((CharSequence)pAisle[0])) {
            if (this.pattern.isEmpty()) {
                this.height = pAisle.length;
                this.width = pAisle[0].length();
            }
            if (pAisle.length != this.height) {
                throw new IllegalArgumentException("Expected aisle with height of " + this.height + ", but was given one with a height of " + pAisle.length + ")");
            }
            for (String s : pAisle) {
                if (s.length() == this.width) continue;
                throw new IllegalArgumentException("Not all rows in the given aisle are the correct width (expected " + this.width + ", found one with " + s.length() + ")");
            }
            this.pattern.add(pAisle);
            return this;
        }
        throw new IllegalArgumentException("Empty pattern for aisle");
    }

    public SimpleMultiBlockAislePatternBuilder where(char pSymbol, Predicate<BlockInWorld> pBlockMatcher) {
        this.lookup.put(Character.valueOf(pSymbol), pBlockMatcher);
        return this;
    }

    public SimpleMultiBlockAislePatternBuilder block(char pSymbol, Supplier<BlockState> blockStateSupplier) {
        this.blockProvider.put(Character.valueOf(pSymbol), blockStateSupplier);
        return this;
    }

    @Override
    public <T extends IMultiBlockPattern> T build(IPatternBuilder<T> builder) {
        Map<Character, List<MultiBlockOffsetPos>> data = Util.parseBlockPattern(this.pattern, this.lookup.keySet());
        List<MultiBlockOffsetPos> coreList = data.get(Character.valueOf('*'));
        if (coreList == null || coreList.size() != 1) {
            throw new IllegalArgumentException("Failed to build pattern due to having more or less than one \"*\" defined! Have: %s Expected: 1".formatted(coreList != null ? coreList.size() : 0));
        }
        ArrayList list = Lists.newArrayList();
        data.forEach((k, v) -> list.addAll(v));
        return builder.make(list, this.lookup, this.blockProvider);
    }

    public BlockPos getDistanceController(char character) {
        Map<Character, List<MultiBlockOffsetPos>> data = Util.parseBlockPattern(this.pattern, this.lookup.keySet());
        List<MultiBlockOffsetPos> coreList = data.get(Character.valueOf(character));
        return coreList.get(0).pos();
    }
}

