/*
 * Decompiled with CFR 0.152.
 */
package net.nuclearteam.createnuclear.infrastructure.worldgen;

import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ForgeBiomeModifiers;
import net.minecraftforge.registries.ForgeRegistries;
import net.nuclearteam.createnuclear.CreateNuclear;
import net.nuclearteam.createnuclear.infrastructure.worldgen.CNPlacedFeatures;

public class CNBiomeModifiers {
    public static final ResourceKey<BiomeModifier> URANIUM_ORE = CNBiomeModifiers.key("uranium_ore");
    public static final ResourceKey<BiomeModifier> LEAD_ORE = CNBiomeModifiers.key("lead_ore");
    public static final ResourceKey<BiomeModifier> STRIATED_ORES_OVERWORLD = CNBiomeModifiers.key("striated_ores_overworld");

    private static ResourceKey<BiomeModifier> key(String name) {
        return ResourceKey.m_135785_((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)CreateNuclear.asResource(name));
    }

    public static void bootstrap(BootstapContext<BiomeModifier> ctx) {
        HolderGetter biomeLookup = ctx.m_255420_(Registries.f_256952_);
        HolderSet.Named isOverworld = biomeLookup.m_254956_(BiomeTags.f_215817_);
        HolderGetter featureLookup = ctx.m_255420_(Registries.f_256988_);
        Holder.Reference uraniumOre = featureLookup.m_255043_(CNPlacedFeatures.URANIUM_ORE);
        Holder.Reference leadOre = featureLookup.m_255043_(CNPlacedFeatures.LEAD_ORE);
        Holder.Reference striatedOresOverworld = featureLookup.m_255043_(CNPlacedFeatures.STRIATED_ORES_OVERWORLD);
        ctx.m_255272_(URANIUM_ORE, (Object)CNBiomeModifiers.addOre((HolderSet<Biome>)isOverworld, (Holder<PlacedFeature>)uraniumOre));
        ctx.m_255272_(LEAD_ORE, (Object)CNBiomeModifiers.addOre((HolderSet<Biome>)isOverworld, (Holder<PlacedFeature>)leadOre));
        ctx.m_255272_(STRIATED_ORES_OVERWORLD, (Object)CNBiomeModifiers.addOre((HolderSet<Biome>)isOverworld, (Holder<PlacedFeature>)striatedOresOverworld));
    }

    private static ForgeBiomeModifiers.AddFeaturesBiomeModifier addOre(HolderSet<Biome> biomes, Holder<PlacedFeature> feature) {
        return new ForgeBiomeModifiers.AddFeaturesBiomeModifier(biomes, (HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{feature}), GenerationStep.Decoration.UNDERGROUND_ORES);
    }
}

