/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.camera.infrastructure;

import io.github.mortuusars.exposure.util.Fov;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class EntitiesInFrame {
    public static List<Entity> get(Player player, double fov, int limit, boolean inSelfieMode) {
        double currentFov = fov / (double)1.142857f;
        double currentFocalLength = Fov.fovToFocalLength(currentFov);
        Vec3 cameraPos = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        List entities = player.m_9236_().m_6249_((Entity)player, new AABB(player.m_20183_()).m_82400_(128.0), entity -> entity instanceof LivingEntity);
        entities.sort((entity, entity2) -> {
            float dist2;
            float dist1 = player.m_20270_(entity);
            if (dist1 == (dist2 = player.m_20270_(entity2))) {
                return 0;
            }
            return dist1 > dist2 ? 1 : -1;
        });
        ArrayList<Entity> entitiesInFrame = new ArrayList<Entity>();
        for (Entity entity3 : entities) {
            if (entitiesInFrame.size() >= limit) break;
            if (!EntitiesInFrame.isInFOV(currentFov, entity3) || EntitiesInFrame.getPerceivedDistance(cameraPos, entity3) > currentFocalLength || !player.m_142582_(entity3)) continue;
            entitiesInFrame.add(entity3);
        }
        if (inSelfieMode) {
            entitiesInFrame.add(0, (Entity)player);
        }
        return entitiesInFrame;
    }

    public static double getPerceivedDistance(Vec3 cameraPos, Entity entity) {
        double distanceInBlocks = Math.sqrt(entity.m_20238_(cameraPos));
        AABB boundingBox = entity.m_6921_();
        double size = boundingBox.m_82309_();
        if (Double.isNaN(size) || size == 0.0) {
            size = 0.1;
        }
        double sizeModifier = (size - 1.0) * 0.6 + 1.0;
        return distanceInBlocks / sizeModifier / (double)1.142857f;
    }

    public static boolean isInFOV(double fov, Entity target) {
        Vec3 targetEyePos;
        Vec3 cameraLookAngle;
        Camera camera = Minecraft.m_91087_().f_91063_.m_109153_();
        Vec3 cameraPos = camera.m_90583_();
        double relativeAngle = EntitiesInFrame.getRelativeAngle(cameraPos, cameraLookAngle = new Vec3(camera.m_253058_()), targetEyePos = target.m_20182_().m_82520_(0.0, (double)target.m_20192_(), 0.0));
        return relativeAngle <= fov / 2.0;
    }

    public static double getRelativeAngle(Vec3 cameraPos, Vec3 cameraLookAngle, Vec3 targetEyePos) {
        Vec3 originToTargetAngle = targetEyePos.m_82546_(cameraPos).m_82541_();
        return Math.toDegrees(Math.acos(cameraLookAngle.m_82526_(originToTargetAngle)));
    }
}

