/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.store;

import guideme.internal.shaded.lucene.store.DataInput;
import guideme.internal.shaded.lucene.util.BitUtil;
import guideme.internal.shaded.lucene.util.BytesRef;
import guideme.internal.shaded.lucene.util.GroupVIntUtil;
import java.io.IOException;
import java.util.Map;
import java.util.Set;

public abstract class DataOutput {
    private byte[] groupVIntBytes;
    private static int COPY_BUFFER_SIZE = 16384;
    private byte[] copyBuffer;

    public abstract void writeByte(byte var1) throws IOException;

    public void writeBytes(byte[] b, int length) throws IOException {
        this.writeBytes(b, 0, length);
    }

    public abstract void writeBytes(byte[] var1, int var2, int var3) throws IOException;

    public void writeInt(int i) throws IOException {
        this.writeByte((byte)i);
        this.writeByte((byte)(i >> 8));
        this.writeByte((byte)(i >> 16));
        this.writeByte((byte)(i >> 24));
    }

    public void writeShort(short i) throws IOException {
        this.writeByte((byte)i);
        this.writeByte((byte)(i >> 8));
    }

    public final void writeVInt(int i) throws IOException {
        while ((i & 0xFFFFFF80) != 0) {
            this.writeByte((byte)(i & 0x7F | 0x80));
            i >>>= 7;
        }
        this.writeByte((byte)i);
    }

    public final void writeZInt(int i) throws IOException {
        this.writeVInt(BitUtil.zigZagEncode(i));
    }

    public void writeLong(long i) throws IOException {
        this.writeInt((int)i);
        this.writeInt((int)(i >> 32));
    }

    public final void writeVLong(long i) throws IOException {
        if (i < 0L) {
            throw new IllegalArgumentException("cannot write negative vLong (got: " + i + ")");
        }
        this.writeSignedVLong(i);
    }

    private void writeSignedVLong(long i) throws IOException {
        while ((i & 0xFFFFFFFFFFFFFF80L) != 0L) {
            this.writeByte((byte)(i & 0x7FL | 0x80L));
            i >>>= 7;
        }
        this.writeByte((byte)i);
    }

    public final void writeZLong(long i) throws IOException {
        this.writeSignedVLong(BitUtil.zigZagEncode(i));
    }

    public void writeString(String s) throws IOException {
        BytesRef utf8Result = new BytesRef(s);
        this.writeVInt(utf8Result.length);
        this.writeBytes(utf8Result.bytes, utf8Result.offset, utf8Result.length);
    }

    public void copyBytes(DataInput input, long numBytes) throws IOException {
        assert (numBytes >= 0L) : "numBytes=" + numBytes;
        long left = numBytes;
        if (this.copyBuffer == null) {
            this.copyBuffer = new byte[COPY_BUFFER_SIZE];
        }
        while (left > 0L) {
            int toCopy = left > (long)COPY_BUFFER_SIZE ? COPY_BUFFER_SIZE : (int)left;
            input.readBytes(this.copyBuffer, 0, toCopy);
            this.writeBytes(this.copyBuffer, 0, toCopy);
            left -= (long)toCopy;
        }
    }

    public void writeMapOfStrings(Map<String, String> map) throws IOException {
        this.writeVInt(map.size());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.writeString(entry.getKey());
            this.writeString(entry.getValue());
        }
    }

    public void writeSetOfStrings(Set<String> set) throws IOException {
        this.writeVInt(set.size());
        for (String value : set) {
            this.writeString(value);
        }
    }

    public void writeGroupVInts(long[] values, int limit) throws IOException {
        if (this.groupVIntBytes == null) {
            this.groupVIntBytes = new byte[17];
        }
        GroupVIntUtil.writeGroupVInts(this, this.groupVIntBytes, values, limit);
    }
}

