/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.common.item.tabs.forge;

import com.teamresourceful.resourcefullib.common.item.tabs.ResourcefulCreativeTab;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public class ResourcefulCreativeTabImpl {
    private static final Map<String, DeferredRegister<CreativeModeTab>> CREATIVE_TABS = new ConcurrentHashMap<String, DeferredRegister<CreativeModeTab>>();

    public static Supplier<CreativeModeTab> create(ResourcefulCreativeTab tab) {
        return Entry.of(tab);
    }

    private static RegistryObject<CreativeModeTab> register(ResourceLocation id, Supplier<CreativeModeTab> tab) {
        DeferredRegister register = CREATIVE_TABS.computeIfAbsent(id.m_135827_(), namespace -> {
            DeferredRegister registry = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)namespace);
            registry.register(FMLJavaModLoadingContext.get().getModEventBus());
            return registry;
        });
        return register.register(id.m_135815_(), tab);
    }

    private record Entry(RegistryObject<CreativeModeTab> builtTab) implements Supplier<CreativeModeTab>
    {
        public static Entry of(ResourcefulCreativeTab tab) {
            CreativeModeTab.Builder creativeTab = CreativeModeTab.builder().m_257737_(() -> tab.icon.get()).m_257941_((Component)Component.m_237115_((String)("itemGroup." + tab.id.m_135827_() + "." + tab.id.m_135815_())));
            if (tab.hideScrollBar) {
                creativeTab.m_257794_();
            }
            if (tab.hideTitle) {
                creativeTab.m_257809_();
            }
            creativeTab.m_257501_((params, output) -> {
                tab.registries.forEach(registry -> registry.boundStream().forEach(arg_0 -> ((CreativeModeTab.Output)output).m_246326_(arg_0)));
                tab.stacks.stream().map(Supplier::get).forEach(arg_0 -> ((CreativeModeTab.Output)output).m_246342_(arg_0));
                tab.contents.stream().flatMap(Supplier::get).forEach(arg_0 -> ((CreativeModeTab.Output)output).m_246342_(arg_0));
            });
            return new Entry(ResourcefulCreativeTabImpl.register(tab.id, () -> ((CreativeModeTab.Builder)creativeTab).m_257652_()));
        }

        @Override
        public CreativeModeTab get() {
            return (CreativeModeTab)this.builtTab.get();
        }
    }
}

