/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.datagen;

import com.google.common.base.Preconditions;
import it.zerono.mods.zerocore.lib.data.ResourceLocationBuilder;
import it.zerono.mods.zerocore.lib.datagen.IModDataProvider;
import it.zerono.mods.zerocore.lib.datagen.provider.loot.SubProviderBuilder;
import it.zerono.mods.zerocore.lib.datagen.provider.tag.IIntrinsicTagDataProvider;
import it.zerono.mods.zerocore.lib.datagen.provider.tag.ITagDataProvider;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.Util;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.util.NonNullConsumer;
import net.minecraftforge.common.util.NonNullFunction;

public interface IModDataGenerator {
    public CompletableFuture<HolderLookup.Provider> getRegistryLookup();

    public ResourceLocationBuilder getModRoot();

    public <P extends DataProvider> void addProvider(DataProvider.Factory<P> var1);

    default public <P extends IModDataProvider> void addProvider(final IModDataProvider.ModFactory<P> factory) {
        this.addProvider(output -> new DataProvider(){
            private final IModDataProvider _provider;
            {
                this._provider = factory.create(output, IModDataGenerator.this.getRegistryLookup(), IModDataGenerator.this.getModRoot());
            }

            public CompletableFuture<?> m_213708_(CachedOutput cache) {
                this._provider.provideData();
                return this._provider.lookup(lookup -> this._provider.processData(cache, (HolderLookup.Provider)lookup));
            }

            public String m_6055_() {
                return this._provider.getSettings().name();
            }
        });
    }

    public <T> void addTagsProvider(ResourceKey<? extends Registry<T>> var1, ITagDataProvider<T> var2);

    public <T> void addTagsProvider(ResourceKey<? extends Registry<T>> var1, NonNullFunction<T, ResourceKey<T>> var2, IIntrinsicTagDataProvider<T> var3);

    default public void addBlockTagsProvider(IIntrinsicTagDataProvider<Block> provider) {
        this.addTagsProvider(Registries.f_256747_, $ -> $.m_204297_().m_205785_(), provider);
    }

    default public void addItemTagsProvider(IIntrinsicTagDataProvider<Item> provider) {
        this.addTagsProvider(Registries.f_256913_, $ -> $.m_204114_().m_205785_(), provider);
    }

    default public void addEntityTypeTagsProvider(IIntrinsicTagDataProvider<EntityType<?>> provider) {
        this.addTagsProvider(Registries.f_256939_, $ -> $.m_204041_().m_205785_(), provider);
    }

    default public void addFluidTagsProvider(IIntrinsicTagDataProvider<Fluid> provider) {
        this.addTagsProvider(Registries.f_256808_, $ -> $.m_205069_().m_205785_(), provider);
    }

    default public void addGameEventTagsProvider(IIntrinsicTagDataProvider<GameEvent> provider) {
        this.addTagsProvider(Registries.f_256827_, $ -> $.m_204530_().m_205785_(), provider);
    }

    default public void addLootProvider(Set<ResourceLocation> requiredTables, NonNullConsumer<SubProviderBuilder> subProvidersBuilder) {
        Preconditions.checkNotNull(requiredTables, (Object)"Required tables must not be null");
        Preconditions.checkNotNull(subProvidersBuilder, (Object)"Sub providers builder must not be null");
        SubProviderBuilder builder = (SubProviderBuilder)Util.m_137469_((Object)new SubProviderBuilder(), arg_0 -> subProvidersBuilder.accept(arg_0));
        this.addProvider(output -> new LootTableProvider(output, requiredTables, builder.getEntries()));
    }

    default public void addLootProvider(NonNullConsumer<SubProviderBuilder> subProvidersBuilder) {
        this.addLootProvider(Set.of(), subProvidersBuilder);
    }
}

