/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.recipe.serializer;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.zerono.mods.zerocore.lib.data.json.JSONHelper;
import it.zerono.mods.zerocore.lib.recipe.AbstractTwoToOneRecipe;
import it.zerono.mods.zerocore.lib.recipe.ingredient.IRecipeIngredient;
import it.zerono.mods.zerocore.lib.recipe.result.IRecipeResult;
import java.util.function.Function;
import java.util.function.IntFunction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.Nullable;

public class TwoToOneRecipeSerializer<Ingredient1, Ingredient2, Result, RecipeIngredient1 extends IRecipeIngredient<Ingredient1>, RecipeIngredient2 extends IRecipeIngredient<Ingredient2>, RecipeResult extends IRecipeResult<Result>, Recipe extends AbstractTwoToOneRecipe<Ingredient1, Ingredient2, Result, RecipeIngredient1, RecipeIngredient2, RecipeResult>>
implements RecipeSerializer<Recipe> {
    private final AbstractTwoToOneRecipe.IRecipeFactory<Ingredient1, Ingredient2, Result, RecipeIngredient1, RecipeIngredient2, RecipeResult, Recipe> _recipeFactory;
    private final Function<JsonElement, RecipeIngredient1> _jsonIngredient1Factory;
    private final Function<FriendlyByteBuf, RecipeIngredient1> _packetIngredient1Factory;
    private final Function<JsonElement, RecipeIngredient2> _jsonIngredient2Factory;
    private final Function<FriendlyByteBuf, RecipeIngredient2> _packetIngredient2Factory;
    private final Function<JsonElement, RecipeResult> _jsonResultFactory;
    private final Function<FriendlyByteBuf, RecipeResult> _packetResultFactory;
    private final IntFunction<String> _jsonIngredientsLabelsSupplier;

    public TwoToOneRecipeSerializer(AbstractTwoToOneRecipe.IRecipeFactory<Ingredient1, Ingredient2, Result, RecipeIngredient1, RecipeIngredient2, RecipeResult, Recipe> recipeFactory, Function<JsonElement, RecipeIngredient1> jsonIngredient1Factory, Function<FriendlyByteBuf, RecipeIngredient1> packetIngredient1Factory, Function<JsonElement, RecipeIngredient2> jsonIngredient2Factory, Function<FriendlyByteBuf, RecipeIngredient2> packetIngredient2Factory, Function<JsonElement, RecipeResult> jsonResultFactory, Function<FriendlyByteBuf, RecipeResult> packetResultFactory, IntFunction<String> jsonIngredientsLabelsSupplier) {
        this._recipeFactory = recipeFactory;
        this._jsonIngredient1Factory = jsonIngredient1Factory;
        this._packetIngredient1Factory = packetIngredient1Factory;
        this._jsonIngredient2Factory = jsonIngredient2Factory;
        this._packetIngredient2Factory = packetIngredient2Factory;
        this._jsonResultFactory = jsonResultFactory;
        this._packetResultFactory = packetResultFactory;
        this._jsonIngredientsLabelsSupplier = jsonIngredientsLabelsSupplier;
    }

    public Recipe fromJson(ResourceLocation recipeId, JsonObject json) {
        IRecipeIngredient ingredient1 = (IRecipeIngredient)this._jsonIngredient1Factory.apply(JSONHelper.jsonGetMandatoryElement(json, this._jsonIngredientsLabelsSupplier.apply(0)));
        IRecipeIngredient ingredient2 = (IRecipeIngredient)this._jsonIngredient2Factory.apply(JSONHelper.jsonGetMandatoryElement(json, this._jsonIngredientsLabelsSupplier.apply(1)));
        IRecipeResult result = (IRecipeResult)this._jsonResultFactory.apply(JSONHelper.jsonGetMandatoryElement(json, "result"));
        return this.create(recipeId, ingredient1, ingredient2, result);
    }

    @Nullable
    public Recipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        IRecipeIngredient ingredient1 = (IRecipeIngredient)this._packetIngredient1Factory.apply(buffer);
        IRecipeIngredient ingredient2 = (IRecipeIngredient)this._packetIngredient2Factory.apply(buffer);
        IRecipeResult result = (IRecipeResult)this._packetResultFactory.apply(buffer);
        return this.create(recipeId, ingredient1, ingredient2, result);
    }

    public void toNetwork(FriendlyByteBuf buffer, Recipe recipe) {
        ((AbstractTwoToOneRecipe)recipe).getIngredient1().serializeTo(buffer);
        ((AbstractTwoToOneRecipe)recipe).getIngredient2().serializeTo(buffer);
        ((AbstractTwoToOneRecipe)recipe).getResult().serializeTo(buffer);
    }

    private Recipe create(ResourceLocation id, RecipeIngredient1 ingredient1, RecipeIngredient2 ingredient2, RecipeResult result) {
        if (result.isEmpty()) {
            throw new IllegalArgumentException("A two-to-one recipe result cannot be empty");
        }
        return this._recipeFactory.create(id, ingredient1, ingredient2, result);
    }
}

