/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.crafting.welding;

import com.google.common.base.Objects;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.AllSpecialTextures;
import com.simibubi.create.foundation.utility.CreateLang;
import net.createmod.catnip.math.VecHelper;
import net.createmod.catnip.outliner.Outliner;
import net.createmod.catnip.render.BindableTexture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import rbasamoyai.createbigcannons.crafting.welding.CannonWelderItem;
import rbasamoyai.createbigcannons.crafting.welding.WeldableBlock;
import rbasamoyai.createbigcannons.multiloader.NetworkPlatform;
import rbasamoyai.createbigcannons.network.ServerboundUseWelderPacket;

public class CannonWelderSelectionHandler {
    private static final int HIGHLIGHT = 6067176;
    private static final int FAIL = 0xFF5555;
    private Object bbOutlineSlot = new Object();
    private BlockPos firstPos;
    private BlockPos hoveredPos;

    public void tick() {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        ClientLevel level = mc.f_91073_;
        BlockPos hovered = null;
        ItemStack stack = player.m_21205_();
        if (!(stack.m_41720_() instanceof CannonWelderItem)) {
            if (this.firstPos != null) {
                this.discard();
            }
            return;
        }
        HitResult hitResult = mc.f_91077_;
        if (hitResult != null && hitResult.m_6662_() == HitResult.Type.BLOCK) {
            hovered = ((BlockHitResult)hitResult).m_82425_();
        }
        if (hovered == null) {
            this.hoveredPos = null;
            return;
        }
        if (this.firstPos != null && this.firstPos.m_123333_((Vec3i)hovered) > 1) {
            CreateLang.builder((String)"createbigcannons").translate("cannon_welder.too_far", new Object[0]).color(0xFF5555).sendStatus((Player)player);
            return;
        }
        boolean cancel = player.m_20161_();
        if (cancel && this.firstPos == null) {
            return;
        }
        if (this.firstPos != null && Objects.equal((Object)hovered, (Object)this.hoveredPos) && !this.firstPos.equals((Object)hovered)) {
            int color = 6067176;
            String key = "cannon_welder.click_to_confirm";
            if (!CannonWelderItem.weldBlocks((Level)mc.f_91073_, this.firstPos, hovered, true)) {
                color = 0xFF5555;
                key = "cannon_welder.invalid_weld";
            } else if (cancel) {
                color = 0xFF5555;
                key = "cannon_welder.click_to_discard";
            }
            CreateLang.builder((String)"createbigcannons").translate(key, new Object[0]).color(color).sendStatus((Player)player);
            if (this.firstPos != null) {
                Outliner.getInstance().showAABB(this.bbOutlineSlot, new AABB(this.firstPos, hovered).m_82363_(1.0, 1.0, 1.0)).colored(color).withFaceTextures((BindableTexture)AllSpecialTextures.GLUE, (BindableTexture)AllSpecialTextures.GLUE).disableLineNormals().lineWidth(0.0625f);
                if (color == 6067176 && mc.f_91073_.m_46467_() % 20L == 0L) {
                    Direction dir = Direction.m_122372_((float)(hovered.m_123341_() - this.firstPos.m_123341_()), (float)(hovered.m_123342_() - this.firstPos.m_123342_()), (float)(hovered.m_123343_() - this.firstPos.m_123343_()));
                    CannonWelderSelectionHandler.spawnParticles((Level)mc.f_91073_, this.firstPos, dir, true);
                }
            }
            return;
        }
        this.hoveredPos = hovered.m_7949_();
    }

    public void discard() {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        ClientLevel level = mc.f_91073_;
        level.m_5594_((Player)player, player.m_20183_(), SoundEvents.f_11937_, SoundSource.BLOCKS, 0.75f, 1.0f);
        CreateLang.builder((String)"createbigcannons").translate("cannon_welder.abort", new Object[0]).sendStatus((Player)player);
        this.firstPos = null;
    }

    public void confirm() {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        NetworkPlatform.sendToServer(new ServerboundUseWelderPacket(this.firstPos, this.hoveredPos));
        AllSoundEvents.STEAM.playAt(player.m_9236_(), (Vec3i)this.hoveredPos, 0.5f, 0.95f, false);
        Direction dir = Direction.m_122372_((float)(this.hoveredPos.m_123341_() - this.firstPos.m_123341_()), (float)(this.hoveredPos.m_123342_() - this.firstPos.m_123342_()), (float)(this.hoveredPos.m_123343_() - this.firstPos.m_123343_()));
        CannonWelderSelectionHandler.spawnParticles((Level)mc.f_91073_, this.firstPos, dir, true);
        CreateLang.builder((String)"createbigcannons").translate("cannon_welder.success", new Object[0]).sendStatus((Player)player);
        this.firstPos = null;
    }

    public boolean onMouseInput() {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        ClientLevel level = mc.f_91073_;
        if (!(player.m_21205_().m_41720_() instanceof CannonWelderItem)) {
            return false;
        }
        if (!player.m_36326_() && !player.m_5833_()) {
            return false;
        }
        if (player.m_20161_()) {
            if (this.firstPos != null) {
                this.discard();
                return true;
            }
            return false;
        }
        if (this.hoveredPos == null) {
            return false;
        }
        Direction face = null;
        HitResult hitResult = mc.f_91077_;
        if (hitResult instanceof BlockHitResult) {
            WeldableBlock wblock;
            BlockHitResult bhr = (BlockHitResult)hitResult;
            BlockState blockState = level.m_8055_(this.hoveredPos);
            Block block = blockState.m_60734_();
            if (!(block instanceof WeldableBlock) || !(wblock = (WeldableBlock)block).isWeldable(blockState)) {
                CreateLang.builder((String)"createbigcannons").translate("cannon_welder.invalid_weld", new Object[0]).color(0xFF5555).sendStatus((Player)player);
                return false;
            }
            face = bhr.m_82434_();
        }
        player.m_6674_(InteractionHand.MAIN_HAND);
        if (this.firstPos != null) {
            if (!CannonWelderItem.weldBlocks((Level)level, this.firstPos, this.hoveredPos, true)) {
                return false;
            }
            this.confirm();
            return true;
        }
        this.firstPos = this.hoveredPos.m_7949_();
        if (face != null) {
            CannonWelderSelectionHandler.spawnParticles((Level)level, this.firstPos, face, false);
        }
        CreateLang.builder((String)"createbigcannons").translate("cannon_welder.first_pos", new Object[0]).sendStatus((Player)player);
        level.m_5594_((Player)player, this.firstPos, SoundEvents.f_11705_, SoundSource.BLOCKS, 0.75f, 1.0f);
        return true;
    }

    public boolean isActive() {
        return this.firstPos != null;
    }

    public static void spawnParticles(Level world, BlockPos pos, Direction direction, boolean fullBlock) {
        int i;
        Vec3 vec = Vec3.m_82528_((Vec3i)direction.m_122436_());
        Vec3 plane = VecHelper.axisAlingedPlaneOf((Vec3)vec);
        Vec3 facePos = VecHelper.getCenterOf((Vec3i)pos).m_82549_(vec.m_82490_(0.5));
        float distance = fullBlock ? 1.0f : 0.25f + 0.25f * (world.f_46441_.m_188501_() - 0.5f);
        plane = plane.m_82490_((double)distance);
        int n = i = fullBlock ? 40 : 15;
        while (i > 0) {
            Vec3 offset = VecHelper.rotate((Vec3)plane, (double)(360.0f * world.f_46441_.m_188501_()), (Direction.Axis)direction.m_122434_());
            Vec3 motion = offset.m_82541_().m_82490_(0.015625);
            if (fullBlock) {
                offset = new Vec3(Mth.m_14008_((double)offset.f_82479_, (double)-0.5, (double)0.5), Mth.m_14008_((double)offset.f_82480_, (double)-0.5, (double)0.5), Mth.m_14008_((double)offset.f_82481_, (double)-0.5, (double)0.5));
            }
            Vec3 particlePos = facePos.m_82549_(offset);
            world.m_7106_((ParticleOptions)ParticleTypes.f_123744_, particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, motion.f_82479_, motion.f_82480_, motion.f_82481_);
            --i;
        }
    }
}

