/*
 * Decompiled with CFR 0.152.
 */
package me.khajiitos.chestedcompanions.common.util;

import me.khajiitos.chestedcompanions.common.config.CCConfig;
import me.khajiitos.chestedcompanions.common.util.IChestEntity;
import me.khajiitos.chestedcompanions.common.util.InventoryCapacity;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public class ChestEntityCommon {
    public static <T extends TamableAnimal> void mobInteract(T chestEntity, Player player, InteractionHand interactionHand, CallbackInfoReturnable<InteractionResult> cir) {
        if (!chestEntity.m_9236_().f_46443_ && player.m_6047_() == ((Boolean)CCConfig.invertShiftToOpen.get()).booleanValue() && player.m_20148_().equals(chestEntity.m_21805_())) {
            ItemStack inHand;
            if (((IChestEntity)chestEntity).chestedCompanions$hasChest()) {
                ItemStack inHand2 = player.m_21120_(interactionHand);
                if (inHand2.m_150930_(Items.f_42574_)) {
                    inHand2.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(interactionHand));
                    ((IChestEntity)chestEntity).chestedCompanions$removeChestContent(!player.m_150110_().f_35937_);
                    chestEntity.m_5496_(SoundEvents.f_11811_, 1.0f, 1.5f);
                } else {
                    ((HasCustomInventoryScreen)chestEntity).m_213583_(player);
                }
                cir.setReturnValue((Object)InteractionResult.SUCCESS);
            } else if (((IChestEntity)chestEntity).chestedCompanions$allowChest() && (!chestEntity.m_6162_() || ((IChestEntity)chestEntity).chestedCompanions$allowChestOnBaby()) && ((IChestEntity)chestEntity).chestedCompanions$isValidChestItem(inHand = player.m_21120_(interactionHand))) {
                ((IChestEntity)chestEntity).chestedCompanions$setChestItemStack(inHand.m_255036_(1));
                if (!player.m_150110_().f_35937_) {
                    inHand.m_41774_(1);
                }
                chestEntity.m_5496_(SoundEvents.f_11811_, 1.0f, (chestEntity.m_217043_().m_188501_() - chestEntity.m_217043_().m_188501_()) * 0.2f + 1.0f);
                ((IChestEntity)chestEntity).chestedCompanions$createInventory();
                cir.setReturnValue((Object)InteractionResult.SUCCESS);
            }
        }
    }

    public static <T extends TamableAnimal> void addAdditionalSaveData(T chestEntity, CompoundTag compoundTag) {
        if (((IChestEntity)chestEntity).chestedCompanions$hasChest()) {
            ItemStack chestItemStack = ((IChestEntity)chestEntity).chestedCompanions$getChestItemStack();
            CompoundTag chestCompoundTag = new CompoundTag();
            chestItemStack.m_41739_(chestCompoundTag);
            compoundTag.m_128365_("ChestItem", (Tag)chestCompoundTag);
        }
        if (((IChestEntity)chestEntity).chestedCompanions$getInventory() != null) {
            compoundTag.m_128365_("CCItems", (Tag)((IChestEntity)chestEntity).chestedCompanions$getInventory().m_7927_());
        }
    }

    public static <T extends TamableAnimal> void readAdditionalSaveData(T chestEntity, CompoundTag compoundTag) {
        ItemStack chestItemStack;
        CompoundTag itemTag = compoundTag.m_128469_("ChestItem");
        if (itemTag.m_128425_("id", 8)) {
            ResourceLocation resourceLocation = new ResourceLocation(itemTag.m_128461_("id"));
            chestItemStack = !BuiltInRegistries.f_257033_.m_7804_(resourceLocation) ? new ItemStack((ItemLike)Items.f_42009_) : ItemStack.m_41712_((CompoundTag)itemTag);
        } else if (compoundTag.m_128471_("HasChest")) {
            chestItemStack = new ItemStack((ItemLike)Items.f_42009_);
        } else {
            return;
        }
        if (!chestItemStack.m_41619_()) {
            ((IChestEntity)chestEntity).chestedCompanions$setChestItemStack(chestItemStack);
            ((IChestEntity)chestEntity).chestedCompanions$createInventory();
            ((IChestEntity)chestEntity).chestedCompanions$getInventory().m_7797_(compoundTag.m_128437_("CCItems", 10));
        }
    }

    public static <T extends TamableAnimal> void removeChestContent(T chestEntity, boolean dropChest) {
        IChestEntity.PetChestContainer<?> inventory = ((IChestEntity)chestEntity).chestedCompanions$getInventory();
        if (inventory != null) {
            ItemStack chestItemStack;
            for (int i = 0; i < inventory.m_6643_(); ++i) {
                ItemStack itemStack = inventory.m_8020_(i);
                if (itemStack.m_41619_()) continue;
                chestEntity.m_5552_(itemStack, 0.25f);
            }
            if (dropChest && !(chestItemStack = ((IChestEntity)chestEntity).chestedCompanions$getChestItemStack()).m_41619_()) {
                chestEntity.m_5552_(chestItemStack, 0.25f);
            }
            ((IChestEntity)chestEntity).chestedCompanions$setChestItemStack(ItemStack.f_41583_);
            ((IChestEntity)chestEntity).chestedCompanions$removeInventory();
        }
    }

    public static <T extends TamableAnimal> AbstractContainerMenu createMenu(T chestEntity, int i, @NotNull Inventory inventory, @NotNull Player player) {
        InventoryCapacity inventoryCapacity = ((IChestEntity)chestEntity).chestedCompanions$getInventoryCapacity();
        if (((IChestEntity)chestEntity).chestedCompanions$getInventory() != null && ((IChestEntity)chestEntity).chestedCompanions$getInventory().m_6643_() != inventoryCapacity.containerRows * 9) {
            ((IChestEntity)chestEntity).chestedCompanions$createInventory();
        }
        return new ChestMenu(inventoryCapacity.menuType, i, inventory, ((IChestEntity)chestEntity).chestedCompanions$getInventory(), inventoryCapacity.containerRows);
    }
}

