/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.resource;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.tacz.guns.api.client.animation.gltf.AnimationStructure;
import com.tacz.guns.api.vmlib.LuaAnimationConstant;
import com.tacz.guns.api.vmlib.LuaGunAnimationConstant;
import com.tacz.guns.api.vmlib.LuaLibrary;
import com.tacz.guns.client.resource.ClientIndexManager;
import com.tacz.guns.client.resource.manager.DisplayManager;
import com.tacz.guns.client.resource.manager.GltfManager;
import com.tacz.guns.client.resource.manager.PackInfoManager;
import com.tacz.guns.client.resource.manager.SoundAssetsManager;
import com.tacz.guns.client.resource.pojo.CommonTransformObject;
import com.tacz.guns.client.resource.pojo.PackInfo;
import com.tacz.guns.client.resource.pojo.animation.bedrock.AnimationKeyframes;
import com.tacz.guns.client.resource.pojo.animation.bedrock.BedrockAnimationFile;
import com.tacz.guns.client.resource.pojo.animation.bedrock.SoundEffectKeyframes;
import com.tacz.guns.client.resource.pojo.display.ammo.AmmoDisplay;
import com.tacz.guns.client.resource.pojo.display.attachment.AttachmentDisplay;
import com.tacz.guns.client.resource.pojo.display.block.BlockDisplay;
import com.tacz.guns.client.resource.pojo.display.gun.GunDisplay;
import com.tacz.guns.client.resource.pojo.model.BedrockModelPOJO;
import com.tacz.guns.client.resource.pojo.model.CubesItem;
import com.tacz.guns.client.resource.serialize.AnimationKeyframesSerializer;
import com.tacz.guns.client.resource.serialize.ItemStackSerializer;
import com.tacz.guns.client.resource.serialize.SoundEffectKeyframesSerializer;
import com.tacz.guns.client.resource.serialize.Vector3fSerializer;
import com.tacz.guns.resource.CommonAssetsManager;
import com.tacz.guns.resource.manager.JsonDataManager;
import com.tacz.guns.resource.manager.ScriptManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.luaj.vm2.LuaTable;

@OnlyIn(value=Dist.CLIENT)
public enum ClientAssetsManager {
    INSTANCE;

    public static final Gson GSON;
    private JsonDataManager<GunDisplay> gunDisplay;
    private JsonDataManager<AmmoDisplay> ammoDisplay;
    private JsonDataManager<AttachmentDisplay> attachmentDisplay;
    private JsonDataManager<BlockDisplay> blockDisplay;
    private JsonDataManager<BedrockModelPOJO> bedrockModel;
    private JsonDataManager<BedrockAnimationFile> bedrockAnimation;
    private GltfManager gltfAnimation;
    private final List<LuaLibrary> libList = List.of(new LuaAnimationConstant(), new LuaGunAnimationConstant());
    private ScriptManager scriptManager;
    private SoundAssetsManager soundAssetsManager;
    private PackInfoManager packInfo;
    private List<PreparableReloadListener> listeners;

    public void reloadAndRegister(Consumer<PreparableReloadListener> register) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<PreparableReloadListener>();
            this.gunDisplay = this.register((PreparableReloadListener)new DisplayManager<GunDisplay>(GunDisplay.class, GSON, "display/guns", "GunDisplayLoader"));
            this.ammoDisplay = this.register((PreparableReloadListener)new DisplayManager<AmmoDisplay>(AmmoDisplay.class, GSON, "display/ammo", "AmmoDisplayLoader"));
            this.attachmentDisplay = this.register((PreparableReloadListener)new DisplayManager<AttachmentDisplay>(AttachmentDisplay.class, GSON, "display/attachments", "AttachmentDisplayLoader"));
            this.blockDisplay = this.register((PreparableReloadListener)new DisplayManager<BlockDisplay>(BlockDisplay.class, GSON, "display/blocks", "BlockDisplayLoader"));
            this.bedrockModel = this.register((PreparableReloadListener)new JsonDataManager<BedrockModelPOJO>(BedrockModelPOJO.class, GSON, "geo_models", "BedrockModelLoader"));
            this.bedrockAnimation = this.register((PreparableReloadListener)new JsonDataManager<BedrockAnimationFile>(BedrockAnimationFile.class, GSON, new FileToIdConverter("animations", ".animation.json"), "BedrockAnimationLoader"));
            this.gltfAnimation = this.register(new GltfManager());
            this.scriptManager = this.register(new ScriptManager(new FileToIdConverter("scripts", ".lua"), this.libList));
            this.soundAssetsManager = this.register(new SoundAssetsManager());
            this.packInfo = this.register(new PackInfoManager());
        }
        this.listeners.forEach(register);
    }

    private <T extends PreparableReloadListener> T register(T listener) {
        this.listeners.add(listener);
        return listener;
    }

    @Nullable
    public GunDisplay getGunDisplay(ResourceLocation id) {
        return this.gunDisplay.getData(id);
    }

    public Set<Map.Entry<ResourceLocation, GunDisplay>> getGunDisplays() {
        return this.gunDisplay.getAllData().entrySet();
    }

    @Nullable
    public AttachmentDisplay getAttachmentDisplay(ResourceLocation id) {
        return this.attachmentDisplay.getData(id);
    }

    @Nullable
    public AmmoDisplay getAmmoDisplay(ResourceLocation id) {
        return this.ammoDisplay.getData(id);
    }

    @Nullable
    public BlockDisplay getBlockDisplay(ResourceLocation id) {
        return this.blockDisplay.getData(id);
    }

    @Nullable
    public BedrockModelPOJO getBedrockModelPOJO(ResourceLocation id) {
        return this.bedrockModel.getData(id);
    }

    @Nullable
    public BedrockAnimationFile getBedrockAnimations(ResourceLocation id) {
        return this.bedrockAnimation.getData(id);
    }

    @Nullable
    public LuaTable getScript(ResourceLocation id) {
        return this.scriptManager.getScript(id);
    }

    @Nullable
    public AnimationStructure getGltfAnimation(ResourceLocation id) {
        return this.gltfAnimation.getGltfAnimation(id);
    }

    @Nullable
    public SoundAssetsManager.SoundData getSoundBuffers(ResourceLocation id) {
        return this.soundAssetsManager.getData(id);
    }

    @Nullable
    public PackInfo getPackInfo(String namespace) {
        return this.packInfo.getData(namespace);
    }

    @Nullable
    public PackInfo getPackInfo(@Nullable ResourceLocation namespace) {
        if (namespace == null) {
            return null;
        }
        return this.packInfo.getData(namespace.m_135827_());
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void reloadAllPack() {
        try {
            Minecraft.m_91087_().m_91391_().get();
            if (ServerLifecycleHooks.getCurrentServer() == null) {
                ClientIndexManager.reload();
            } else {
                CommonAssetsManager.reloadAllPack();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        GSON = new GsonBuilder().registerTypeAdapter(ResourceLocation.class, (Object)new ResourceLocation.Serializer()).registerTypeAdapter(CubesItem.class, (Object)new CubesItem.Deserializer()).registerTypeAdapter(Vector3f.class, (Object)new Vector3fSerializer()).registerTypeAdapter(CommonTransformObject.class, (Object)new CommonTransformObject.Serializer()).registerTypeAdapter(ItemStack.class, (Object)new ItemStackSerializer()).registerTypeAdapter(AnimationKeyframes.class, (Object)new AnimationKeyframesSerializer()).registerTypeAdapter(SoundEffectKeyframes.class, (Object)new SoundEffectKeyframesSerializer()).registerTypeAdapter(ItemTransforms.class, (Object)new ItemTransforms.Deserializer()).registerTypeAdapter(ItemTransform.class, (Object)new ItemTransform.Deserializer()).create();
    }
}

