/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.network.clientbound;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.block.block_entity.TerrestrialAgglomerationPlateBlockEntity;
import vazkii.botania.common.helper.ColorHelper;
import vazkii.botania.common.helper.VecHelper;
import vazkii.botania.common.item.GrassSeedsItem;
import vazkii.botania.common.item.WandOfTheForestItem;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.common.proxy.Proxy;
import vazkii.botania.network.BotaniaPacket;
import vazkii.botania.network.EffectType;

public record BotaniaEffectPacket(EffectType type, double x, double y, double z, int[] args) implements BotaniaPacket
{
    public static final ResourceLocation ID = ResourceLocationHelper.prefix("eff");
    private static final int MAX_VARIABLE_ARGS = 128;

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeByte(this.type().ordinal());
        buf.writeDouble(this.x());
        buf.writeDouble(this.y());
        buf.writeDouble(this.z());
        if (this.type().argCount != -1 && this.type().argCount != this.args().length) {
            throw new IllegalArgumentException("Argument count mismatch");
        }
        if (this.type().argCount == -1) {
            if (this.args().length > 128) {
                throw new IllegalArgumentException("Too many variable arguments");
            }
            buf.m_130130_(this.args().length);
        }
        for (int arg : this.args) {
            buf.m_130130_(arg);
        }
    }

    @Override
    public ResourceLocation getFabricId() {
        return ID;
    }

    public static BotaniaEffectPacket decode(FriendlyByteBuf buf) {
        int argCount;
        EffectType type = EffectType.values()[buf.readByte()];
        double x = buf.readDouble();
        double y = buf.readDouble();
        double z = buf.readDouble();
        if (type.argCount == -1) {
            argCount = buf.m_130242_();
            if (argCount > 128) {
                throw new IllegalArgumentException("Too many variable arguments");
            }
        } else {
            argCount = type.argCount;
        }
        int[] args = new int[argCount];
        for (int i = 0; i < args.length; ++i) {
            args[i] = buf.m_130242_();
        }
        return new BotaniaEffectPacket(type, x, y, z, args);
    }

    public static class Handler {
        public static void handle(BotaniaEffectPacket packet) {
            final EffectType type = packet.type();
            final double x = packet.x();
            final double y = packet.y();
            final double z = packet.z();
            final int[] args = packet.args();
            final Minecraft mc = Minecraft.m_91087_();
            mc.execute(new Runnable(){

                @Override
                public void run() {
                    ClientLevel world = mc.f_91073_;
                    switch (type) {
                        case PAINT_LENS: {
                            DyeColor placeColor = DyeColor.m_41053_((int)args[0]);
                            int hex = ColorHelper.getColorValue(placeColor);
                            int r = (hex & 0xFF0000) >> 16;
                            int g = (hex & 0xFF00) >> 8;
                            int b = hex & 0xFF;
                            for (int i = 0; i < 10; ++i) {
                                BlockPos pos = BlockPos.m_274561_((double)x, (double)y, (double)z).m_121945_(Direction.m_235672_((RandomSource)world.f_46441_));
                                SparkleParticleData data = SparkleParticleData.sparkle(0.6f + (float)Math.random() * 0.5f, (float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, 5);
                                world.m_7106_((ParticleOptions)data, (double)((float)pos.m_123341_() + (float)Math.random()), (double)((float)pos.m_123342_() + (float)Math.random()), (double)((float)pos.m_123343_() + (float)Math.random()), 0.0, 0.0, 0.0);
                            }
                            break;
                        }
                        case ARENA_INDICATOR: {
                            SparkleParticleData data = SparkleParticleData.sparkle(5.0f, 1.0f, 0.0f, 1.0f, 120);
                            for (int i = 0; i < 360; i += 8) {
                                float rad = (float)i * (float)Math.PI / 180.0f;
                                double wx = x + 0.5 - Math.cos(rad) * 12.0;
                                double wy = y + 0.5;
                                double wz = z + 0.5 - Math.sin(rad) * 12.0;
                                Proxy.INSTANCE.addParticleForceNear((Level)world, data, wx, wy, wz, 0.0, 0.0, 0.0);
                            }
                            break;
                        }
                        case ITEM_SMOKE: {
                            Entity item = world.m_6815_(args[0]);
                            if (item == null) {
                                return;
                            }
                            int p = args[1];
                            for (int i = 0; i < p; ++i) {
                                double m = 0.01;
                                double d0 = item.m_9236_().f_46441_.m_188583_() * m;
                                double d1 = item.m_9236_().f_46441_.m_188583_() * m;
                                double d2 = item.m_9236_().f_46441_.m_188583_() * m;
                                double d3 = 10.0;
                                item.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123759_, x + (double)(item.m_9236_().f_46441_.m_188501_() * item.m_20205_() * 2.0f) - (double)item.m_20205_() - d0 * d3, y + (double)(item.m_9236_().f_46441_.m_188501_() * item.m_20206_()) - d1 * d3, z + (double)(item.m_9236_().f_46441_.m_188501_() * item.m_20205_() * 2.0f) - (double)item.m_20205_() - d2 * d3, d0, d1, d2);
                            }
                            break;
                        }
                        case SPARK_NET_INDICATOR: {
                            Entity e1 = world.m_6815_(args[0]);
                            Entity e2 = world.m_6815_(args[1]);
                            if (e1 == null || e2 == null) {
                                return;
                            }
                            Vec3 orig = new Vec3(e1.m_20185_(), e1.m_20186_() + 0.25, e1.m_20189_());
                            Vec3 end = new Vec3(e2.m_20185_(), e2.m_20186_() + 0.25, e2.m_20189_());
                            Vec3 diff = end.m_82546_(orig);
                            Vec3 movement = diff.m_82541_().m_82490_(0.1);
                            int iters = (int)(diff.m_82553_() / movement.m_82553_());
                            float huePer = 1.0f / (float)iters;
                            float hueSum = (float)Math.random();
                            Vec3 currentPos = orig;
                            for (int i = 0; i < iters; ++i) {
                                float hue = (float)i * huePer + hueSum;
                                int color = Mth.m_14169_((float)Mth.m_14187_((float)hue), (float)1.0f, (float)1.0f);
                                float r = Math.min(1.0f, (float)(color >> 16 & 0xFF) / 255.0f + 0.4f);
                                float g = Math.min(1.0f, (float)(color >> 8 & 0xFF) / 255.0f + 0.4f);
                                float b = Math.min(1.0f, (float)(color & 0xFF) / 255.0f + 0.4f);
                                SparkleParticleData data = SparkleParticleData.noClip(1.0f, r, g, b, 12);
                                world.m_6485_((ParticleOptions)data, true, currentPos.f_82479_, currentPos.f_82480_, currentPos.f_82481_, 0.0, 0.0, 0.0);
                                currentPos = currentPos.m_82549_(movement);
                            }
                            break;
                        }
                        case SPARK_MANA_FLOW: {
                            Entity e1 = world.m_6815_(args[0]);
                            Entity e2 = world.m_6815_(args[1]);
                            if (e1 == null || e2 == null) {
                                return;
                            }
                            double rc = 0.45;
                            Vec3 thisVec = VecHelper.fromEntityCenter(e1).m_82520_((Math.random() - 0.5) * rc, (Math.random() - 0.5) * rc, (Math.random() - 0.5) * rc);
                            Vec3 receiverVec = VecHelper.fromEntityCenter(e2).m_82520_((Math.random() - 0.5) * rc, (Math.random() - 0.5) * rc, (Math.random() - 0.5) * rc);
                            Vec3 motion = receiverVec.m_82546_(thisVec).m_82490_((double)0.04f);
                            int color = args[2];
                            float r = (float)(color >> 16 & 0xFF) / 255.0f;
                            float g = (float)(color >> 8 & 0xFF) / 255.0f;
                            float b = (float)(color & 0xFF) / 255.0f;
                            if ((double)world.f_46441_.m_188501_() < 0.25) {
                                r += 0.2f * (float)world.f_46441_.m_188583_();
                                g += 0.2f * (float)world.f_46441_.m_188583_();
                                b += 0.2f * (float)world.f_46441_.m_188583_();
                            }
                            float size = 0.125f + 0.125f * (float)Math.random();
                            WispParticleData data = WispParticleData.wisp(size, r, g, b).withNoClip(true);
                            world.m_7107_((ParticleOptions)data, thisVec.f_82479_, thisVec.f_82480_, thisVec.f_82481_, motion.f_82479_, motion.f_82480_, motion.f_82481_);
                            break;
                        }
                        case ENCHANTER_DESTROY: {
                            for (int i = 0; i < 50; ++i) {
                                float red = (float)Math.random();
                                float green = (float)Math.random();
                                float blue = (float)Math.random();
                                WispParticleData data = WispParticleData.wisp((float)Math.random() * 0.15f + 0.15f, red, green, blue);
                                world.m_7106_((ParticleOptions)data, x, y, z, (double)((float)(Math.random() - 0.5) * 0.25f), (double)((float)(Math.random() - 0.5) * 0.25f), (double)((float)(Math.random() - 0.5) * 0.25f));
                            }
                            break;
                        }
                        case BLACK_LOTUS_DISSOLVE: {
                            for (int i = 0; i < 50; ++i) {
                                float r = (float)Math.random() * 0.35f;
                                float g = 0.0f;
                                float b = (float)Math.random() * 0.35f;
                                float s = 0.45f * (float)Math.random() * 0.25f;
                                float m = 0.045f;
                                float mx = ((float)Math.random() - 0.5f) * m;
                                float my = (float)Math.random() * m;
                                float mz = ((float)Math.random() - 0.5f) * m;
                                WispParticleData data = WispParticleData.wisp(s, r, g, b);
                                world.m_7106_((ParticleOptions)data, x, y, z, (double)mx, (double)my, (double)mz);
                            }
                            break;
                        }
                        case TERRA_PLATE: {
                            BlockEntity te = world.m_7702_(BlockPos.m_274561_((double)x, (double)y, (double)z));
                            if (!(te instanceof TerrestrialAgglomerationPlateBlockEntity)) break;
                            float percentage = Float.intBitsToFloat(args[0]);
                            int ticks = (int)(100.0 * (double)percentage);
                            int totalSpiritCount = 3;
                            double tickIncrement = 360.0 / (double)totalSpiritCount;
                            int speed = 5;
                            double wticks = (double)(ticks * speed) - tickIncrement;
                            double r = Math.sin((double)(ticks - 100) / 10.0) * 2.0;
                            double g = Math.sin(wticks * Math.PI / 180.0 * 0.55);
                            for (int i = 0; i < totalSpiritCount; ++i) {
                                double wx = x + Math.sin(wticks * Math.PI / 180.0) * r + 0.5;
                                double wy = y + 0.25 + Math.abs(r) * 0.7;
                                double wz = z + Math.cos(wticks * Math.PI / 180.0) * r + 0.5;
                                wticks += tickIncrement;
                                float[] colorsfx = new float[]{0.0f, (float)ticks / 100.0f, 1.0f - (float)ticks / 100.0f};
                                WispParticleData data = WispParticleData.wisp(0.85f, colorsfx[0], colorsfx[1], colorsfx[2], 0.25f);
                                Proxy.INSTANCE.addParticleForceNear((Level)world, data, wx, wy, wz, 0.0, (float)(-g * 0.05), 0.0);
                                data = WispParticleData.wisp((float)Math.random() * 0.1f + 0.1f, colorsfx[0], colorsfx[1], colorsfx[2], 0.9f);
                                world.m_7106_((ParticleOptions)data, wx, wy, wz, (double)((float)(Math.random() - 0.5) * 0.05f), (double)((float)(Math.random() - 0.5) * 0.05f), (double)((float)(Math.random() - 0.5) * 0.05f));
                                if (ticks != 100) continue;
                                for (int j = 0; j < 15; ++j) {
                                    data = WispParticleData.wisp((float)Math.random() * 0.15f + 0.15f, colorsfx[0], colorsfx[1], colorsfx[2]);
                                    world.m_7106_((ParticleOptions)data, x + 0.5, y + 0.5, z + 0.5, (double)((float)(Math.random() - 0.5) * 0.125f), (double)((float)(Math.random() - 0.5) * 0.125f), (double)((float)(Math.random() - 0.5) * 0.125f));
                                }
                            }
                            break;
                        }
                        case FLUGEL_EFFECT: {
                            Entity entity = world.m_6815_(args[0]);
                            if (entity == null) break;
                            for (int i = 0; i < 15; ++i) {
                                float x1 = (float)(entity.m_20185_() + Math.random());
                                float y1 = (float)(entity.m_20186_() + Math.random());
                                float z1 = (float)(entity.m_20189_() + Math.random());
                                WispParticleData data = WispParticleData.wisp((float)Math.random(), (float)Math.random(), (float)Math.random(), (float)Math.random(), 1.0f);
                                world.m_7106_((ParticleOptions)data, (double)x1, (double)y1, (double)z1, 0.0, (double)(-(-0.3f + (float)Math.random() * 0.2f)), 0.0);
                            }
                            break;
                        }
                        case PARTICLE_BEAM: {
                            WandOfTheForestItem.doParticleBeam((Level)world, new Vec3(x, y, z), new Vec3((double)args[0] + 0.5, (double)args[1] + 0.5, (double)args[2] + 0.5));
                            break;
                        }
                        case DIVA_EFFECT: {
                            Entity target = world.m_6815_(args[0]);
                            if (target == null) break;
                            double x1 = target.m_20185_();
                            double y1 = target.m_20186_();
                            double z1 = target.m_20189_();
                            SparkleParticleData data = SparkleParticleData.sparkle(1.0f, 1.0f, 1.0f, 0.25f, 3);
                            for (int i = 0; i < 50; ++i) {
                                world.m_7106_((ParticleOptions)data, x1 + Math.random() * (double)target.m_20205_(), y1 + Math.random() * (double)target.m_20206_(), z1 + Math.random() * (double)target.m_20205_(), 0.0, 0.0, 0.0);
                            }
                            break;
                        }
                        case HALO_CRAFT: {
                            Entity target = world.m_6815_(args[0]);
                            if (target == null) break;
                            Vec3 lookVec3 = target.m_20154_();
                            Vec3 centerVector = VecHelper.fromEntityCenter(target).m_82520_(lookVec3.f_82479_ * 3.0, 1.3, lookVec3.f_82481_ * 3.0);
                            float m = 0.1f;
                            for (int i = 0; i < 4; ++i) {
                                WispParticleData data = WispParticleData.wisp(0.2f + 0.2f * (float)Math.random(), 1.0f, 0.0f, 1.0f);
                                target.m_9236_().m_7106_((ParticleOptions)data, centerVector.f_82479_, centerVector.f_82480_, centerVector.f_82481_, (double)(((float)Math.random() - 0.5f) * m), (double)(((float)Math.random() - 0.5f) * m), (double)(((float)Math.random() - 0.5f) * m));
                            }
                            break;
                        }
                        case AVATAR_TORNADO_JUMP: {
                            Entity p = world.m_6815_(args[0]);
                            if (p == null) break;
                            for (int i = 0; i < 20; ++i) {
                                for (int j = 0; j < 5; ++j) {
                                    WispParticleData data = WispParticleData.wisp(0.35f + (float)Math.random() * 0.1f, 0.25f, 0.25f, 0.25f);
                                    world.m_7106_((ParticleOptions)data, p.m_20185_(), p.m_20186_() + (double)i, p.m_20189_(), (double)(0.2f * (float)(Math.random() - 0.5)), (double)(-0.01f * (float)Math.random()), (double)(0.2f * (float)(Math.random() - 0.5)));
                                }
                            }
                            break;
                        }
                        case AVATAR_TORNADO_BOOST: {
                            Entity p = world.m_6815_(args[0]);
                            if (p == null) break;
                            Vec3 lookDir = p.m_20154_();
                            for (int i = 0; i < 20; ++i) {
                                for (int j = 0; j < 5; ++j) {
                                    WispParticleData data = WispParticleData.wisp(0.35f + (float)Math.random() * 0.1f, 0.25f, 0.25f, 0.25f);
                                    world.m_7106_((ParticleOptions)data, p.m_20185_() + lookDir.m_7096_() * (double)i, p.m_20186_() + lookDir.m_7098_() * (double)i, p.m_20189_() + lookDir.m_7094_() * (double)i, (double)(0.2f * (float)(Math.random() - 0.5)) * (Math.abs(lookDir.m_7098_()) + Math.abs(lookDir.m_7094_())) + (double)(-0.01f * (float)Math.random()) * lookDir.m_7096_(), (double)(0.2f * (float)(Math.random() - 0.5)) * (Math.abs(lookDir.m_7096_()) + Math.abs(lookDir.m_7094_())) + (double)(-0.01f * (float)Math.random()) * lookDir.m_7098_(), (double)(0.2f * (float)(Math.random() - 0.5)) * (Math.abs(lookDir.m_7098_()) + Math.abs(lookDir.m_7096_())) + (double)(-0.01f * (float)Math.random()) * lookDir.m_7094_());
                                }
                            }
                            break;
                        }
                        case THUNDERCALLER_EFFECT: {
                            int id;
                            Entity entity;
                            Vec3 source = new Vec3(x, y, z);
                            int[] nArray = args;
                            int n = nArray.length;
                            for (int i = 0; i < n && (entity = world.m_6815_(id = nArray[i])) != null; ++i) {
                                Vec3 entityPos = VecHelper.fromEntityCenter(entity);
                                Proxy.INSTANCE.lightningFX((Level)world, source, entityPos, 1.0f, 96708, 0xAADFFF);
                                source = entityPos;
                            }
                            break;
                        }
                        case GRASS_SEED_PARTICLES: {
                            int color = args[0];
                            GrassSeedsItem.spawnParticles((Level)world, BlockPos.m_274561_((double)x, (double)y, (double)z), GrassSeedsItem.extractR(color), GrassSeedsItem.extractG(color), GrassSeedsItem.extractB(color));
                        }
                    }
                }
            });
        }
    }
}

