/*
 * Decompiled with CFR 0.152.
 */
package com.github.nyuppo.mixin;

import com.github.nyuppo.MoreMobVariants;
import com.github.nyuppo.config.Variants;
import com.github.nyuppo.variant.MobVariant;
import net.minecraft.client.renderer.entity.WolfRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Wolf;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={WolfRenderer.class})
public class WolfRendererMixin {
    private static final ResourceLocation DEFAULT_WILD = new ResourceLocation("textures/entity/wolf/wolf.png");
    private static final ResourceLocation DEFAULT_TAMED = new ResourceLocation("textures/entity/wolf/wolf_tame.png");
    private static final ResourceLocation DEFAULT_ANGRY = new ResourceLocation("textures/entity/wolf/wolf_angry.png");

    @Inject(method={"getTextureLocation(Lnet/minecraft/world/entity/animal/Wolf;)Lnet/minecraft/resources/ResourceLocation;"}, at={@At(value="HEAD")}, cancellable=true)
    private void onGetTextureLocation(Wolf wolfEntity, CallbackInfoReturnable<ResourceLocation> ci) {
        Object variant;
        CompoundTag nbt = new CompoundTag();
        wolfEntity.m_20240_(nbt);
        if (nbt.m_128441_("VariantID")) {
            variant = nbt.m_128461_("VariantID");
            if (((String)variant).equals(MoreMobVariants.id("default").toString()) || ((String)variant).isEmpty()) {
                if (wolfEntity.m_21824_()) {
                    ci.setReturnValue((Object)DEFAULT_TAMED);
                } else {
                    ci.setReturnValue((Object)(wolfEntity.m_21660_() ? DEFAULT_ANGRY : DEFAULT_WILD));
                }
            } else {
                String[] split = Variants.splitVariant((String)variant);
                if (wolfEntity.m_21824_()) {
                    ci.setReturnValue((Object)new ResourceLocation(split[0], "textures/entity/wolf/" + split[1] + "_tame.png"));
                } else {
                    ci.setReturnValue((Object)(wolfEntity.m_21660_() ? new ResourceLocation(split[0], "textures/entity/wolf/" + split[1] + "_angry.png") : new ResourceLocation(split[0], "textures/entity/wolf/" + split[1] + "_wild.png")));
                }
            }
        }
        if (wolfEntity.m_8077_() && (variant = Variants.getVariantFromNametag(EntityType.f_20499_, wolfEntity.m_7755_().getString())) != null) {
            ResourceLocation identifier = ((MobVariant)variant).getIdentifier();
            if (wolfEntity.m_21824_()) {
                ci.setReturnValue((Object)new ResourceLocation(identifier.m_135827_(), "textures/entity/wolf/" + identifier.m_135815_() + "_tame.png"));
            } else {
                ci.setReturnValue((Object)(wolfEntity.m_21660_() ? new ResourceLocation(identifier.m_135827_(), "textures/entity/wolf/" + identifier.m_135815_() + "_angry.png") : new ResourceLocation(identifier.m_135827_(), "textures/entity/wolf/" + identifier.m_135815_() + "_wild.png")));
            }
        }
    }
}

