/*
 * Decompiled with CFR 0.152.
 */
package li.cil.manual.client;

import dev.architectury.registry.registries.DeferredRegister;
import li.cil.manual.api.ManualModel;
import li.cil.manual.api.ManualScreenStyle;
import li.cil.manual.api.ManualStyle;
import li.cil.manual.api.Tab;
import li.cil.manual.api.provider.DocumentProvider;
import li.cil.manual.api.provider.PathProvider;
import li.cil.manual.api.provider.RendererProvider;
import li.cil.manual.api.util.Constants;
import li.cil.manual.api.util.ShowManualScreenEvent;
import li.cil.manual.client.gui.ManualScreen;
import li.cil.manual.client.provider.BlockRendererProvider;
import li.cil.manual.client.provider.ItemRendererProvider;
import li.cil.manual.client.provider.TagRendererProvider;
import li.cil.manual.client.provider.TextureRendererProvider;
import li.cil.manual.client.util.RegistryUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;

public final class ClientSetup {
    public static void initialize() {
        RegistryUtils.begin("markdown_manual");
        RegistryUtils.builder(Constants.TAB_REGISTRY, new Tab[0]).build();
        RegistryUtils.builder(Constants.PATH_PROVIDER_REGISTRY, new PathProvider[0]).build();
        RegistryUtils.builder(Constants.DOCUMENT_PROVIDER_REGISTRY, new DocumentProvider[0]).build();
        RegistryUtils.builder(Constants.RENDERER_PROVIDER_REGISTRY, new RendererProvider[0]).build();
        RegistryUtils.builder(Constants.MANUAL_REGISTRY, new ManualModel[0]).build();
        DeferredRegister<RendererProvider> rendererProviders = RegistryUtils.get(Constants.RENDERER_PROVIDER_REGISTRY);
        rendererProviders.register("texture", TextureRendererProvider::new);
        rendererProviders.register("item", ItemRendererProvider::new);
        rendererProviders.register("block", BlockRendererProvider::new);
        rendererProviders.register("tag", TagRendererProvider::new);
        RegistryUtils.finish();
        ShowManualScreenEvent.SHOW_MANUAL_SCREEN_EVENT.register(ClientSetup::handleShowManualScreen);
    }

    private static void handleShowManualScreen(ShowManualScreenEvent event) {
        ManualModel model = event.getManualModel();
        ManualStyle manualStyle = event.getManualStyle().orElse(ManualStyle.DEFAULT);
        ManualScreenStyle screenStyle = event.getScreenStyle().orElse(ManualScreenStyle.DEFAULT);
        ManualScreen screen = new ManualScreen(model, manualStyle, screenStyle);
        Minecraft.m_91087_().m_91152_((Screen)screen);
    }
}

