/*
 * Decompiled with CFR 0.152.
 */
package net.jacobwasbeast.picaxe.blocks.entities;

import java.util.EnumMap;
import java.util.Map;
import net.jacobwasbeast.picaxe.ModBlockEntities;
import net.jacobwasbeast.picaxe.ModItems;
import net.jacobwasbeast.picaxe.blocks.SixSidedImageBlock;
import net.jacobwasbeast.picaxe.items.SixSidedImageBlockItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class SixSidedImageBlockEntity
extends BlockEntity {
    private final Map<Direction, String> imageUrls = new EnumMap<Direction, String>(Direction.class);

    public SixSidedImageBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.SIX_SIDED_IMAGE_BLOCK_ENTITY.get(), pos, state);
        for (Direction dir : Direction.values()) {
            this.imageUrls.put(dir, "");
        }
    }

    public String getImageUrl(Direction direction) {
        return this.imageUrls.getOrDefault(direction, "");
    }

    public void setImageUrl(Direction direction, String url) {
        this.imageUrls.put(direction, url);
        this.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128359_("id", "picaxe:four_sided_image_block");
        for (Direction dir : Direction.values()) {
            if (this.imageUrls.containsKey(dir)) {
                tag.m_128359_("image_url_" + dir.m_122433_(), this.imageUrls.get(dir));
                continue;
            }
            tag.m_128359_("image_url_" + dir.m_122433_(), "");
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        for (Direction dir : Direction.values()) {
            if (tag.m_128441_("image_url_" + dir.m_122433_())) {
                this.imageUrls.put(dir, tag.m_128461_("image_url_" + dir.m_122433_()));
                continue;
            }
            this.imageUrls.put(dir, "");
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void loadFromItemStack(ItemStack stack) {
        CompoundTag tag = stack.m_41737_("BlockEntityTag");
        if (tag != null) {
            this.m_142466_(tag);
        } else {
            for (Direction dir : Direction.values()) {
                this.imageUrls.put(dir, "");
            }
        }
    }

    public static boolean isLitFromStack(ItemStack stack) {
        CompoundTag customData = stack.m_41737_("BlockEntityTag");
        if (customData != null) {
            return customData.m_128471_("lit");
        }
        return false;
    }

    public static SixSidedImageBlockEntity fromItemStack(ItemStack stack) {
        BlockState blockState = ((SixSidedImageBlockItem)((Object)ModItems.SIX_SIDED_IMAGE_BLOCK_ITEM.get())).m_40614_().m_49966_();
        boolean isLit = SixSidedImageBlockEntity.isLitFromStack(stack);
        blockState = (BlockState)blockState.m_61124_((Property)SixSidedImageBlock.LIT, (Comparable)Boolean.valueOf(isLit));
        SixSidedImageBlockEntity entity = new SixSidedImageBlockEntity(BlockPos.f_121853_, blockState);
        entity.loadFromItemStackComponents(stack);
        return entity;
    }

    public void loadFromItemStackComponents(ItemStack stack) {
        CompoundTag customData = stack.m_41737_("BlockEntityTag");
        if (customData != null) {
            this.m_142466_(customData);
        } else {
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                this.imageUrls.put(dir, "");
            }
            for (Direction dir : Direction.Plane.VERTICAL) {
                this.imageUrls.put(dir, "");
            }
        }
    }

    public ItemStack createItemStack() {
        ItemStack itemStack = new ItemStack((ItemLike)ModItems.SIX_SIDED_IMAGE_BLOCK_ITEM.get());
        CompoundTag blockEntityTag = this.m_187482_();
        blockEntityTag.m_128379_("lit", ((Boolean)this.m_58900_().m_61143_((Property)SixSidedImageBlock.LIT)).booleanValue());
        itemStack.m_41784_().m_128365_("BlockEntityTag", (Tag)blockEntityTag);
        return itemStack;
    }

    public Map<Direction, String> getImages() {
        return this.imageUrls;
    }

    public boolean isLit() {
        return (Boolean)this.m_58900_().m_61143_((Property)SixSidedImageBlock.LIT);
    }
}

