/*
 * Decompiled with CFR 0.152.
 */
package net.jacobwasbeast.picaxe.blocks.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.jacobwasbeast.picaxe.blocks.SixSidedImageBlock;
import net.jacobwasbeast.picaxe.blocks.entities.SixSidedImageBlockEntity;
import net.jacobwasbeast.picaxe.utils.ImageUtils;
import net.jacobwasbeast.picaxe.utils.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.Property;

public class SixSidedImageBlockRenderer
implements BlockEntityRenderer<SixSidedImageBlockEntity> {
    public SixSidedImageBlockRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(SixSidedImageBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        int faceLight;
        String imageUrl;
        Level level = blockEntity.m_58904_();
        if (level == null) {
            SixSidedImageBlockEntity newSix = new SixSidedImageBlockEntity(Minecraft.m_91087_().f_91074_.m_20097_().m_122030_(64), blockEntity.m_58900_());
            blockEntity.getImages().forEach((direction, s) -> newSix.setImageUrl((Direction)direction, (String)s));
            blockEntity = newSix;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        Direction rotation = (Direction)blockEntity.m_58900_().m_61143_((Property)SixSidedImageBlock.f_54117_);
        poseStack.m_85837_(0.5, 0.5, 0.5);
        switch (rotation) {
            case SOUTH: {
                poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                break;
            }
            case WEST: {
                poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
                break;
            }
            case EAST: {
                poseStack.m_252781_(Axis.f_252436_.m_252977_(-90.0f));
                break;
            }
        }
        poseStack.m_85837_(-0.5, -0.5, -0.5);
        float seemingOffset = RenderUtils.getSeamOffset((Player)player, blockEntity.m_58899_());
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            imageUrl = blockEntity.getImageUrl(dir);
            if (imageUrl == null || imageUrl.isBlank()) continue;
            poseStack.m_85836_();
            faceLight = level == null ? packedLight : LevelRenderer.m_109541_((BlockAndTintGetter)level, (BlockPos)blockEntity.m_58899_().m_121945_(dir));
            poseStack.m_85837_(0.5, 0.5, 0.5);
            switch (rotation) {
                case SOUTH: {
                    poseStack.m_252781_(Axis.f_252436_.m_252977_(-180.0f));
                    break;
                }
                case WEST: {
                    poseStack.m_252781_(Axis.f_252436_.m_252977_(-90.0f));
                    break;
                }
                case EAST: {
                    poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
                    break;
                }
            }
            poseStack.m_85837_(-0.5, -0.5, -0.5);
            poseStack.m_252781_(dir.m_253075_());
            poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
            switch (dir) {
                case NORTH: {
                    poseStack.m_252880_(0.0f, -1.0f - seemingOffset, 0.0f);
                    break;
                }
                case SOUTH: {
                    poseStack.m_252880_(-1.0f, -seemingOffset, 0.0f);
                    break;
                }
                case EAST: {
                    poseStack.m_252880_(0.0f, -seemingOffset, 0.0f);
                    break;
                }
                case WEST: {
                    poseStack.m_252880_(-1.0f, -1.0f - seemingOffset, 0.0f);
                    break;
                }
            }
            ImageUtils.renderImageFromURL(poseStack, bufferSource, faceLight, packedOverlay, partialTick, 1.0f, 1.0f, imageUrl, false, false, false);
            poseStack.m_85849_();
        }
        for (Direction dir : Direction.Plane.VERTICAL) {
            imageUrl = blockEntity.getImageUrl(dir);
            if (imageUrl == null || imageUrl.isBlank()) continue;
            poseStack.m_85836_();
            faceLight = level == null ? packedLight : LevelRenderer.m_109541_((BlockAndTintGetter)level, (BlockPos)blockEntity.m_58899_().m_121945_(dir));
            poseStack.m_85837_(0.5, 0.5, 0.5);
            if (dir == Direction.DOWN) {
                poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                poseStack.m_252781_(Axis.f_252529_.m_252977_(-180.0f));
            }
            poseStack.m_85837_(0.0, 0.0, 0.501);
            poseStack.m_252880_(0.0f, -seemingOffset, 0.0f);
            poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
            poseStack.m_85837_(-0.5, -0.5, 0.0);
            ImageUtils.renderImageFromURL(poseStack, bufferSource, faceLight, packedOverlay, partialTick, 1.0f, 1.0f, imageUrl, false, false, false);
            poseStack.m_85849_();
        }
    }

    private Direction localToWorld(Direction facing, Direction local) {
        if (local.m_122434_() == Direction.Axis.Y) {
            return local;
        }
        return switch (facing) {
            case Direction.NORTH -> local;
            case Direction.SOUTH -> local.m_122424_();
            case Direction.WEST -> local.m_122428_();
            case Direction.EAST -> local.m_122427_();
            default -> local;
        };
    }
}

