/*
 * Decompiled with CFR 0.152.
 */
package net.jacobwasbeast.picaxe.network;

import dev.architectury.networking.NetworkManager;
import net.jacobwasbeast.picaxe.blocks.entities.ImageFrameBlockEntity;
import net.jacobwasbeast.picaxe.items.PicAxeItem;
import net.jacobwasbeast.picaxe.network.UpdateImageFramePayload;
import net.jacobwasbeast.picaxe.network.UpdatePicAxeUrlPayload;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class PacketHandler {
    public static void register() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.c2s(), (ResourceLocation)UpdatePicAxeUrlPayload.TYPE, PacketHandler::handleUpdateUrl);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.c2s(), (ResourceLocation)UpdateImageFramePayload.TYPE, PacketHandler::handleUpdateImageFrame);
    }

    private static void handleUpdateImageFrame(FriendlyByteBuf friendlyByteBuf, NetworkManager.PacketContext packetContext) {
        UpdateImageFramePayload payload = new UpdateImageFramePayload(friendlyByteBuf);
        PacketHandler.handleUpdateImageFrame(payload, packetContext);
    }

    private static void handleUpdateUrl(FriendlyByteBuf friendlyByteBuf, NetworkManager.PacketContext packetContext) {
        UpdatePicAxeUrlPayload payload = UpdatePicAxeUrlPayload.read(friendlyByteBuf);
        PacketHandler.handleUpdateUrl(payload, packetContext);
    }

    private static void handleUpdateUrl(UpdatePicAxeUrlPayload payload, NetworkManager.PacketContext context) {
        ServerPlayer player = (ServerPlayer)context.getPlayer();
        context.queue(() -> {
            ItemStack stack;
            if (player != null && (stack = player.m_21120_(payload.hand)).m_41720_() instanceof PicAxeItem) {
                PicAxeItem.setURL(stack, payload.url);
            }
        });
    }

    private static void handleUpdateImageFrame(UpdateImageFramePayload payload, NetworkManager.PacketContext context) {
        ServerPlayer player = (ServerPlayer)context.getPlayer();
        context.queue(() -> {
            BlockEntity be;
            Level level;
            if (player != null && (level = player.m_9236_()).m_46749_(payload.pos) && (be = level.m_7702_(payload.pos)) instanceof ImageFrameBlockEntity) {
                ImageFrameBlockEntity frameEntity = (ImageFrameBlockEntity)be;
                frameEntity.setConfiguration(payload.url, payload.width, payload.height, payload.stretch, payload.alignment, payload.offsetX, payload.offsetY, payload.offsetZ);
            }
        });
    }
}

