/*
 * Decompiled with CFR 0.152.
 */
package net.jacobwasbeast.picaxe.utils;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.RasterFormatException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageInputStream;
import net.jacobwasbeast.picaxe.api.ImageFrameAlignment;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.w3c.dom.NodeList;

public class ImageUtils {
    private static final Minecraft mc = Minecraft.m_91087_();
    private static final int MAX_LOAD_TRIES = 3;
    private static final HttpClient httpClient = HttpClient.newBuilder().version(HttpClient.Version.HTTP_2).followRedirects(HttpClient.Redirect.NORMAL).connectTimeout(Duration.ofSeconds(10L)).build();
    private static final ExecutorService executor = Executors.newFixedThreadPool(Math.max(2, Runtime.getRuntime().availableProcessors()));
    private static final Set<String> blacklist = Collections.newSetFromMap(new ConcurrentHashMap());
    private static final Set<String> loading = Collections.newSetFromMap(new ConcurrentHashMap());
    private static final Map<String, SoftReference<byte[]>> rawDataCache = new ConcurrentHashMap<String, SoftReference<byte[]>>();
    private static final Map<String, ResourceLocation> cachedTextures = new ConcurrentHashMap<String, ResourceLocation>();
    private static final Map<String, AnimatedTexture> cachedAnimatedTextures = new ConcurrentHashMap<String, AnimatedTexture>();
    private static final Map<String, ResourceLocation> cachedSideTopper = new ConcurrentHashMap<String, ResourceLocation>();
    private static final Map<String, AnimatedTexture> cachedAnimatedSideTopper = new ConcurrentHashMap<String, AnimatedTexture>();
    private static final Map<String, ResourceLocation> cachedSideDrapeLeft = new ConcurrentHashMap<String, ResourceLocation>();
    private static final Map<String, AnimatedTexture> cachedAnimatedSideDrapeLeft = new ConcurrentHashMap<String, AnimatedTexture>();
    private static final Map<String, ResourceLocation> cachedSideDrapeRight = new ConcurrentHashMap<String, ResourceLocation>();
    private static final Map<String, AnimatedTexture> cachedAnimatedSideDrapeRight = new ConcurrentHashMap<String, AnimatedTexture>();
    private static final Set<String> pendingSideTransforms = Collections.newSetFromMap(new ConcurrentHashMap());
    private static final Map<String, ResourceLocation> cachedFrontBackTopper = new ConcurrentHashMap<String, ResourceLocation>();
    private static final Map<String, AnimatedTexture> cachedAnimatedFrontBackTopper = new ConcurrentHashMap<String, AnimatedTexture>();
    private static final Map<String, ResourceLocation> cachedFrontDrape = new ConcurrentHashMap<String, ResourceLocation>();
    private static final Map<String, AnimatedTexture> cachedAnimatedFrontDrape = new ConcurrentHashMap<String, AnimatedTexture>();
    private static final Map<String, ResourceLocation> cachedBackDrape = new ConcurrentHashMap<String, ResourceLocation>();
    private static final Map<String, AnimatedTexture> cachedAnimatedBackDrape = new ConcurrentHashMap<String, AnimatedTexture>();
    private static final Set<String> pendingFrontBackTransforms = Collections.newSetFromMap(new ConcurrentHashMap());
    private static final Map<String, ResourceLocation> cachedSingleFrontDrape = new ConcurrentHashMap<String, ResourceLocation>();
    private static final Map<String, AnimatedTexture> cachedAnimatedSingleFrontDrape = new ConcurrentHashMap<String, AnimatedTexture>();
    private static final Map<String, ResourceLocation> cachedSingleTopper = new ConcurrentHashMap<String, ResourceLocation>();
    private static final Map<String, AnimatedTexture> cachedAnimatedSingleTopper = new ConcurrentHashMap<String, AnimatedTexture>();
    private static final Set<String> pendingSingleFrontTransforms = Collections.newSetFromMap(new ConcurrentHashMap());
    private static final ResourceLocation NOT_FOUND_TEXTURE;
    private static final ResourceLocation LOADING_TEXTURE;

    private static BufferedImage loadBufferedImageFromResource(String namespace, String path) {
        try {
            ResourceLocation imageLoc = ResourceLocation.m_214293_((String)namespace, (String)path);
            InputStream in = ((Resource)mc.m_91098_().m_213713_(imageLoc).get()).m_215507_();
            return ImageIO.read(in);
        }
        catch (IOException e) {
            System.err.println("CRITICAL: Failed to load resource image: " + namespace + ":" + path + " - " + e.getMessage());
            return new BufferedImage(16, 16, 2);
        }
    }

    private static String sanitize(String key) {
        return key.toLowerCase().replaceAll("[^a-z0-9._-]", "_");
    }

    private static NativeImage toNativeImage(BufferedImage img) {
        if (img == null) {
            return null;
        }
        int width = img.getWidth();
        int height = img.getHeight();
        BufferedImage convertedImg = img;
        if (img.getType() != 3) {
            convertedImg = new BufferedImage(width, height, 3);
            convertedImg.getGraphics().drawImage(img, 0, 0, null);
        }
        int[] argbPixels = ((DataBufferInt)convertedImg.getRaster().getDataBuffer()).getData();
        NativeImage ni = new NativeImage(width, height, false);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int argb = argbPixels[y * width + (width - 1 - x)];
                int a = argb >> 24 & 0xFF;
                int r = argb >> 16 & 0xFF;
                int g = argb >> 8 & 0xFF;
                int b = argb & 0xFF;
                int abgr = a << 24 | b << 16 | g << 8 | r;
                ni.m_84988_(x, y, abgr);
            }
        }
        return ni;
    }

    public static ResourceLocation registerTextureFromImage(String key, BufferedImage img, boolean shouldCache) {
        if (img == null) {
            System.err.println("Attempted to register a null image for key: " + key);
            return NOT_FOUND_TEXTURE;
        }
        if (shouldCache && cachedTextures.containsKey(key)) {
            return cachedTextures.get(key);
        }
        try {
            NativeImage ni = ImageUtils.toNativeImage(img);
            if (ni == null) {
                return NOT_FOUND_TEXTURE;
            }
            DynamicTexture dyn = new DynamicTexture(ni);
            ResourceLocation loc = mc.m_91097_().m_118490_("dynamic/" + ImageUtils.sanitize(key), dyn);
            if (shouldCache) {
                cachedTextures.put(key, loc);
            }
            return loc;
        }
        catch (Exception e) {
            System.err.println("Failed to register texture for key: " + key + " \u2013 " + e.getMessage());
            return NOT_FOUND_TEXTURE;
        }
    }

    private static void processUrl(String url) {
        HttpRequest request;
        try {
            request = HttpRequest.newBuilder().uri(URI.create(url)).header("User-Agent", "Mozilla/5.0 (Windows; U; Windows NT 10.0; WOW64) AppleWebKit/537.50 (KHTML, like Gecko) Chrome/49.0.1164.162 Safari/536").timeout(Duration.ofSeconds(20L)).build();
        }
        catch (IllegalArgumentException e) {
            System.err.println("Invalid URL, adding to blacklist: " + url);
            blacklist.add(url);
            return;
        }
        for (int i = 1; i <= 3; ++i) {
            try {
                HttpResponse<byte[]> response = httpClient.send(request, HttpResponse.BodyHandlers.ofByteArray());
                if (response.statusCode() >= 200 && response.statusCode() < 300) {
                    byte[] imageBytes = response.body();
                    rawDataCache.put(url, new SoftReference<byte[]>(imageBytes));
                    if (ImageUtils.isGif(imageBytes)) {
                        ImageUtils.loadAnimatedGif(url, imageBytes);
                    } else {
                        try (ByteArrayInputStream is = new ByteArrayInputStream(imageBytes);){
                            BufferedImage image = ImageIO.read(is);
                            if (image == null) {
                                throw new IOException("ImageIO.read returned null. Unsupported format or corrupt data.");
                            }
                            mc.execute(() -> ImageUtils.registerTextureFromImage(url, image, true));
                        }
                    }
                    return;
                }
                throw new IOException("HTTP request failed with status code: " + response.statusCode());
            }
            catch (Exception e) {
                System.err.println("Attempt " + i + "/3 failed to load " + url + ": " + e.getMessage());
                if (!(e instanceof InterruptedException)) continue;
                Thread.currentThread().interrupt();
                System.err.println("Image loading interrupted for " + url);
                break;
            }
        }
        System.err.println("Gave up loading image, adding to blacklist: " + url);
        blacklist.add(url);
    }

    private static void loadAnimatedGif(String url, byte[] data) throws IOException {
        int[] delayMillis;
        ArrayList<NativeImage> nativeFrames = new ArrayList<NativeImage>();
        int totalDuration = 0;
        try (ImageInputStream stream = ImageIO.createImageInputStream(new ByteArrayInputStream(data));){
            Iterator<ImageReader> readers = ImageIO.getImageReaders(stream);
            if (!readers.hasNext()) {
                throw new IOException("No GIF ImageReader found");
            }
            ImageReader reader = readers.next();
            reader.setInput(stream);
            int numFrames = reader.getNumImages(true);
            delayMillis = new int[numFrames];
            BufferedImage canvas = null;
            Graphics g = null;
            for (int i = 0; i < numFrames; ++i) {
                BufferedImage frameImage = reader.read(i);
                if (canvas == null) {
                    canvas = new BufferedImage(reader.getWidth(0), reader.getHeight(0), 2);
                    g = canvas.createGraphics();
                    ((Graphics2D)g).setBackground(new Color(0, 0, 0, 0));
                }
                IIOMetadata metadata = reader.getImageMetadata(i);
                IIOMetadataNode root = (IIOMetadataNode)metadata.getAsTree(metadata.getNativeMetadataFormatName());
                NodeList gces = root.getElementsByTagName("GraphicControlExtension");
                int delay = 10;
                String disposal = "none";
                if (gces.getLength() > 0) {
                    IIOMetadataNode gce = (IIOMetadataNode)gces.item(0);
                    delay = Integer.parseInt(gce.getAttribute("delayTime"));
                    disposal = gce.getAttribute("disposalMethod");
                }
                delayMillis[i] = delay * 10 > 0 ? delay * 10 : 100;
                totalDuration += delayMillis[i];
                IIOMetadataNode imageDescriptor = (IIOMetadataNode)root.getElementsByTagName("ImageDescriptor").item(0);
                int x = Integer.parseInt(imageDescriptor.getAttribute("imageLeftPosition"));
                int y = Integer.parseInt(imageDescriptor.getAttribute("imageTopPosition"));
                g.drawImage(frameImage, x, y, null);
                BufferedImage finalFrame = new BufferedImage(canvas.getWidth(), canvas.getHeight(), 2);
                finalFrame.createGraphics().drawImage((Image)canvas, 0, 0, null);
                nativeFrames.add(ImageUtils.toNativeImage(finalFrame));
                if (!disposal.equals("restoreToBackgroundColor")) continue;
                g.clearRect(x, y, frameImage.getWidth(), frameImage.getHeight());
            }
            if (g != null) {
                g.dispose();
            }
        }
        int[] finalDelays = delayMillis;
        int finalTotalDuration = totalDuration;
        mc.execute(() -> {
            ResourceLocation[] frameLocations = new ResourceLocation[nativeFrames.size()];
            for (int j = 0; j < nativeFrames.size(); ++j) {
                NativeImage ni = (NativeImage)nativeFrames.get(j);
                if (ni != null) {
                    DynamicTexture dyn = new DynamicTexture(ni);
                    frameLocations[j] = mc.m_91097_().m_118490_("dynamic/" + ImageUtils.sanitize(url + "_frame_" + j), dyn);
                    continue;
                }
                frameLocations[j] = NOT_FOUND_TEXTURE;
            }
            nativeFrames.clear();
            cachedAnimatedTextures.put(url, new AnimatedTexture(frameLocations, finalDelays, finalTotalDuration));
        });
    }

    private static boolean isGif(byte[] bytes) {
        if (bytes == null || bytes.length < 3) {
            return false;
        }
        return bytes[0] == 71 && bytes[1] == 73 && bytes[2] == 70;
    }

    public static ResourceLocation getOrLoadTexture(String url) {
        if (url == null || url.isEmpty()) {
            return NOT_FOUND_TEXTURE;
        }
        if (cachedAnimatedTextures.containsKey(url)) {
            return cachedAnimatedTextures.get(url).getCurrentFrame();
        }
        if (cachedTextures.containsKey(url)) {
            return cachedTextures.get(url);
        }
        if (blacklist.contains(url)) {
            return NOT_FOUND_TEXTURE;
        }
        if (loading.contains(url)) {
            return LOADING_TEXTURE;
        }
        loading.add(url);
        executor.submit(() -> {
            try {
                ImageUtils.processUrl(url);
            }
            finally {
                loading.remove(url);
            }
        });
        return LOADING_TEXTURE;
    }

    private static byte[] getRawDataFromCache(String url) {
        SoftReference<byte[]> ref = rawDataCache.get(url);
        return ref != null ? ref.get() : null;
    }

    public static void renderImageFromURL(PoseStack ps, MultiBufferSource bufSrc, int packedLight, int packedOverlay, float partialTick, float width, float height, String url) {
        ImageUtils.renderImageFromURL(ps, bufSrc, packedLight, packedOverlay, partialTick, width, height, url, false);
    }

    public static void renderImageFromURL(PoseStack ps, MultiBufferSource bufSrc, int packedLight, int packedOverlay, float partialTick, float width, float height, String url, boolean keepAspectRatio) {
        ResourceLocation tex = ImageUtils.getOrLoadTexture(url);
        if (tex == null) {
            tex = NOT_FOUND_TEXTURE;
        }
        int uL = packedLight & 0xFFFF;
        int vL = packedLight >> 16 & 0xFFFF;
        int uO = packedOverlay & 0xFFFF;
        int vO = packedOverlay >> 16 & 0xFFFF;
        ps.m_85836_();
        ps.m_85837_(0.5, 1.01, 0.5);
        ps.m_252781_(Axis.f_252529_.m_252977_(90.0f));
        PoseStack.Pose p = ps.m_85850_();
        VertexConsumer buf = bufSrc.m_6299_(RenderType.m_110497_((ResourceLocation)tex));
        float hw = width / 2.0f;
        float hh = height / 2.0f;
        if (keepAspectRatio) {
            float aspectRatio = width / height;
            if (aspectRatio > 1.0f) {
                hh /= aspectRatio;
            } else {
                hw *= aspectRatio;
            }
        }
        Matrix4f matrix = p.m_252922_();
        Vector3f nUp = new Vector3f(0.0f, 1.0f, 0.0f);
        matrix.transformDirection(nUp);
        Vector3f nDown = new Vector3f(0.0f, -1.0f, 0.0f);
        matrix.transformDirection(nDown);
        buf.m_252986_(matrix, -hw, -hh, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 1.0f).m_7122_(uO, vO).m_7120_(uL, vL).m_5601_(nUp.x(), nUp.y(), nUp.z()).m_5752_();
        buf.m_252986_(matrix, hw, -hh, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 1.0f).m_7122_(uO, vO).m_7120_(uL, vL).m_5601_(nUp.x(), nUp.y(), nUp.z()).m_5752_();
        buf.m_252986_(matrix, hw, hh, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 0.0f).m_7122_(uO, vO).m_7120_(uL, vL).m_5601_(nUp.x(), nUp.y(), nUp.z()).m_5752_();
        buf.m_252986_(matrix, -hw, hh, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 0.0f).m_7122_(uO, vO).m_7120_(uL, vL).m_5601_(nUp.x(), nUp.y(), nUp.z()).m_5752_();
        buf.m_252986_(matrix, -hw, hh, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 0.0f).m_7122_(uO, vO).m_7120_(uL, vL).m_5601_(nDown.x(), nDown.y(), nDown.z()).m_5752_();
        buf.m_252986_(matrix, hw, hh, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 0.0f).m_7122_(uO, vO).m_7120_(uL, vL).m_5601_(nDown.x(), nDown.y(), nDown.z()).m_5752_();
        buf.m_252986_(matrix, hw, -hh, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 1.0f).m_7122_(uO, vO).m_7120_(uL, vL).m_5601_(nDown.x(), nDown.y(), nDown.z()).m_5752_();
        buf.m_252986_(matrix, -hw, -hh, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 1.0f).m_7122_(uO, vO).m_7120_(uL, vL).m_5601_(nDown.x(), nDown.y(), nDown.z()).m_5752_();
        ps.m_85849_();
    }

    public static void renderImageFromURL(PoseStack ps, MultiBufferSource bufSrc, int packedLight, int packedOverlay, float partialTick, float width, float height, String url, boolean keepAspectRatio, ImageFrameAlignment alignment, int offsetX, int offsetY, int offsetZ) {
        ResourceLocation tex = ImageUtils.getOrLoadTexture(url);
        if (tex == null) {
            tex = NOT_FOUND_TEXTURE;
        }
        int uL = packedLight & 0xFFFF;
        int vL = packedLight >> 16 & 0xFFFF;
        int uO = packedOverlay & 0xFFFF;
        int vO = packedOverlay >> 16 & 0xFFFF;
        ps.m_85836_();
        ps.m_85837_(0.5, 1.01, 0.5);
        ps.m_252781_(Axis.f_252529_.m_252977_(90.0f));
        PoseStack.Pose p = ps.m_85850_();
        VertexConsumer buf = bufSrc.m_6299_(RenderType.m_110497_((ResourceLocation)tex));
        float hw = width / 2.0f;
        float hh = height / 2.0f;
        if (keepAspectRatio) {
            float aspectRatio = width / height;
            if (aspectRatio > 1.0f) {
                hh /= aspectRatio;
            } else {
                hw *= aspectRatio;
            }
        }
        Matrix4f matrix = p.m_252922_();
        Vector3f nUp = new Vector3f(0.0f, 1.0f, 0.0f);
        matrix.transformDirection(nUp);
        Vector3f nDown = new Vector3f(0.0f, -1.0f, 0.0f);
        matrix.transformDirection(nDown);
        buf.m_252986_(matrix, -hw, -hh, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 1.0f).m_7122_(uO, vO).m_7120_(uL, vL).m_5601_(nUp.x(), nUp.y(), nUp.z()).m_5752_();
        buf.m_252986_(matrix, hw, -hh, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 1.0f).m_7122_(uO, vO).m_7120_(uL, vL).m_5601_(nUp.x(), nUp.y(), nUp.z()).m_5752_();
        buf.m_252986_(matrix, hw, hh, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 0.0f).m_7122_(uO, vO).m_7120_(uL, vL).m_5601_(nUp.x(), nUp.y(), nUp.z()).m_5752_();
        buf.m_252986_(matrix, -hw, hh, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 0.0f).m_7122_(uO, vO).m_7120_(uL, vL).m_5601_(nUp.x(), nUp.y(), nUp.z()).m_5752_();
        buf.m_252986_(matrix, -hw, hh, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 0.0f).m_7122_(uO, vO).m_7120_(uL, vL).m_5601_(nDown.x(), nDown.y(), nDown.z()).m_5752_();
        buf.m_252986_(matrix, hw, hh, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 0.0f).m_7122_(uO, vO).m_7120_(uL, vL).m_5601_(nDown.x(), nDown.y(), nDown.z()).m_5752_();
        buf.m_252986_(matrix, hw, -hh, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 1.0f).m_7122_(uO, vO).m_7120_(uL, vL).m_5601_(nDown.x(), nDown.y(), nDown.z()).m_5752_();
        buf.m_252986_(matrix, -hw, -hh, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 1.0f).m_7122_(uO, vO).m_7120_(uL, vL).m_5601_(nDown.x(), nDown.y(), nDown.z()).m_5752_();
        ps.m_85849_();
    }

    public static void renderImageFromURL(PoseStack ps, MultiBufferSource bufSrc, int packedLight, int packedOverlay, float partialTick, float width, float height, String url, boolean keepAspectRatio, boolean flipX, boolean flipY) {
        ResourceLocation tex = ImageUtils.getOrLoadTexture(url);
        if (tex == null) {
            tex = NOT_FOUND_TEXTURE;
        }
        float u0 = flipX ? 1.0f : 0.0f;
        float u1 = flipX ? 0.0f : 1.0f;
        float v0 = flipY ? 1.0f : 0.0f;
        float v1 = flipY ? 0.0f : 1.0f;
        int uL = packedLight & 0xFFFF;
        int vL = packedLight >> 16 & 0xFFFF;
        int uO = packedOverlay & 0xFFFF;
        int vO = packedOverlay >> 16 & 0xFFFF;
        ps.m_85836_();
        ps.m_85837_(0.5, 1.01, 0.5);
        ps.m_252781_(Axis.f_252529_.m_252977_(90.0f));
        PoseStack.Pose p = ps.m_85850_();
        VertexConsumer buf = bufSrc.m_6299_(RenderType.m_110497_((ResourceLocation)tex));
        float hw = width / 2.0f;
        float hh = height / 2.0f;
        if (keepAspectRatio) {
            float aspectRatio = width / height;
            if (aspectRatio > 1.0f) {
                hh /= aspectRatio;
            } else {
                hw *= aspectRatio;
            }
        }
        Matrix4f matrix = p.m_252922_();
        Vector3f nUp = new Vector3f(0.0f, 1.0f, 0.0f);
        matrix.transformDirection(nUp);
        Vector3f nDown = new Vector3f(0.0f, -1.0f, 0.0f);
        matrix.transformDirection(nDown);
        buf.m_252986_(matrix, -hw, -hh, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 1.0f).m_7122_(uO, vO).m_7120_(uL, vL).m_5601_(nUp.x(), nUp.y(), nUp.z()).m_5752_();
        buf.m_252986_(matrix, hw, -hh, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 1.0f).m_7122_(uO, vO).m_7120_(uL, vL).m_5601_(nUp.x(), nUp.y(), nUp.z()).m_5752_();
        buf.m_252986_(matrix, hw, hh, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 0.0f).m_7122_(uO, vO).m_7120_(uL, vL).m_5601_(nUp.x(), nUp.y(), nUp.z()).m_5752_();
        buf.m_252986_(matrix, -hw, hh, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 0.0f).m_7122_(uO, vO).m_7120_(uL, vL).m_5601_(nUp.x(), nUp.y(), nUp.z()).m_5752_();
        buf.m_252986_(matrix, -hw, hh, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 0.0f).m_7122_(uO, vO).m_7120_(uL, vL).m_5601_(nDown.x(), nDown.y(), nDown.z()).m_5752_();
        buf.m_252986_(matrix, hw, hh, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 0.0f).m_7122_(uO, vO).m_7120_(uL, vL).m_5601_(nDown.x(), nDown.y(), nDown.z()).m_5752_();
        buf.m_252986_(matrix, hw, -hh, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 1.0f).m_7122_(uO, vO).m_7120_(uL, vL).m_5601_(nDown.x(), nDown.y(), nDown.z()).m_5752_();
        buf.m_252986_(matrix, -hw, -hh, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 1.0f).m_7122_(uO, vO).m_7120_(uL, vL).m_5601_(nDown.x(), nDown.y(), nDown.z()).m_5752_();
        ps.m_85849_();
    }

    public static void renderImageSideDrapesFromURL(PoseStack ps, MultiBufferSource bufSrc, int packedLight, int packedOverlay, float partialTick, float bedWidth, float bedLength, float drapeDepth, String url) {
        ResourceLocation rightDrapeTex;
        ResourceLocation leftDrapeTex;
        ResourceLocation topperTex;
        String key = url + "_split_sides_" + bedWidth + "_" + drapeDepth;
        if (cachedAnimatedSideTopper.containsKey(key)) {
            topperTex = cachedAnimatedSideTopper.get(key).getCurrentFrame();
            leftDrapeTex = cachedAnimatedSideDrapeLeft.get(key).getCurrentFrame();
            rightDrapeTex = cachedAnimatedSideDrapeRight.get(key).getCurrentFrame();
        } else if (cachedSideTopper.containsKey(key)) {
            topperTex = cachedSideTopper.get(key);
            leftDrapeTex = cachedSideDrapeLeft.get(key);
            rightDrapeTex = cachedSideDrapeRight.get(key);
        } else if (pendingSideTransforms.contains(key)) {
            leftDrapeTex = rightDrapeTex = LOADING_TEXTURE;
            topperTex = rightDrapeTex;
        } else {
            leftDrapeTex = rightDrapeTex = ImageUtils.getOrLoadTexture(url);
            topperTex = rightDrapeTex;
            byte[] data = ImageUtils.getRawDataFromCache(url);
            if (data != null) {
                pendingSideTransforms.add(key);
                leftDrapeTex = rightDrapeTex = LOADING_TEXTURE;
                topperTex = rightDrapeTex;
                executor.submit(() -> {
                    block22: {
                        try {
                            int leftW;
                            if (ImageUtils.isGif(data)) {
                                int totalDuration;
                                int[] delays;
                                ArrayList<NativeImage> nativeToppers = new ArrayList<NativeImage>();
                                ArrayList<NativeImage> nativeLefts = new ArrayList<NativeImage>();
                                ArrayList<NativeImage> nativeRights = new ArrayList<NativeImage>();
                                try (ImageInputStream stream = ImageIO.createImageInputStream(new ByteArrayInputStream(data));){
                                    Iterator<ImageReader> readers = ImageIO.getImageReaders(stream);
                                    if (!readers.hasNext()) {
                                        throw new IOException("No GIF reader");
                                    }
                                    ImageReader reader = readers.next();
                                    reader.setInput(stream);
                                    int numFrames = reader.getNumImages(true);
                                    delays = new int[numFrames];
                                    int duration = 0;
                                    BufferedImage canvas = null;
                                    Graphics g = null;
                                    for (int i = 0; i < numFrames; ++i) {
                                        BufferedImage frameImage = reader.read(i);
                                        if (canvas == null) {
                                            canvas = new BufferedImage(reader.getWidth(0), reader.getHeight(0), 2);
                                            g = canvas.createGraphics();
                                        }
                                        IIOMetadata metadata = reader.getImageMetadata(i);
                                        IIOMetadataNode root = (IIOMetadataNode)metadata.getAsTree(metadata.getNativeMetadataFormatName());
                                        IIOMetadataNode gce = (IIOMetadataNode)root.getElementsByTagName("GraphicControlExtension").item(0);
                                        delays[i] = Integer.parseInt(gce.getAttribute("delayTime")) * 10;
                                        if (delays[i] <= 0) {
                                            delays[i] = 100;
                                        }
                                        duration += delays[i];
                                        String disposal = gce.getAttribute("disposalMethod");
                                        IIOMetadataNode desc = (IIOMetadataNode)root.getElementsByTagName("ImageDescriptor").item(0);
                                        int x = Integer.parseInt(desc.getAttribute("imageLeftPosition"));
                                        int y = Integer.parseInt(desc.getAttribute("imageTopPosition"));
                                        g.drawImage(frameImage, x, y, null);
                                        BufferedImage currentFrameToSplit = new BufferedImage(canvas.getWidth(), canvas.getHeight(), 2);
                                        currentFrameToSplit.createGraphics().drawImage((Image)canvas, 0, 0, null);
                                        int W = currentFrameToSplit.getWidth();
                                        int H = currentFrameToSplit.getHeight();
                                        float totalWidthBlocks = bedWidth + 2.0f * drapeDepth;
                                        if (totalWidthBlocks <= 0.0f) continue;
                                        int leftW2 = Math.round(drapeDepth / totalWidthBlocks * (float)W);
                                        int midW = W - 2 * leftW2;
                                        if (leftW2 <= 0 || midW <= 0 || leftW2 + midW > W) continue;
                                        nativeRights.add(ImageUtils.toNativeImage(currentFrameToSplit.getSubimage(0, 0, leftW2, H)));
                                        nativeToppers.add(ImageUtils.toNativeImage(currentFrameToSplit.getSubimage(leftW2, 0, midW, H)));
                                        nativeLefts.add(ImageUtils.toNativeImage(currentFrameToSplit.getSubimage(leftW2 + midW, 0, leftW2, H)));
                                        if (!disposal.equals("restoreToBackgroundColor")) continue;
                                        g.clearRect(x, y, frameImage.getWidth(), frameImage.getHeight());
                                    }
                                    totalDuration = duration;
                                    if (g != null) {
                                        g.dispose();
                                    }
                                }
                                mc.execute(() -> {
                                    AtomicInteger index = new AtomicInteger(0);
                                    ResourceLocation[] topperLocs = (ResourceLocation[])nativeToppers.stream().map(ni -> mc.m_91097_().m_118490_("dynamic/" + ImageUtils.sanitize(key + "_topper_" + index.getAndIncrement()), new DynamicTexture(ni))).toArray(ResourceLocation[]::new);
                                    index.set(0);
                                    ResourceLocation[] leftLocs = (ResourceLocation[])nativeLefts.stream().map(ni -> mc.m_91097_().m_118490_("dynamic/" + ImageUtils.sanitize(key + "_left_" + index.getAndIncrement()), new DynamicTexture(ni))).toArray(ResourceLocation[]::new);
                                    index.set(0);
                                    ResourceLocation[] rightLocs = (ResourceLocation[])nativeRights.stream().map(ni -> mc.m_91097_().m_118490_("dynamic/" + ImageUtils.sanitize(key + "_right_" + index.getAndIncrement()), new DynamicTexture(ni))).toArray(ResourceLocation[]::new);
                                    cachedAnimatedSideTopper.put(key, new AnimatedTexture(topperLocs, delays, totalDuration));
                                    cachedAnimatedSideDrapeLeft.put(key, new AnimatedTexture(leftLocs, delays, totalDuration));
                                    cachedAnimatedSideDrapeRight.put(key, new AnimatedTexture(rightLocs, delays, totalDuration));
                                    nativeToppers.clear();
                                    nativeLefts.clear();
                                    nativeRights.clear();
                                });
                                break block22;
                            }
                            BufferedImage full = ImageIO.read(new ByteArrayInputStream(data));
                            int W = full.getWidth();
                            int H = full.getHeight();
                            float totalWidthBlocks = bedWidth + 2.0f * drapeDepth;
                            if (totalWidthBlocks <= 0.0f) {
                                return;
                            }
                            int rightW = leftW = Math.round(drapeDepth / totalWidthBlocks * (float)W);
                            int midW = W - leftW - rightW;
                            if (leftW <= 0 || rightW <= 0 || midW <= 0 || leftW + midW > W) {
                                return;
                            }
                            BufferedImage intendedRightDrapeImg = full.getSubimage(0, 0, leftW, H);
                            BufferedImage midImg = full.getSubimage(leftW, 0, midW, H);
                            BufferedImage intendedLeftDrapeImg = full.getSubimage(leftW + midW, 0, rightW, H);
                            mc.execute(() -> {
                                cachedSideDrapeLeft.put(key, ImageUtils.registerTextureFromImage(key + "_drape_left", intendedLeftDrapeImg, true));
                                cachedSideTopper.put(key, ImageUtils.registerTextureFromImage(key + "_topper", midImg, true));
                                cachedSideDrapeRight.put(key, ImageUtils.registerTextureFromImage(key + "_drape_right", intendedRightDrapeImg, true));
                            });
                        }
                        catch (RasterFormatException | IOException e) {
                            System.err.println("Error splitting texture " + key + ": " + e.getMessage());
                            blacklist.add(url);
                        }
                        finally {
                            pendingSideTransforms.remove(key);
                        }
                    }
                });
            }
        }
        int uL = packedLight & 0xFFFF;
        int vL = packedLight >> 16 & 0xFFFF;
        int uO = packedOverlay & 0xFFFF;
        int vO = packedOverlay >> 16 & 0xFFFF;
        ps.m_85836_();
        ps.m_252880_(0.0f, 1.02f, 0.0f);
        ps.m_252781_(Axis.f_252529_.m_252977_(90.0f));
        PoseStack.Pose p = ps.m_85850_();
        VertexConsumer buf = bufSrc.m_6299_(RenderType.m_110497_((ResourceLocation)topperTex));
        float hw = bedWidth / 2.0f;
        float hl = bedLength / 2.0f;
        hw += 0.01f;
        Matrix4f matrix = p.m_252922_();
        Vector3f nUp = new Vector3f(0.0f, 1.0f, 0.0f);
        matrix.transformDirection(nUp);
        Vector3f nDown = new Vector3f(0.0f, -1.0f, 0.0f);
        matrix.transformDirection(nDown);
        buf.m_252986_(matrix, -hw, -hl, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 1.0f).m_7122_(uO, vO).m_7120_(uL, vL).m_5601_(nUp.x(), nUp.y(), nUp.z()).m_5752_();
        buf.m_252986_(matrix, hw, -hl, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 1.0f).m_7122_(uO, vO).m_7120_(uL, vL).m_5601_(nUp.x(), nUp.y(), nUp.z()).m_5752_();
        buf.m_252986_(matrix, hw, hl, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 0.0f).m_7122_(uO, vO).m_7120_(uL, vL).m_5601_(nUp.x(), nUp.y(), nUp.z()).m_5752_();
        buf.m_252986_(matrix, -hw, hl, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 0.0f).m_7122_(uO, vO).m_7120_(uL, vL).m_5601_(nUp.x(), nUp.y(), nUp.z()).m_5752_();
        buf.m_252986_(matrix, -hw, hl, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 0.0f).m_7122_(uO, vO).m_7120_(uL, vL).m_5601_(nDown.x(), nDown.y(), nDown.z()).m_5752_();
        buf.m_252986_(matrix, hw, hl, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 0.0f).m_7122_(uO, vO).m_7120_(uL, vL).m_5601_(nDown.x(), nDown.y(), nDown.z()).m_5752_();
        buf.m_252986_(matrix, hw, -hl, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 1.0f).m_7122_(uO, vO).m_7120_(uL, vL).m_5601_(nDown.x(), nDown.y(), nDown.z()).m_5752_();
        buf.m_252986_(matrix, -hw, -hl, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 1.0f).m_7122_(uO, vO).m_7120_(uL, vL).m_5601_(nDown.x(), nDown.y(), nDown.z()).m_5752_();
        ps.m_85849_();
        ps.m_85836_();
        ps.m_252880_(-bedWidth / 2.0f - 0.01f, 0.72f, 0.0f);
        ps.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        ps.m_252781_(Axis.f_252495_.m_252977_(-180.0f));
        p = ps.m_85850_();
        buf = bufSrc.m_6299_(RenderType.m_110497_((ResourceLocation)leftDrapeTex));
        float hl2 = bedLength / 2.0f;
        float d = drapeDepth;
        matrix = p.m_252922_();
        Vector3f fn = new Vector3f(0.0f, 0.0f, 1.0f);
        matrix.transformDirection(fn);
        Vector3f bn = new Vector3f(0.0f, 0.0f, -1.0f);
        matrix.transformDirection(bn);
        buf.m_252986_(matrix, -hl2, -d, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 0.0f).m_7122_(uO, vO).m_7120_(uL, vL).m_5601_(fn.x(), fn.y(), fn.z()).m_5752_();
        buf.m_252986_(matrix, hl2, -d, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 1.0f).m_7122_(uO, vO).m_7120_(uL, vL).m_5601_(fn.x(), fn.y(), fn.z()).m_5752_();
        buf.m_252986_(matrix, hl2, 0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 1.0f).m_7122_(uO, vO).m_7120_(uL, vL).m_5601_(fn.x(), fn.y(), fn.z()).m_5752_();
        buf.m_252986_(matrix, -hl2, 0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 0.0f).m_7122_(uO, vO).m_7120_(uL, vL).m_5601_(fn.x(), fn.y(), fn.z()).m_5752_();
        buf.m_252986_(matrix, -hl2, 0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 0.0f).m_7122_(uO, vO).m_7120_(uL, vL).m_5601_(bn.x(), bn.y(), bn.z()).m_5752_();
        buf.m_252986_(matrix, hl2, 0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 1.0f).m_7122_(uO, vO).m_7120_(uL, vL).m_5601_(bn.x(), bn.y(), bn.z()).m_5752_();
        buf.m_252986_(matrix, hl2, -d, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 1.0f).m_7122_(uO, vO).m_7120_(uL, vL).m_5601_(bn.x(), bn.y(), bn.z()).m_5752_();
        buf.m_252986_(matrix, -hl2, -d, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 0.0f).m_7122_(uO, vO).m_7120_(uL, vL).m_5601_(bn.x(), bn.y(), bn.z()).m_5752_();
        ps.m_85849_();
        ps.m_85836_();
        ps.m_252880_(bedWidth / 2.0f + 0.01f, 1.02f, 0.0f);
        ps.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        p = ps.m_85850_();
        buf = bufSrc.m_6299_(RenderType.m_110497_((ResourceLocation)rightDrapeTex));
        hl2 = bedLength / 2.0f;
        d = drapeDepth;
        matrix = p.m_252922_();
        fn = new Vector3f(0.0f, 0.0f, 1.0f);
        matrix.transformDirection(fn);
        bn = new Vector3f(0.0f, 0.0f, -1.0f);
        matrix.transformDirection(bn);
        buf.m_252986_(matrix, -hl2, -d, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 0.0f).m_7122_(uO, vO).m_7120_(uL, vL).m_5601_(fn.x(), fn.y(), fn.z()).m_5752_();
        buf.m_252986_(matrix, hl2, -d, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 1.0f).m_7122_(uO, vO).m_7120_(uL, vL).m_5601_(fn.x(), fn.y(), fn.z()).m_5752_();
        buf.m_252986_(matrix, hl2, 0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 1.0f).m_7122_(uO, vO).m_7120_(uL, vL).m_5601_(fn.x(), fn.y(), fn.z()).m_5752_();
        buf.m_252986_(matrix, -hl2, 0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 0.0f).m_7122_(uO, vO).m_7120_(uL, vL).m_5601_(fn.x(), fn.y(), fn.z()).m_5752_();
        buf.m_252986_(matrix, -hl2, 0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 0.0f).m_7122_(uO, vO).m_7120_(uL, vL).m_5601_(bn.x(), bn.y(), bn.z()).m_5752_();
        buf.m_252986_(matrix, hl2, 0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 1.0f).m_7122_(uO, vO).m_7120_(uL, vL).m_5601_(bn.x(), bn.y(), bn.z()).m_5752_();
        buf.m_252986_(matrix, hl2, -d, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 1.0f).m_7122_(uO, vO).m_7120_(uL, vL).m_5601_(bn.x(), bn.y(), bn.z()).m_5752_();
        buf.m_252986_(matrix, -hl2, -d, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 0.0f).m_7122_(uO, vO).m_7120_(uL, vL).m_5601_(bn.x(), bn.y(), bn.z()).m_5752_();
        ps.m_85849_();
    }

    public static void renderImageFrontBackDrapesFromURL(PoseStack ps, MultiBufferSource bufSrc, int packedLight, int packedOverlay, float partialTick, float bedWidth, float bedLength, float drapeDepth, String url) {
        ResourceLocation backDrapeTex;
        ResourceLocation frontDrapeTex;
        ResourceLocation topperTex;
        String key = url + "_split_frontback_" + bedLength + "_" + drapeDepth;
        if (cachedAnimatedFrontBackTopper.containsKey(key)) {
            topperTex = cachedAnimatedFrontBackTopper.get(key).getCurrentFrame();
            frontDrapeTex = cachedAnimatedFrontDrape.get(key).getCurrentFrame();
            backDrapeTex = cachedAnimatedBackDrape.get(key).getCurrentFrame();
        } else if (cachedFrontBackTopper.containsKey(key)) {
            topperTex = cachedFrontBackTopper.get(key);
            frontDrapeTex = cachedFrontDrape.get(key);
            backDrapeTex = cachedBackDrape.get(key);
        } else if (pendingFrontBackTransforms.contains(key)) {
            frontDrapeTex = backDrapeTex = LOADING_TEXTURE;
            topperTex = backDrapeTex;
        } else {
            frontDrapeTex = backDrapeTex = ImageUtils.getOrLoadTexture(url);
            topperTex = backDrapeTex;
            byte[] data = ImageUtils.getRawDataFromCache(url);
            if (data != null) {
                pendingFrontBackTransforms.add(key);
                frontDrapeTex = backDrapeTex = LOADING_TEXTURE;
                topperTex = backDrapeTex;
                executor.submit(() -> {
                    block22: {
                        try {
                            int frontH;
                            if (ImageUtils.isGif(data)) {
                                int totalDuration;
                                int[] delays;
                                ArrayList<NativeImage> nativeToppers = new ArrayList<NativeImage>();
                                ArrayList<NativeImage> nativeFronts = new ArrayList<NativeImage>();
                                ArrayList<NativeImage> nativeBacks = new ArrayList<NativeImage>();
                                try (ImageInputStream stream = ImageIO.createImageInputStream(new ByteArrayInputStream(data));){
                                    Iterator<ImageReader> readers = ImageIO.getImageReaders(stream);
                                    if (!readers.hasNext()) {
                                        throw new IOException("No GIF reader");
                                    }
                                    ImageReader reader = readers.next();
                                    reader.setInput(stream);
                                    int numFrames = reader.getNumImages(true);
                                    delays = new int[numFrames];
                                    int duration = 0;
                                    BufferedImage canvas = null;
                                    Graphics g = null;
                                    for (int i = 0; i < numFrames; ++i) {
                                        BufferedImage frameImage = reader.read(i);
                                        if (canvas == null) {
                                            canvas = new BufferedImage(reader.getWidth(0), reader.getHeight(0), 2);
                                            g = canvas.createGraphics();
                                        }
                                        IIOMetadata metadata = reader.getImageMetadata(i);
                                        IIOMetadataNode root = (IIOMetadataNode)metadata.getAsTree(metadata.getNativeMetadataFormatName());
                                        IIOMetadataNode gce = (IIOMetadataNode)root.getElementsByTagName("GraphicControlExtension").item(0);
                                        delays[i] = Integer.parseInt(gce.getAttribute("delayTime")) * 10;
                                        if (delays[i] <= 0) {
                                            delays[i] = 100;
                                        }
                                        duration += delays[i];
                                        String disposal = gce.getAttribute("disposalMethod");
                                        IIOMetadataNode desc = (IIOMetadataNode)root.getElementsByTagName("ImageDescriptor").item(0);
                                        int x = Integer.parseInt(desc.getAttribute("imageLeftPosition"));
                                        int y = Integer.parseInt(desc.getAttribute("imageTopPosition"));
                                        g.drawImage(frameImage, x, y, null);
                                        BufferedImage currentFrameToSplit = new BufferedImage(canvas.getWidth(), canvas.getHeight(), 2);
                                        currentFrameToSplit.createGraphics().drawImage((Image)canvas, 0, 0, null);
                                        int W = currentFrameToSplit.getWidth();
                                        int H = currentFrameToSplit.getHeight();
                                        float totalLengthBlocks = bedLength + 2.0f * drapeDepth;
                                        if (totalLengthBlocks <= 0.0f) continue;
                                        int frontH2 = Math.round(drapeDepth / totalLengthBlocks * (float)H);
                                        int midH = H - 2 * frontH2;
                                        if (frontH2 <= 0 || midH <= 0 || frontH2 + midH > H) continue;
                                        nativeBacks.add(ImageUtils.toNativeImage(currentFrameToSplit.getSubimage(0, 0, W, frontH2)));
                                        nativeToppers.add(ImageUtils.toNativeImage(currentFrameToSplit.getSubimage(0, frontH2, W, midH)));
                                        nativeFronts.add(ImageUtils.toNativeImage(currentFrameToSplit.getSubimage(0, frontH2 + midH, W, frontH2)));
                                        if (!disposal.equals("restoreToBackgroundColor")) continue;
                                        g.clearRect(x, y, frameImage.getWidth(), frameImage.getHeight());
                                    }
                                    totalDuration = duration;
                                    if (g != null) {
                                        g.dispose();
                                    }
                                }
                                mc.execute(() -> {
                                    AtomicInteger index = new AtomicInteger(0);
                                    ResourceLocation[] topperLocs = (ResourceLocation[])nativeToppers.stream().map(ni -> mc.m_91097_().m_118490_("dynamic/" + ImageUtils.sanitize(key + "_topper_" + index.getAndIncrement()), new DynamicTexture(ni))).toArray(ResourceLocation[]::new);
                                    index.set(0);
                                    ResourceLocation[] frontLocs = (ResourceLocation[])nativeFronts.stream().map(ni -> mc.m_91097_().m_118490_("dynamic/" + ImageUtils.sanitize(key + "_front_" + index.getAndIncrement()), new DynamicTexture(ni))).toArray(ResourceLocation[]::new);
                                    index.set(0);
                                    ResourceLocation[] backLocs = (ResourceLocation[])nativeBacks.stream().map(ni -> mc.m_91097_().m_118490_("dynamic/" + ImageUtils.sanitize(key + "_back_" + index.getAndIncrement()), new DynamicTexture(ni))).toArray(ResourceLocation[]::new);
                                    cachedAnimatedFrontBackTopper.put(key, new AnimatedTexture(topperLocs, delays, totalDuration));
                                    cachedAnimatedFrontDrape.put(key, new AnimatedTexture(frontLocs, delays, totalDuration));
                                    cachedAnimatedBackDrape.put(key, new AnimatedTexture(backLocs, delays, totalDuration));
                                    nativeToppers.clear();
                                    nativeFronts.clear();
                                    nativeBacks.clear();
                                });
                                break block22;
                            }
                            BufferedImage full = ImageIO.read(new ByteArrayInputStream(data));
                            int W = full.getWidth();
                            int H = full.getHeight();
                            float totalLengthBlocks = bedLength + 2.0f * drapeDepth;
                            if (totalLengthBlocks <= 0.0f) {
                                return;
                            }
                            int backH = frontH = Math.round(drapeDepth / totalLengthBlocks * (float)H);
                            int midH = H - frontH - backH;
                            if (frontH <= 0 || backH <= 0 || midH <= 0 || frontH + midH > H) {
                                return;
                            }
                            BufferedImage intendedBackDrapeImg = full.getSubimage(0, 0, W, frontH);
                            BufferedImage midImg = full.getSubimage(0, frontH, W, midH);
                            BufferedImage intendedFrontDrapeImg = full.getSubimage(0, frontH + midH, W, backH);
                            mc.execute(() -> {
                                cachedFrontDrape.put(key, ImageUtils.registerTextureFromImage(key + "_drape_front", intendedFrontDrapeImg, true));
                                cachedFrontBackTopper.put(key, ImageUtils.registerTextureFromImage(key + "_topper_frontback", midImg, true));
                                cachedBackDrape.put(key, ImageUtils.registerTextureFromImage(key + "_drape_back", intendedBackDrapeImg, true));
                            });
                        }
                        catch (RasterFormatException | IOException e) {
                            System.err.println("Error splitting texture " + key + ": " + e.getMessage());
                            blacklist.add(url);
                        }
                        finally {
                            pendingFrontBackTransforms.remove(key);
                        }
                    }
                });
            }
        }
        int uL = packedLight & 0xFFFF;
        int vL = packedLight >> 16 & 0xFFFF;
        int uO = packedOverlay & 0xFFFF;
        int vO = packedOverlay >> 16 & 0xFFFF;
        float topperY = 1.02f;
        float frontDrapeZ = -bedLength / 2.0f - 0.01f;
        float backDrapeZ = bedLength / 2.0f + 0.01f;
        ps.m_85836_();
        ps.m_252880_(0.0f, topperY, 0.0f);
        ps.m_252781_(Axis.f_252529_.m_252977_(90.0f));
        PoseStack.Pose p = ps.m_85850_();
        VertexConsumer buf = bufSrc.m_6299_(RenderType.m_110497_((ResourceLocation)topperTex));
        float hw = bedWidth / 2.0f;
        float hl = bedLength / 2.0f;
        hl += 0.01f;
        Matrix4f matrix = p.m_252922_();
        Vector3f nUp = new Vector3f(0.0f, 1.0f, 0.0f);
        matrix.transformDirection(nUp);
        Vector3f nDown = new Vector3f(0.0f, -1.0f, 0.0f);
        matrix.transformDirection(nDown);
        buf.m_252986_(matrix, -hw, -hl, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 1.0f).m_7122_(uO, vO).m_7120_(uL, vL).m_5601_(nUp.x(), nUp.y(), nUp.z()).m_5752_();
        buf.m_252986_(matrix, hw, -hl, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 1.0f).m_7122_(uO, vO).m_7120_(uL, vL).m_5601_(nUp.x(), nUp.y(), nUp.z()).m_5752_();
        buf.m_252986_(matrix, hw, hl, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 0.0f).m_7122_(uO, vO).m_7120_(uL, vL).m_5601_(nUp.x(), nUp.y(), nUp.z()).m_5752_();
        buf.m_252986_(matrix, -hw, hl, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 0.0f).m_7122_(uO, vO).m_7120_(uL, vL).m_5601_(nUp.x(), nUp.y(), nUp.z()).m_5752_();
        buf.m_252986_(matrix, -hw, hl, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 0.0f).m_7122_(uO, vO).m_7120_(uL, vL).m_5601_(nDown.x(), nDown.y(), nDown.z()).m_5752_();
        buf.m_252986_(matrix, hw, hl, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 0.0f).m_7122_(uO, vO).m_7120_(uL, vL).m_5601_(nDown.x(), nDown.y(), nDown.z()).m_5752_();
        buf.m_252986_(matrix, hw, -hl, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 1.0f).m_7122_(uO, vO).m_7120_(uL, vL).m_5601_(nDown.x(), nDown.y(), nDown.z()).m_5752_();
        buf.m_252986_(matrix, -hw, -hl, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 1.0f).m_7122_(uO, vO).m_7120_(uL, vL).m_5601_(nDown.x(), nDown.y(), nDown.z()).m_5752_();
        ps.m_85849_();
        ps.m_85836_();
        ps.m_252880_(0.0f, topperY, frontDrapeZ);
        p = ps.m_85850_();
        buf = bufSrc.m_6299_(RenderType.m_110497_((ResourceLocation)frontDrapeTex));
        hw = bedWidth / 2.0f;
        float d = drapeDepth;
        matrix = p.m_252922_();
        Vector3f bn = new Vector3f(0.0f, 0.0f, -1.0f);
        matrix.transformDirection(bn);
        Vector3f fn = new Vector3f(0.0f, 0.0f, 1.0f);
        matrix.transformDirection(fn);
        buf.m_252986_(matrix, -hw, -d, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 1.0f).m_7122_(uO, vO).m_7120_(uL, vL).m_5601_(bn.x(), bn.y(), bn.z()).m_5752_();
        buf.m_252986_(matrix, hw, -d, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 1.0f).m_7122_(uO, vO).m_7120_(uL, vL).m_5601_(bn.x(), bn.y(), bn.z()).m_5752_();
        buf.m_252986_(matrix, hw, 0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 0.0f).m_7122_(uO, vO).m_7120_(uL, vL).m_5601_(bn.x(), bn.y(), bn.z()).m_5752_();
        buf.m_252986_(matrix, -hw, 0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 0.0f).m_7122_(uO, vO).m_7120_(uL, vL).m_5601_(bn.x(), bn.y(), bn.z()).m_5752_();
        buf.m_252986_(matrix, -hw, 0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 0.0f).m_7122_(uO, vO).m_7120_(uL, vL).m_5601_(fn.x(), fn.y(), fn.z()).m_5752_();
        buf.m_252986_(matrix, hw, 0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 0.0f).m_7122_(uO, vO).m_7120_(uL, vL).m_5601_(fn.x(), fn.y(), fn.z()).m_5752_();
        buf.m_252986_(matrix, hw, -d, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 1.0f).m_7122_(uO, vO).m_7120_(uL, vL).m_5601_(fn.x(), fn.y(), fn.z()).m_5752_();
        buf.m_252986_(matrix, -hw, -d, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 1.0f).m_7122_(uO, vO).m_7120_(uL, vL).m_5601_(fn.x(), fn.y(), fn.z()).m_5752_();
        ps.m_85849_();
        ps.m_85836_();
        ps.m_252880_(0.0f, topperY, backDrapeZ);
        ps.m_252781_(Axis.f_252495_.m_252977_(180.0f));
        ps.m_85837_(0.0, 0.3, 0.0);
        p = ps.m_85850_();
        buf = bufSrc.m_6299_(RenderType.m_110497_((ResourceLocation)backDrapeTex));
        hw = bedWidth / 2.0f;
        d = drapeDepth;
        matrix = p.m_252922_();
        Vector3f fn2 = new Vector3f(0.0f, 0.0f, 1.0f);
        matrix.transformDirection(fn2);
        Vector3f bn2 = new Vector3f(0.0f, 0.0f, -1.0f);
        matrix.transformDirection(bn2);
        buf.m_252986_(matrix, -hw, -d, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 1.0f).m_7122_(uO, vO).m_7120_(uL, vL).m_5601_(fn2.x(), fn2.y(), fn2.z()).m_5752_();
        buf.m_252986_(matrix, hw, -d, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 1.0f).m_7122_(uO, vO).m_7120_(uL, vL).m_5601_(fn2.x(), fn2.y(), fn2.z()).m_5752_();
        buf.m_252986_(matrix, hw, 0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 0.0f).m_7122_(uO, vO).m_7120_(uL, vL).m_5601_(fn2.x(), fn2.y(), fn2.z()).m_5752_();
        buf.m_252986_(matrix, -hw, 0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 0.0f).m_7122_(uO, vO).m_7120_(uL, vL).m_5601_(fn2.x(), fn2.y(), fn2.z()).m_5752_();
        buf.m_252986_(matrix, -hw, 0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 0.0f).m_7122_(uO, vO).m_7120_(uL, vL).m_5601_(bn2.x(), bn2.y(), bn2.z()).m_5752_();
        buf.m_252986_(matrix, hw, 0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 0.0f).m_7122_(uO, vO).m_7120_(uL, vL).m_5601_(bn2.x(), bn2.y(), bn2.z()).m_5752_();
        buf.m_252986_(matrix, hw, -d, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 1.0f).m_7122_(uO, vO).m_7120_(uL, vL).m_5601_(bn2.x(), bn2.y(), bn2.z()).m_5752_();
        buf.m_252986_(matrix, -hw, -d, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 1.0f).m_7122_(uO, vO).m_7120_(uL, vL).m_5601_(bn2.x(), bn2.y(), bn2.z()).m_5752_();
        ps.m_85849_();
    }

    public static void renderImageFrontDrapeFromURL(PoseStack ps, MultiBufferSource bufSrc, int packedLight, int packedOverlay, float partialTick, float bedWidth, float bedLength, float drapeDepth, String url) {
        ResourceLocation frontDrapeTex;
        ResourceLocation topperTex;
        String key = url + "_split_front_" + bedLength + "_" + drapeDepth;
        if (cachedAnimatedSingleTopper.containsKey(key)) {
            topperTex = cachedAnimatedSingleTopper.get(key).getCurrentFrame();
            frontDrapeTex = cachedAnimatedSingleFrontDrape.get(key).getCurrentFrame();
        } else if (cachedSingleTopper.containsKey(key)) {
            topperTex = cachedSingleTopper.get(key);
            frontDrapeTex = cachedSingleFrontDrape.get(key);
        } else if (pendingSingleFrontTransforms.contains(key)) {
            topperTex = frontDrapeTex = LOADING_TEXTURE;
        } else {
            topperTex = frontDrapeTex = ImageUtils.getOrLoadTexture(url);
            byte[] data = ImageUtils.getRawDataFromCache(url);
            if (data != null) {
                pendingSingleFrontTransforms.add(key);
                topperTex = frontDrapeTex = LOADING_TEXTURE;
                executor.submit(() -> {
                    block22: {
                        try {
                            if (ImageUtils.isGif(data)) {
                                int totalDuration;
                                int[] delays;
                                ArrayList<NativeImage> nativeToppers = new ArrayList<NativeImage>();
                                ArrayList<NativeImage> nativeDrapes = new ArrayList<NativeImage>();
                                try (ImageInputStream stream = ImageIO.createImageInputStream(new ByteArrayInputStream(data));){
                                    Iterator<ImageReader> readers = ImageIO.getImageReaders(stream);
                                    if (!readers.hasNext()) {
                                        throw new IOException("No GIF reader");
                                    }
                                    ImageReader reader = readers.next();
                                    reader.setInput(stream);
                                    int numFrames = reader.getNumImages(true);
                                    delays = new int[numFrames];
                                    int duration = 0;
                                    BufferedImage canvas = null;
                                    Graphics g = null;
                                    for (int i = 0; i < numFrames; ++i) {
                                        BufferedImage frameImage = reader.read(i);
                                        if (canvas == null) {
                                            canvas = new BufferedImage(reader.getWidth(0), reader.getHeight(0), 2);
                                            g = canvas.createGraphics();
                                        }
                                        IIOMetadata metadata = reader.getImageMetadata(i);
                                        IIOMetadataNode root = (IIOMetadataNode)metadata.getAsTree(metadata.getNativeMetadataFormatName());
                                        IIOMetadataNode gce = (IIOMetadataNode)root.getElementsByTagName("GraphicControlExtension").item(0);
                                        delays[i] = Integer.parseInt(gce.getAttribute("delayTime")) * 10;
                                        if (delays[i] <= 0) {
                                            delays[i] = 100;
                                        }
                                        duration += delays[i];
                                        String disposal = gce.getAttribute("disposalMethod");
                                        IIOMetadataNode desc = (IIOMetadataNode)root.getElementsByTagName("ImageDescriptor").item(0);
                                        int x = Integer.parseInt(desc.getAttribute("imageLeftPosition"));
                                        int y = Integer.parseInt(desc.getAttribute("imageTopPosition"));
                                        g.drawImage(frameImage, x, y, null);
                                        BufferedImage currentFrameToSplit = new BufferedImage(canvas.getWidth(), canvas.getHeight(), 2);
                                        currentFrameToSplit.createGraphics().drawImage((Image)canvas, 0, 0, null);
                                        int W = currentFrameToSplit.getWidth();
                                        int H = currentFrameToSplit.getHeight();
                                        float totalLengthBlocks = bedLength + drapeDepth;
                                        if (totalLengthBlocks <= 0.0f) continue;
                                        int drapeH = Math.round(drapeDepth / totalLengthBlocks * (float)H);
                                        int topperH = H - drapeH;
                                        if (drapeH <= 0 || topperH <= 0) continue;
                                        nativeToppers.add(ImageUtils.toNativeImage(currentFrameToSplit.getSubimage(0, 0, W, topperH)));
                                        nativeDrapes.add(ImageUtils.toNativeImage(currentFrameToSplit.getSubimage(0, topperH, W, drapeH)));
                                        if (!disposal.equals("restoreToBackgroundColor")) continue;
                                        g.clearRect(x, y, frameImage.getWidth(), frameImage.getHeight());
                                    }
                                    totalDuration = duration;
                                    if (g != null) {
                                        g.dispose();
                                    }
                                }
                                mc.execute(() -> {
                                    AtomicInteger index = new AtomicInteger(0);
                                    ResourceLocation[] topperLocs = (ResourceLocation[])nativeToppers.stream().map(ni -> mc.m_91097_().m_118490_("dynamic/" + ImageUtils.sanitize(key + "_topper_" + index.getAndIncrement()), new DynamicTexture(ni))).toArray(ResourceLocation[]::new);
                                    index.set(0);
                                    ResourceLocation[] drapeLocs = (ResourceLocation[])nativeDrapes.stream().map(ni -> mc.m_91097_().m_118490_("dynamic/" + ImageUtils.sanitize(key + "_drape_" + index.getAndIncrement()), new DynamicTexture(ni))).toArray(ResourceLocation[]::new);
                                    cachedAnimatedSingleTopper.put(key, new AnimatedTexture(topperLocs, delays, totalDuration));
                                    cachedAnimatedSingleFrontDrape.put(key, new AnimatedTexture(drapeLocs, delays, totalDuration));
                                    nativeToppers.clear();
                                    nativeDrapes.clear();
                                });
                                break block22;
                            }
                            BufferedImage full = ImageIO.read(new ByteArrayInputStream(data));
                            int W = full.getWidth();
                            int H = full.getHeight();
                            float totalLengthBlocks = bedLength + drapeDepth;
                            if (totalLengthBlocks <= 0.0f) {
                                return;
                            }
                            int drapeH = Math.round(drapeDepth / totalLengthBlocks * (float)H);
                            int topperH = H - drapeH;
                            if (drapeH <= 0 || topperH <= 0) {
                                return;
                            }
                            BufferedImage topperImg = full.getSubimage(0, 0, W, topperH);
                            BufferedImage drapeImg = full.getSubimage(0, topperH, W, drapeH);
                            mc.execute(() -> {
                                cachedSingleFrontDrape.put(key, ImageUtils.registerTextureFromImage(key + "_drape_front", drapeImg, true));
                                cachedSingleTopper.put(key, ImageUtils.registerTextureFromImage(key + "_topper_front", topperImg, true));
                            });
                        }
                        catch (RasterFormatException | IOException e) {
                            System.err.println("Error splitting texture " + key + ": " + e.getMessage());
                            blacklist.add(url);
                        }
                        finally {
                            pendingSingleFrontTransforms.remove(key);
                        }
                    }
                });
            }
        }
        int uL = packedLight & 0xFFFF;
        int vL = packedLight >> 16 & 0xFFFF;
        int uO = packedOverlay & 0xFFFF;
        int vO = packedOverlay >> 16 & 0xFFFF;
        float topperY = 1.02f;
        float frontDrapeZ = -bedLength / 2.0f - 0.01f;
        ps.m_85836_();
        ps.m_252880_(0.0f, topperY, 0.0f);
        ps.m_252781_(Axis.f_252529_.m_252977_(90.0f));
        PoseStack.Pose p = ps.m_85850_();
        VertexConsumer buf = bufSrc.m_6299_(RenderType.m_110497_((ResourceLocation)topperTex));
        float hw = bedWidth / 2.0f;
        float hl = bedLength / 2.0f;
        hl += 0.01f;
        Matrix4f matrix = p.m_252922_();
        Vector3f nUp = new Vector3f(0.0f, 1.0f, 0.0f);
        matrix.transformDirection(nUp);
        Vector3f nDown = new Vector3f(0.0f, -1.0f, 0.0f);
        matrix.transformDirection(nDown);
        buf.m_252986_(matrix, -hw, -hl, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 1.0f).m_7122_(uO, vO).m_7120_(uL, vL).m_5601_(nUp.x(), nUp.y(), nUp.z()).m_5752_();
        buf.m_252986_(matrix, hw, -hl, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 1.0f).m_7122_(uO, vO).m_7120_(uL, vL).m_5601_(nUp.x(), nUp.y(), nUp.z()).m_5752_();
        buf.m_252986_(matrix, hw, hl, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 0.0f).m_7122_(uO, vO).m_7120_(uL, vL).m_5601_(nUp.x(), nUp.y(), nUp.z()).m_5752_();
        buf.m_252986_(matrix, -hw, hl, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 0.0f).m_7122_(uO, vO).m_7120_(uL, vL).m_5601_(nUp.x(), nUp.y(), nUp.z()).m_5752_();
        buf.m_252986_(matrix, -hw, hl, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 0.0f).m_7122_(uO, vO).m_7120_(uL, vL).m_5601_(nDown.x(), nDown.y(), nDown.z()).m_5752_();
        buf.m_252986_(matrix, hw, hl, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 0.0f).m_7122_(uO, vO).m_7120_(uL, vL).m_5601_(nDown.x(), nDown.y(), nDown.z()).m_5752_();
        buf.m_252986_(matrix, hw, -hl, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 1.0f).m_7122_(uO, vO).m_7120_(uL, vL).m_5601_(nDown.x(), nDown.y(), nDown.z()).m_5752_();
        buf.m_252986_(matrix, -hw, -hl, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 1.0f).m_7122_(uO, vO).m_7120_(uL, vL).m_5601_(nDown.x(), nDown.y(), nDown.z()).m_5752_();
        ps.m_85849_();
        ps.m_85836_();
        ps.m_252880_(0.0f, topperY, frontDrapeZ);
        p = ps.m_85850_();
        buf = bufSrc.m_6299_(RenderType.m_110497_((ResourceLocation)frontDrapeTex));
        hw = bedWidth / 2.0f;
        float d = drapeDepth;
        matrix = p.m_252922_();
        Vector3f nOut = new Vector3f(0.0f, 0.0f, -1.0f);
        matrix.transformDirection(nOut);
        Vector3f nIn = new Vector3f(0.0f, 0.0f, 1.0f);
        matrix.transformDirection(nIn);
        buf.m_252986_(matrix, -hw, -d, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 1.0f).m_7122_(uO, vO).m_7120_(uL, vL).m_5601_(nOut.x(), nOut.y(), nOut.z()).m_5752_();
        buf.m_252986_(matrix, hw, -d, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 1.0f).m_7122_(uO, vO).m_7120_(uL, vL).m_5601_(nOut.x(), nOut.y(), nOut.z()).m_5752_();
        buf.m_252986_(matrix, hw, 0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 0.0f).m_7122_(uO, vO).m_7120_(uL, vL).m_5601_(nOut.x(), nOut.y(), nOut.z()).m_5752_();
        buf.m_252986_(matrix, -hw, 0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 0.0f).m_7122_(uO, vO).m_7120_(uL, vL).m_5601_(nOut.x(), nOut.y(), nOut.z()).m_5752_();
        buf.m_252986_(matrix, -hw, 0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 0.0f).m_7122_(uO, vO).m_7120_(uL, vL).m_5601_(nIn.x(), nIn.y(), nIn.z()).m_5752_();
        buf.m_252986_(matrix, hw, 0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 0.0f).m_7122_(uO, vO).m_7120_(uL, vL).m_5601_(nIn.x(), nIn.y(), nIn.z()).m_5752_();
        buf.m_252986_(matrix, hw, -d, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 1.0f).m_7122_(uO, vO).m_7120_(uL, vL).m_5601_(nIn.x(), nIn.y(), nIn.z()).m_5752_();
        buf.m_252986_(matrix, -hw, -d, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 1.0f).m_7122_(uO, vO).m_7120_(uL, vL).m_5601_(nIn.x(), nIn.y(), nIn.z()).m_5752_();
        ps.m_85849_();
    }

    static {
        BufferedImage notFoundImage = ImageUtils.loadBufferedImageFromResource("picaxe", "textures/blocks/notfound.png");
        BufferedImage loadingImage = ImageUtils.loadBufferedImageFromResource("picaxe", "textures/blocks/loadingimage.png");
        BufferedImage combinedLoadingImage = new BufferedImage(notFoundImage.getWidth() + loadingImage.getWidth(), Math.max(notFoundImage.getHeight(), loadingImage.getHeight()), 2);
        Graphics2D g = combinedLoadingImage.createGraphics();
        g.drawImage((Image)loadingImage, 0, 0, null);
        g.drawImage((Image)notFoundImage, loadingImage.getWidth(), 0, null);
        g.dispose();
        NOT_FOUND_TEXTURE = ImageUtils.registerTextureFromImage("internal:notfound", notFoundImage, true);
        LOADING_TEXTURE = ImageUtils.registerTextureFromImage("internal:loading", combinedLoadingImage, true);
    }

    private record AnimatedTexture(ResourceLocation[] frames, int[] delays, int totalDuration) {
        public ResourceLocation getCurrentFrame() {
            if (this.frames == null || this.frames.length == 0) {
                return NOT_FOUND_TEXTURE;
            }
            if (this.frames.length <= 1) {
                return this.frames[0];
            }
            if (this.totalDuration == 0) {
                return this.frames[0];
            }
            long timeInAnimation = System.currentTimeMillis() % (long)this.totalDuration;
            int accumulatedDelay = 0;
            for (int i = 0; i < this.delays.length; ++i) {
                if (timeInAnimation >= (long)(accumulatedDelay += this.delays[i])) continue;
                return this.frames[i];
            }
            return this.frames[this.frames.length - 1];
        }
    }
}

