/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.compat;

import net.blay09.mods.cookingforblockheads.ForgeCookingForBlockheads;
import net.blay09.mods.cookingforblockheads.api.capability.DefaultKitchenConnector;
import net.blay09.mods.cookingforblockheads.api.capability.IKitchenConnector;
import net.blay09.mods.cookingforblockheads.api.capability.IKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.compat.ItemHandlerKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.compat.json.JsonCompatLoader;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(modid="cookingforblockheads")
public class CompatCapabilityLoader {
    private static KitchenConnectorCapabilityProvider connectorCapabilityProvider;
    private static ResourceLocation itemProviderResourceKey;
    private static ResourceLocation connectorResourceKey;
    private static final ItemStackHandler emptyItemHandler;

    @SubscribeEvent
    public static void attachTileEntityCapabilities(AttachCapabilitiesEvent<BlockEntity> event) {
        BlockEntity blockEntity = (BlockEntity)event.getObject();
        ResourceLocation blockEntityRegistryName = ForgeRegistries.BLOCK_ENTITY_TYPES.getKey((Object)blockEntity.m_58903_());
        if (JsonCompatLoader.kitchenItemProviders.contains(blockEntityRegistryName)) {
            if (itemProviderResourceKey == null) {
                itemProviderResourceKey = new ResourceLocation("cookingforblockheads", "kitchen_item_provider");
            }
            event.addCapability(itemProviderResourceKey, (ICapabilityProvider)new KitchenItemCapabilityProvider(blockEntity));
        }
        if (JsonCompatLoader.kitchenConnectors.contains(blockEntityRegistryName)) {
            if (connectorResourceKey == null) {
                connectorResourceKey = new ResourceLocation("cookingforblockheads", "kitchen_connector");
            }
            if (connectorCapabilityProvider == null) {
                connectorCapabilityProvider = new KitchenConnectorCapabilityProvider();
            }
            event.addCapability(connectorResourceKey, (ICapabilityProvider)connectorCapabilityProvider);
        }
    }

    static {
        emptyItemHandler = new ItemStackHandler(0);
    }

    private static final class KitchenItemCapabilityProvider
    implements ICapabilityProvider {
        private final LazyOptional<IKitchenItemProvider> itemProviderCap = LazyOptional.of(() -> {
            LazyOptional itemHandlerCap = entity.getCapability(ForgeCapabilities.ITEM_HANDLER, null);
            return new ItemHandlerKitchenItemProvider((IItemHandler)itemHandlerCap.orElse((Object)emptyItemHandler));
        });

        public KitchenItemCapabilityProvider(BlockEntity entity) {
        }

        public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
            return ForgeCookingForBlockheads.KITCHEN_ITEM_PROVIDER_CAPABILITY.orEmpty(capability, this.itemProviderCap);
        }
    }

    private static final class KitchenConnectorCapabilityProvider
    implements ICapabilityProvider {
        private final LazyOptional<IKitchenConnector> kitchenConnectorCap = LazyOptional.of(DefaultKitchenConnector::new);

        private KitchenConnectorCapabilityProvider() {
        }

        public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
            return ForgeCookingForBlockheads.KITCHEN_CONNECTOR_CAPABILITY.orEmpty(capability, this.kitchenConnectorCap);
        }
    }
}

